/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.jar;

import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.common.BatchDeployer;
import oracle.jdeveloper.deploy.common.BuildDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;
import oracle.jdeveloper.deploy.common.ModulePackager;
import oracle.jdeveloper.deploy.jar.ArchiveDeployer;
import oracle.jdevimpl.deploy.common.ProfileDependencyAnalyzer;

public class JarDeployerFactory
implements DeployerFactory {
    public static final int DEPENDENCY_ANALYZER = DeploymentManager.getDeploymentSequenceId("Deployment.DEPENDENCY_ANALYZER");

    @Override
    public Deployer newDeployer(int deploySequenceId, DeployShell shell) {
        if (deploySequenceId == DeploymentConstants.DEFAULT_SEQUENCE) {
            return new DynamicDeployer(DeploymentConstants.ARCHIVE_DEPLOYER);
        }
        if (deploySequenceId == DeploymentConstants.ARCHIVE_DEPLOYER) {
            return new ArchiveDeployer(deploySequenceId, shell);
        }
        if (deploySequenceId == DeploymentConstants.PACKAGING_SEQUENCE) {
            if (shell.getFlag("ignoreDependencies")) {
                return new BatchDeployer(DeploymentConstants.PACKAGING_SEQUENCE, new int[]{DeploymentConstants.BUILD_DEPLOYER, DeploymentConstants.MODULE_PACKAGER});
            }
            return new BatchDeployer(DeploymentConstants.PACKAGING_SEQUENCE, new int[]{DEPENDENCY_ANALYZER, DeploymentConstants.BUILD_DEPLOYER, DeploymentConstants.MODULE_PACKAGER});
        }
        if (deploySequenceId == DEPENDENCY_ANALYZER) {
            return new ProfileDependencyAnalyzer(deploySequenceId, shell);
        }
        if (deploySequenceId == DeploymentConstants.BUILD_DEPLOYER) {
            return new BuildDeployer(deploySequenceId, shell);
        }
        if (deploySequenceId == DeploymentConstants.MODULE_PACKAGER) {
            return new ModulePackager(deploySequenceId, shell);
        }
        return null;
    }
}

