/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.jar;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.Dirtyable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdeveloper.deploy.common.SelectedProjectFiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.jar.JarPackaging;
import oracle.jdevimpl.deploy.common.DependentLibrary;

public class ArchiveProfile
extends Profile
implements Copyable,
JarPackaging {
    private final boolean m_bShowJarSummary;
    private final boolean m_bShowDeployJarAction;
    private final boolean m_bShowCustomSummary;
    public static final String ACTION_DEPLOY_TO_JAR_FILE = "ArchiveProfile.deployToJarFile";
    public static final String ACTION_PREVIEW = "ArchiveProfile.preview";
    public static final String ACTION_SETTINGS_DIALOG = "ArchiveProfile.settingsDialog";

    public ArchiveProfile() {
        this(true, true, false);
    }

    public ArchiveProfile(HashStructure hash) {
        this(hash, true, true, false);
    }

    public ArchiveProfile(HashStructure hash, boolean showJarSummary, boolean showDeployJarAction, boolean showCustomSummary) {
        super(hash);
        this.m_bShowJarSummary = showJarSummary;
        this.m_bShowDeployJarAction = showDeployJarAction;
        this.m_bShowCustomSummary = showCustomSummary;
    }

    public ArchiveProfile(boolean showJarSummary, boolean showDeployJarAction, boolean showCustomSummary) {
        this._hash.setParentDirtyable((Dirtyable)this);
        this.setArchiveOptionsImpl(new ArchiveOptions());
        this.m_bShowJarSummary = showJarSummary;
        this.m_bShowDeployJarAction = showDeployJarAction;
        this.m_bShowCustomSummary = showCustomSummary;
    }

    public static ArchiveProfile newDefaultArchiveProfile() {
        return ArchiveProfile.newDefaultArchiveProfile(Project.class, null);
    }

    public static ArchiveProfile newDefaultArchiveProfile(Class<? extends ArchiveProfile> prototypeClass) {
        return ArchiveProfile.newDefaultArchiveProfile(Project.class, prototypeClass);
    }

    public static ArchiveProfile newDefaultArchiveProfile(Class<? extends DataContainer> profileContainerClass, Class<? extends ArchiveProfile> prototypeClass) {
        ArchiveProfile profile = ArchiveProfile.newLike(prototypeClass, null);
        profile.initArchiveProfile(profileContainerClass);
        return profile;
    }

    protected void initArchiveProfile(Class<? extends DataContainer> profileContainerClass) {
        FileGroups fileGroups = this.getFileGroups();
        fileGroups.addFileGroup(PackagingFileGroup.newDefaultGroup(profileContainerClass));
    }

    public boolean showJarSummary() {
        return this.m_bShowJarSummary;
    }

    public boolean showCustomSummary() {
        return this.m_bShowCustomSummary;
    }

    public boolean showDeployJarAction() {
        return this.m_bShowDeployJarAction;
    }

    public DefaultMutableTreeNode getCustomSummary() {
        return null;
    }

    @Override
    public URL getJarURL() {
        return this._hash.getURL("jarURL");
    }

    public void setJarURL(URL jarURL) {
        this._hash.putURL("jarURL", jarURL);
    }

    @Override
    public ArchiveOptions getArchiveOptions() {
        HashStructure archiveOptionsHash = this._hash.getOrCreateHashStructure("archiveOptions");
        return new ArchiveOptions(archiveOptionsHash);
    }

    public void setArchiveOptions(ArchiveOptions archiveOptions) {
        if (archiveOptions == null) {
            throw new IllegalArgumentException();
        }
        if (ModelUtil.areDifferent((Object)this.getArchiveOptions(), (Object)archiveOptions)) {
            this.setArchiveOptionsImpl(archiveOptions);
            this.markDirty(true);
        }
    }

    private void setArchiveOptionsImpl(ArchiveOptions archiveOptions) {
        this.unlinkEmbeddedDirtyable(this.getArchiveOptions());
        if (archiveOptions != null) {
            this._hash.putHashStructure("archiveOptions", archiveOptions.getHashStructure());
        } else {
            this._hash.putHashStructure("archiveOptions", null);
        }
        this.linkEmbeddedDirtyable(this.getArchiveOptions());
    }

    @Override
    public FileGroups getFileGroups() {
        HashStructure fileGroupHash = this._hash.getOrCreateHashStructure("fileGroups");
        return new FileGroups(fileGroupHash);
    }

    public void setFileGroups(FileGroups fileGroups) {
        if (ModelUtil.areDifferent((Object)this.getFileGroups(), (Object)fileGroups)) {
            this.setFileGroupsImpl(fileGroups);
            this.markDirty(true);
        }
    }

    private void setFileGroupsImpl(FileGroups fileGroups) {
        this.unlinkEmbeddedDirtyable(this.getFileGroups());
        if (fileGroups != null) {
            this._hash.putHashStructure("fileGroups", fileGroups.getHashStructure());
        } else {
            this._hash.putHashStructure("fileGroups", null);
        }
        this.linkEmbeddedDirtyable(this.getFileGroups());
    }

    public boolean isClasspathJar() {
        return true;
    }

    public void addFileGroup(FileGroup fileGroup) {
        if (fileGroup != null) {
            FileGroups groups = this.getFileGroups();
            if (groups == null) {
                groups = new FileGroups();
                this.setFileGroups(groups);
            }
            groups.addFileGroup(fileGroup);
        }
    }

    public PackagingFileGroup findPackagingFileGroup(String internalName) {
        FileGroups groups = this.getFileGroups();
        return groups != null ? groups.findPackagingFileGroup(internalName) : null;
    }

    public ProjectFileGroup findProjectFileGroup(String internalName) {
        FileGroups groups = this.getFileGroups();
        return groups != null ? groups.findProjectFileGroup(internalName) : null;
    }

    public LibraryFileGroup findLibraryFileGroup(String internalName) {
        FileGroups groups = this.getFileGroups();
        return groups != null ? groups.findLibraryFileGroup(internalName) : null;
    }

    public void selectLibraryForDeployment(Object id) {
        LibraryFileGroup lfg = this.findLibraryFileGroup("libraries");
        if (lfg != null) {
            lfg.addSelectedLibrary(id);
        }
    }

    protected List<LibraryFileGroup> findLibraryFileGroups() {
        FileGroup[] filegroups;
        ArrayList<LibraryFileGroup> libraryFileGroups = new ArrayList<LibraryFileGroup>();
        for (FileGroup fileGroup : filegroups = this.getFileGroups().getGroups()) {
            if (!(fileGroup instanceof LibraryFileGroup)) continue;
            libraryFileGroups.add((LibraryFileGroup)fileGroup);
        }
        return libraryFileGroups;
    }

    @Override
    public boolean resolvesLibrary(DependentLibrary library) {
        List<LibraryFileGroup> libraryFileGroups = this.findLibraryFileGroups();
        if (library != null && !libraryFileGroups.isEmpty()) {
            if (library.isDeployByDefault() && library.getResolvedBy() == null && library.getIgnoredBy() == null && (library.getExcludedBy() == null || library.getExcludedBy().equals(this))) {
                return true;
            }
            for (LibraryFileGroup libraryFileGroup : libraryFileGroups) {
                Object[] names = libraryFileGroup.getSelectedLibraries();
                if (names == null) continue;
                for (Object name : names) {
                    if (!name.toString().equals(library.getLibrary().getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canPackage(Element element) {
        return false;
    }

    public final SelectedProjectFiles getSelectedProjectFiles() throws TransientMarker {
        new Exception("Call to deprecated method").printStackTrace();
        return new SelectedProjectFiles();
    }

    private static ArchiveProfile newLike(Class<? extends ArchiveProfile> prototypeClass, HashStructure hash) {
        if (prototypeClass == null) {
            prototypeClass = ArchiveProfile.class;
        }
        try {
            if (hash == null) {
                return prototypeClass.newInstance();
            }
            Constructor<? extends ArchiveProfile> ctor = prototypeClass.getConstructor(HashStructure.class);
            return ctor.newInstance(hash);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

