/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt.wizard.spi;

import java.util.Arrays;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.dt.wizard.res.Bundle;
import oracle.jdeveloper.deploy.dt.wizard.spi.AbstractWizardState;
import oracle.jdeveloper.deploy.dt.wizard.spi.WizardState;
import oracle.jdeveloper.deploy.dt.wizard.spi.WizardStep;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitProvider;
import oracle.jdeveloper.deploy.tk.spi.SpiToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public abstract class AbstractWizardStateProvider
extends AbstractToolkitProvider {
    public AbstractWizardStateProvider(Class<? extends WizardState> stateClass) {
        super(stateClass);
    }

    protected void resolveStep(WizardState current, Element element, ToolkitContext tkContext, Class<? extends WizardStep> stepType) throws ToolkitBuildException {
        MainTkRegistryNarrowBuilder<WizardStep> builder = new MainTkRegistryNarrowBuilder<WizardStep>(tkContext, new WizardStep[0]);
        this.resolveStep_(builder, current, element, tkContext, stepType);
    }

    protected void spiResolveStep(WizardState current, Element element, ToolkitContext tkContext, Class<? extends WizardStep> stepType) throws ToolkitBuildException {
        SpiTkRegistryNarrowBuilder<WizardStep> builder = new SpiTkRegistryNarrowBuilder<WizardStep>(tkContext, new WizardStep[0]);
        this.resolveStep_(builder, current, element, tkContext, stepType);
    }

    private void resolveStep_(NarrowBuilder<WizardStep> builder, WizardState current, Element element, ToolkitContext tkContext, Class<? extends WizardStep> stepType) throws ToolkitBuildException {
        block4: {
            Context newIdeContext = new Context(tkContext.getIdeContext());
            AbstractWizardState.putWizardState(newIdeContext, current);
            try {
                WizardStep[] steps = builder.build(element, newIdeContext, stepType);
                if (steps.length > 0) {
                    current.setWizardStep(steps[0]);
                }
                assert (current.getWizardStep() != null);
            }
            catch (ToolkitBuildException e) {
                if (current.getWizardStep() != null) break block4;
                String errorMsg = String.format(Bundle.get("ABS_WIZARD_STATE_STEP_RESOLVE_ERROR"), current.getStateId());
                throw new ToolkitBuildException(errorMsg, e);
            }
        }
    }

    protected void resolveTransitions_(NarrowBuilder<WizardState> builder, WizardState current, Element element, ToolkitContext tkContext, Class<? extends WizardState> type) throws ToolkitBuildException {
        Object defaultState = current.getDefaultStateId();
        boolean defaultStateResolved = defaultState == null;
        for (Object tran : current.getExitTransitions()) {
            this.resolveTransition_(builder, current, element, tran, tkContext, type);
            if (defaultStateResolved) continue;
            defaultStateResolved = tran.equals(defaultState);
        }
        if (!defaultStateResolved) {
            this.resolveTransition_(builder, current, element, defaultState, tkContext, type);
        }
    }

    protected void resolveTransitions(WizardState current, Element element, ToolkitContext tkContext, Class<? extends WizardState> type) throws ToolkitBuildException {
        MainTkRegistryNarrowBuilder<WizardState> builder = new MainTkRegistryNarrowBuilder<WizardState>(tkContext, new WizardState[0]);
        this.resolveTransitions_(builder, current, element, tkContext, type);
    }

    protected void spiResolveTransitions(WizardState current, Element element, ToolkitContext tkContext, Class<? extends WizardState> type) throws ToolkitBuildException {
        SpiTkRegistryNarrowBuilder<WizardState> builder = new SpiTkRegistryNarrowBuilder<WizardState>(tkContext, new WizardState[0]);
        this.resolveTransitions_(builder, current, element, tkContext, type);
    }

    protected WizardState getParentWizardState(Context ideContext) {
        return AbstractWizardState.findWizardState(ideContext);
    }

    protected Object getParentExitTransition(Context ideContext) {
        return AbstractWizardState.findExitTransition(ideContext);
    }

    private void resolveTransition_(NarrowBuilder<WizardState> builder, WizardState current, Element element, Object tran, ToolkitContext tkContext, Class<? extends WizardState> type) {
        if (current.getBoundState(tran) != null) {
            return;
        }
        Context newIdeContext = new Context(tkContext.getIdeContext());
        AbstractWizardState.putWizardState(newIdeContext, current);
        AbstractWizardState.putExitTransition(newIdeContext, tran);
        try {
            WizardState[] states = builder.build(element, newIdeContext, type);
            assert (states.length > 0);
            current.bind(tran, states[0]);
        }
        catch (ToolkitBuildException e) {
            String errMsg = String.format(Bundle.get("ABS_WIZARD_STATE_TRANSITION_RESOLVE_ERROR"), tran, current.getStateId());
            throw new ToolkitBuildException(errMsg, e);
        }
    }

    private class SpiTkRegistryNarrowBuilder<T>
    implements NarrowBuilder<T> {
        final SpiToolkitRegistry tkReg_;
        final T[] ret_;

        SpiTkRegistryNarrowBuilder(ToolkitContext tkContext, T[] ret) {
            this.tkReg_ = tkContext.getSpiToolkitRegistry();
            this.ret_ = ret;
        }

        @Override
        public T[] build(Element element, Context context, Class<? extends T> type) {
            AbstractToolkitBuilder[] atbs = this.tkReg_.createBuilder(element, context, type);
            atbs = this.tkReg_.narrow(atbs);
            T[] steps = Arrays.copyOf(this.ret_, atbs.length);
            for (int i = 0; i < atbs.length; ++i) {
                steps[i] = atbs[i].getToolkit();
            }
            return steps;
        }
    }

    private class MainTkRegistryNarrowBuilder<T>
    implements NarrowBuilder<T> {
        final ToolkitRegistry tkReg_;
        final T[] ret_;

        MainTkRegistryNarrowBuilder(ToolkitContext context, T[] ret) {
            this.tkReg_ = context.getMainToolkitRegistry();
            this.ret_ = ret;
        }

        @Override
        public T[] build(Element element, Context context, Class<? extends T> type) {
            ToolkitBuilder b = this.tkReg_.getBuilder(element, context, type);
            return b.narrowBuildToolkits(this.ret_);
        }
    }

    static interface NarrowBuilder<T> {
        public T[] build(Element var1, Context var2, Class<? extends T> var3);
    }
}

