/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt.wizard.spi;

import java.util.LinkedHashMap;
import oracle.ide.Context;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.Step;
import oracle.jdeveloper.deploy.dt.wizard.spi.WizardState;

public abstract class AbstractWizardState
implements WizardState {
    final Object stateId_;
    WizardState parent_ = null;
    final LinkedHashMap<Object, WizardState> boundStates_ = new LinkedHashMap();

    protected AbstractWizardState(Object stateId) {
        assert (stateId != null);
        this.stateId_ = stateId;
    }

    @Override
    public Object getStateId() {
        return this.stateId_;
    }

    @Override
    public void setParentState(WizardState parent) {
        this.parent_ = parent;
    }

    @Override
    public WizardState getParentState() {
        return this.parent_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Object exitTran, WizardState state) {
        assert (exitTran.equals(this.getDefaultStateId()) || this.containsExitTransition(exitTran));
        LinkedHashMap<Object, WizardState> linkedHashMap = this.boundStates_;
        synchronized (linkedHashMap) {
            this.boundStates_.put(exitTran, state);
            state.setParentState(this);
        }
    }

    public static WizardState findWizardState(Context context) {
        return (WizardState)context.getProperty("Context.WizardState");
    }

    public static void putWizardState(Context context, WizardState state) {
        if (state == null) {
            context.removeProperty("Context.WizardState");
        } else {
            context.setProperty("Context.WizardState", (Object)state);
        }
    }

    public static Object findExitTransition(Context context) {
        return context.getProperty("Context.WizardStateExitTransition");
    }

    public static void putExitTransition(Context context, Object tran) {
        if (tran == null) {
            context.removeProperty("Context.WizardStateExitTransition");
        } else {
            context.setProperty("Context.WizardStateExitTransition", tran);
        }
    }

    @Override
    public abstract boolean containsExitTransition(Object var1);

    @Override
    public void buildState(FSMBuilder builder) {
        this.addState(builder);
        this.addTransitions(builder);
        for (WizardState state : this.boundStates_.values()) {
            state.buildState(builder);
        }
    }

    protected void addStartState(FSMBuilder builder, Step step, Object defaultTran) {
        builder.newStartState(step, defaultTran);
        if ("debug".equals(System.getProperty(WizardState.class.getName()))) {
            System.out.println("Adding StartState(" + step.getTraversableClass() + "," + defaultTran + ")");
        }
    }

    protected void addFinalState(FSMBuilder builder, Object stateId, Step step) {
        builder.newFinalState(stateId, step);
        if ("debug".equals(System.getProperty(WizardState.class.getName()))) {
            System.out.println("Adding FinalState(" + stateId + "," + step.getTraversableClass() + ")");
        }
    }

    protected void addState(FSMBuilder builder, Object stateId, Step step, Object defaultTran) {
        builder.newState(stateId, step, defaultTran, false);
        if ("debug".equals(System.getProperty(WizardState.class.getName()))) {
            System.out.println("Adding State(" + stateId + "," + step.getTraversableClass() + "," + defaultTran + ")");
        }
    }

    protected abstract void addState(FSMBuilder var1);

    protected abstract void addTransitions(FSMBuilder var1);
}

