/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt.wizard;

import java.awt.Window;
import javax.swing.JFrame;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.Wizard;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.dt.wizard.res.Bundle;
import oracle.jdeveloper.deploy.dt.wizard.spi.DeployWizardBuilder;
import oracle.jdeveloper.deploy.dt.wizard.spi.WizardBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;

public class DeployWizard
extends Wizard {
    Namespace data_ = null;

    public boolean isAvailable(Context context) {
        try {
            this.getWizardBuilder(context);
            return true;
        }
        catch (ToolkitBuildException toolkitBuildException) {
            return false;
        }
    }

    public boolean invoke(Context context) {
        try {
            WizardBuilder builder = this.getWizardBuilder(context);
            assert (builder != null);
            WizardDialog dialog = builder.buildWizardDialog((JFrame)Ide.getMainWindow());
            boolean retValue = dialog.runDialog();
            this.data_ = builder.getData();
            dialog.dispose();
            return retValue;
        }
        catch (ToolkitBuildException e) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e, (String)"The Deployment Wizard could not be constructed");
            return false;
        }
    }

    public DeployCommand getCommand() {
        return (DeployCommand)((Object)this.data_.find(DeployCommand.class));
    }

    public Namespace getData() {
        return this.data_;
    }

    private WizardBuilder getWizardBuilder(Context context) throws ToolkitBuildException {
        ToolkitRegistry tkReg = ToolkitRegistry.getInstance();
        ToolkitBuilder builder = tkReg.getBuilder(context, DeployWizardBuilder.class);
        WizardBuilder[] wizardBuilders = builder.narrowBuildToolkits(new WizardBuilder[0]);
        assert (wizardBuilders.length == 1);
        return wizardBuilders[0];
    }

    public String getShortLabel() {
        return Bundle.get("DEPLOY_WIZARD_SHORT_LABEL");
    }
}

