/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentPanelContent;
import oracle.jdeveloper.deploy.dt.InvalidProfileException;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.dt.ProfileOperationException;
import oracle.jdevimpl.deploy.DeploymentProfilesMigrator;
import oracle.jdevimpl.deploy.ProfileLibrary;
import oracle.jdevimpl.deploy.common.DataContainerNodeDependable;
import oracle.jdevimpl.deploy.common.DefaultProfileDependable;
import oracle.jdevimpl.deploy.common.DependableContainer;
import oracle.jdevimpl.deploy.res.DtArb;

public class DeploymentProfiles
extends HashStructureAdapter
implements Element {
    public static final String DATA_KEY = DeploymentProfiles.class.getName();
    private DataContainer _container = null;
    private ArrayList<Profile> profiles_ = null;
    private ArrayList<String> _unloaded_profile_names = new ArrayList();
    public static final String PROFILE_DEFINITIONS = "profileDefinitions";
    public static final String PROFILE_LIST = "profileList";
    public static final String DEFAULT_PROFILE_KEY = "DefaultProfile";
    public static final String DEFAULT_PROFILE_NAME = "ProfileName";

    private DeploymentProfiles(HashStructure hash, DataContainer container) {
        super(hash);
        this._container = container;
    }

    public static DeploymentProfiles getInstance(DataContainer container) {
        return DeploymentProfiles.getInstance(container, DeploymentProfiles.isCustomSettingsActive(container));
    }

    public static DeploymentProfiles getInstance(DataContainer container, boolean userPropertiesMode) {
        HashStructure properties = DeploymentProfiles.getContainerProperties(container, userPropertiesMode);
        return new DeploymentProfiles(properties.getOrCreateHashStructure(DATA_KEY), container);
    }

    private static HashStructure getContainerProperties(DataContainer container, boolean userPropertiesMode) {
        return userPropertiesMode ? container.getUserPropertiesOnly() : container.getSharedPropertiesOnly();
    }

    public void addProfile(Profile profile) throws InvalidProfileException, ProfileOperationException {
        if (!ModelUtil.hasLength((String)profile.getName())) {
            throw new ProfileOperationException("Only named profiles can be added to containers");
        }
        String name = profile.getName();
        HashStructure profileHashStructure = profile.getHashStructure();
        HashStructure profilesDefinitions = this.getProfileDefinitions();
        profilesDefinitions.putHashStructure(name, profileHashStructure);
        ListStructure profilesList = this.getProfileList();
        if (!profilesList.contains((Object)name)) {
            profilesList.add((Object)name);
        }
        if (this.profiles_ != null) {
            this.profiles_.add(profile);
        }
    }

    public void removeProfile(String profileName) throws InvalidProfileException, ProfileOperationException {
        if (!ModelUtil.hasLength((String)profileName)) {
            throw new ProfileOperationException("Profile must have a specified name. The given Profile's name is empty");
        }
        ListStructure profilesList = this.getProfileList();
        HashStructure profilesDefinitions = this.getProfileDefinitions();
        Profile profile = this.getProfileByName(profileName);
        if (profile == null) {
            throw new ProfileOperationException("Profile specified was not found inside the container");
        }
        profilesDefinitions.remove(profileName);
        profilesList.remove((Object)profileName);
        Profile defaultProfile = this.getDefaultDeploymentProfile();
        if (defaultProfile != null && profile.equals(defaultProfile)) {
            this._hash.remove(DEFAULT_PROFILE_KEY);
        }
        if (this.profiles_ != null) {
            this.profiles_.remove(profile);
        }
    }

    public static void projectMigrating(Project project, TraversableContext tc) {
        DeploymentProfiles.migrate(project, true, tc);
    }

    private static String replaceSuffix(URL oldURL, String newSuffix) {
        String fileName = oldURL.getFile();
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            fileName = fileName.substring(0, index);
        }
        fileName = fileName + newSuffix;
        return fileName;
    }

    private static boolean needsMigration(Project project, boolean shared, TraversableContext tc) {
        tc.put(DeploymentProfilesMigrator.MIGRATION_FROM_VERSION, (Object)DeploymentProfilesMigrator.MIGRATION_FROM_10);
        HashStructure projectProperties = shared ? project.getSharedPropertiesOnly() : project.getUserPropertiesOnly();
        HashStructure profilesHash = projectProperties.getHashStructure(DATA_KEY);
        if (profilesHash == null) {
            return true;
        }
        if (!profilesHash.containsKey(PROFILE_LIST) || !profilesHash.containsKey(PROFILE_DEFINITIONS)) {
            return true;
        }
        if (profilesHash.containsKey(PROFILE_DEFINITIONS)) {
            HashStructure profileDefinitions = profilesHash.getOrCreateHashStructure(PROFILE_DEFINITIONS);
            for (String name : profileDefinitions.keySet()) {
                HashStructure profileHashStructure = profileDefinitions.getHashStructure(name);
                int type = profileHashStructure.getInt("profileType");
                if (type == 0) continue;
                tc.put(DeploymentProfilesMigrator.MIGRATION_FROM_VERSION, (Object)DeploymentProfilesMigrator.MIGRATION_FROM_JM9);
                return true;
            }
        }
        return false;
    }

    private static void performPostMigrationAsNeeded(Project project, boolean shared, TraversableContext tc) {
        tc.put(DeploymentProfilesMigrator.MIGRATION_FROM_VERSION, (Object)DeploymentProfilesMigrator.MIGRATION_FROM_10);
        HashStructure projectProperties = shared ? project.getSharedPropertiesOnly() : project.getUserPropertiesOnly();
        HashStructure profilesHash = projectProperties.getHashStructure(DATA_KEY);
        if (profilesHash != null && profilesHash.containsKey(PROFILE_DEFINITIONS)) {
            HashStructure profileDefinitions = profilesHash.getOrCreateHashStructure(PROFILE_DEFINITIONS);
            for (String name : profileDefinitions.keySet()) {
                HashStructure profileHashStructure = profileDefinitions.getHashStructure(name);
                String type = profileHashStructure.getString("platformType");
                if (type == null || !type.equals("OC4J")) continue;
                profileHashStructure.putString("platformType", null, true);
            }
        }
    }

    private static void migrateFromJM9(Project project, boolean shared, TraversableContext tc) {
        HashStructure projectProperties = shared ? project.getSharedPropertiesOnly() : project.getUserPropertiesOnly();
        HashStructure profilesHash = projectProperties.getHashStructure(DATA_KEY);
        HashStructure profileDefinitions = profilesHash.getOrCreateHashStructure(PROFILE_DEFINITIONS);
        for (String DefinitionName : profileDefinitions.keySet()) {
            HashStructure profileHashStructure = profileDefinitions.getHashStructure(DefinitionName);
            int type = profileHashStructure.getInt("profileType");
            profileHashStructure.putString(Profile.PROFILE_CLASS_NAME, DeploymentProfilesMigrator.PROFILE_TYPE_TO_CLASS_CONVERTER[type]);
            profileHashStructure.remove("profileType");
            String name = profileHashStructure.getString("name");
            profileHashStructure.putString(Profile.PROFILE_NAME, name);
            profileHashStructure.remove("name");
            ListStructure newDependencyListHash = ListStructure.newInstance();
            ListStructure profileDeps = profileHashStructure.getOrCreateListStructure("profileDeps");
            Iterator depsIter = profileDeps.iterator();
            while (depsIter != null && depsIter.hasNext()) {
                HashStructure depHash = (HashStructure)depsIter.next();
                URL projectURL = depHash.getURL("projectURL");
                URL profileURL = depHash.getURL("profileURL");
                String pathInEar = depHash.getString("pathInEar");
                HashStructure itemHash = HashStructure.newInstance();
                if (URLFileSystem.hasSuffix((URL)profileURL, (String)".jar")) {
                    itemHash.putString("adapterClass", DataContainerNodeDependable.class.getName());
                    itemHash.putURL("ownerURL", projectURL);
                    itemHash.putURL("sourceURL", profileURL);
                } else {
                    itemHash.putString("adapterClass", DefaultProfileDependable.class.getName());
                    itemHash.putURL("ownerURL", projectURL);
                    String refPart = profileURL.getRef();
                    if (refPart == null) continue;
                    String profileName = "";
                    profileName = refPart.indexOf("#") == -1 ? refPart : refPart.substring(refPart.indexOf("#") + 1);
                    itemHash.putString("profileName", profileName);
                    if (pathInEar != null && pathInEar.length() != 0) {
                        itemHash.putString("pathInEar", pathInEar);
                    }
                }
                newDependencyListHash.add((Object)itemHash);
            }
            HashStructure dependenciesHash = HashStructure.newInstance();
            dependenciesHash.putListStructure(DependableContainer.DEPENDENCY_KEY, newDependencyListHash);
            profileHashStructure.putHashStructure(Profile.PROFILE_DEPENDENCIES, dependenciesHash);
            profileHashStructure.remove("profileDeps");
        }
    }

    private static void migrateFrom10(Project project, boolean shared, TraversableContext tc) {
        List projectDepList;
        DependencyConfiguration projectDepConfig;
        Set<Map.Entry<URL, String>> profileSet;
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        DeploymentProfilesMigrator migrator = (DeploymentProfilesMigrator)((Object)tc.get(DeploymentProfilesMigrator.DEPLOYMENT_PROFILES_MIGRATOR));
        Map<URL, String> profileMap = migrator.getProjectProfileMap(project);
        Set<Map.Entry<URL, String>> set = profileSet = profileMap != null ? profileMap.entrySet() : null;
        if (profileSet != null && profileSet.size() != 0) {
            Iterator<Map.Entry<URL, String>> profileIter = profileSet.iterator();
            while (profileIter != null && profileIter.hasNext()) {
                Map.Entry<URL, String> entry = profileIter.next();
                URL profileURL = entry.getKey();
                String newRefPart = entry.getValue();
                if (newRefPart == null || newRefPart.indexOf("#") != -1) continue;
                try {
                    Node node = NodeFactory.findOrCreate((URL)profileURL);
                    if (node == null) continue;
                    tc.put("Project", (Object)project);
                    tc.put(DeploymentProfilesMigrator.PROFILE_NODE, (Object)node);
                    Profile profile = DeploymentProfilesMigrator.getProfileFromPreFusionProfileNode(tc);
                    profile.migrate(tc);
                    profiles.add(profile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (profiles.size() > 0) {
            DeploymentProfiles deploymentProfiles = DeploymentProfiles.getInstance((DataContainer)project);
            deploymentProfiles.setDeploymentProfiles(profiles.toArray(new Profile[0]));
        }
        if ((projectDepConfig = DependencyConfiguration.getInstance((Project)project)) != null && (projectDepList = projectDepConfig.getDependencyList()) != null) {
            for (int i = 0; i < projectDepList.size(); ++i) {
                Dependable dep = (Dependable)projectDepList.get(i);
                if (!(dep instanceof ProfileLibrary)) continue;
                URL profileURL = ((ProfileLibrary)dep).getSourceURL();
                Project depOwner = (Project)dep.getSourceOwner();
                String refPart = migrator.getProfileRefPart(depOwner.getURL(), profileURL);
                if (refPart != null) {
                    profileURL = URLFactory.replaceRefPart((URL)depOwner.getURL(), (String)Profile.getProfileNameFromRef(refPart));
                    ProfileLibrary profileLibrary = new ProfileLibrary();
                    profileLibrary.setSourceURL(profileURL);
                    profileLibrary.setSourceOwnerURL(depOwner.getURL());
                    projectDepList.set(i, profileLibrary);
                    continue;
                }
                System.out.println("Could not find a profile with URL:" + profileURL);
            }
            projectDepConfig.setDependencyList(projectDepList);
        }
        if (migrator.isLastProjectToMigrate()) {
            Map<URL, String> workspaceProfileMap = migrator.getWorkspaceProfileMap();
            Set<Map.Entry<URL, String>> workspaceProfileSet = workspaceProfileMap.entrySet();
            Iterator<Map.Entry<URL, String>> workspaceProfileIterator = workspaceProfileSet.iterator();
            while (workspaceProfileIterator != null && workspaceProfileIterator.hasNext()) {
                Map.Entry<URL, String> entry = workspaceProfileIterator.next();
                URL profileURL = entry.getKey();
                String newRefPart = entry.getValue();
                try {
                    Node node = NodeFactory.findOrCreate((URL)profileURL);
                    if (!Deployment.isDeploymentProfile(node)) continue;
                    URL oldURL = node.getURL();
                    String newPath = newRefPart == null ? DeploymentProfiles.replaceSuffix(oldURL, ".dbexport") : oldURL.getPath() + ".bak";
                    URL newURL = URLFactory.replacePathPart((URL)oldURL, (String)newPath);
                    node.close();
                    NodeFactory.uncache((URL)oldURL);
                    node.rename(newURL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void migrate(Project project, boolean shared, TraversableContext tc) {
        if (DeploymentProfiles.needsMigration(project, shared, tc)) {
            String migrationFromVersion = (String)tc.get(DeploymentProfilesMigrator.MIGRATION_FROM_VERSION);
            if (migrationFromVersion.equals(DeploymentProfilesMigrator.MIGRATION_FROM_JM9)) {
                DeploymentProfiles.migrateFromJM9(project, shared, tc);
            } else if (migrationFromVersion.equals(DeploymentProfilesMigrator.MIGRATION_FROM_10)) {
                DeploymentProfiles.migrateFrom10(project, shared, tc);
            }
        }
        DeploymentProfiles.performPostMigrationAsNeeded(project, shared, tc);
    }

    private HashStructure getProfileDefinitions() {
        return this._hash.getOrCreateHashStructure(PROFILE_DEFINITIONS);
    }

    private ListStructure getProfileList() {
        return this._hash.getOrCreateListStructure(PROFILE_LIST);
    }

    public void setDefaultDeploymentProfile(Profile profile) {
        if (profile != null) {
            HashStructure defaultProfileHash = this._hash.getOrCreateHashStructure(DEFAULT_PROFILE_KEY);
            defaultProfileHash.putString(DEFAULT_PROFILE_NAME, profile.getName());
        } else {
            this._hash.remove(DEFAULT_PROFILE_KEY);
        }
    }

    private String getDefaultDeploymentProfileName() {
        HashStructure defaultProfileHash = this._hash.getOrCreateHashStructure(DEFAULT_PROFILE_KEY);
        String profileName = null;
        if (defaultProfileHash != null) {
            profileName = defaultProfileHash.getString(DEFAULT_PROFILE_NAME);
        }
        return profileName;
    }

    public Profile getDefaultDeploymentProfile() {
        return this.getProfileByName(this.getDefaultDeploymentProfileName());
    }

    @Deprecated
    public Map getDefinedProfiles(boolean longProfileName) {
        HashMap<Object, Profile> map = new HashMap<Object, Profile>();
        HashStructure profileDefinitions = this.getProfileDefinitions();
        for (String name : profileDefinitions.keySet()) {
            HashStructure profileHashStructure = profileDefinitions.getHashStructure(name);
            try {
                Profile profile = Deployment.createDeploymentProfile(profileHashStructure, this._container);
                if (longProfileName) {
                    URL longName = DeployUtil.getProfileURL(this._container.getURL(), profile);
                    map.put(longName, profile);
                    continue;
                }
                map.put(name, profile);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public Set getProfileNames() {
        TreeSet<String> set = new TreeSet<String>();
        HashStructure profileDefinitions = this.getProfileDefinitions();
        for (String name : profileDefinitions.keySet()) {
            set.add(name);
        }
        return set;
    }

    private static boolean isValidProfileName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        char ch = name.charAt(0);
        if (!Character.isJavaIdentifierStart(ch) || ch == '$') {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            ch = name.charAt(i);
            if ((ch == '-' || Character.isJavaIdentifierPart(ch)) && ch != '$') continue;
            return false;
        }
        return true;
    }

    public static void validateProfileName(Set usedNames, String profileName, String titlePrefix) throws TraversalException {
        if (usedNames != null && usedNames.contains(profileName)) {
            throw new TraversalException(DtArb.format(128, profileName), DtArb.format(127, titlePrefix));
        }
        if (profileName.length() < 3) {
            throw new TraversalException(DtArb.getString(125), DtArb.format(126, titlePrefix));
        }
        if (!DeploymentProfiles.isValidProfileName(profileName)) {
            throw new TraversalException(DtArb.getString(129), DtArb.format(130, titlePrefix));
        }
    }

    public Profile[] toSortedArray() {
        Profile[] profiles = this.getProfiles();
        Arrays.sort(profiles, new Comparator<Profile>(){

            @Override
            public int compare(Profile p1, Profile p2) {
                String name1 = p1.getName();
                if (name1 == null) {
                    name1 = "";
                }
                return name1.compareTo(p2.getName());
            }
        });
        return profiles;
    }

    public synchronized Profile[] getProfiles() {
        if (this.profiles_ == null) {
            this.loadProfiles();
        }
        return this.profiles_.toArray(new Profile[this.profiles_.size()]);
    }

    private void loadProfiles() {
        this.profiles_ = new ArrayList();
        HashStructure profileDefinitions = this.getProfileDefinitions();
        this._unloaded_profile_names = new ArrayList();
        for (String name : this.getProfileList()) {
            HashStructure profileHashStructure = profileDefinitions.getHashStructure(name);
            try {
                Profile profile = Deployment.createDeploymentProfile(profileHashStructure, this._container);
                this.profiles_.add(profile);
            }
            catch (InstantiationException e) {
                this._unloaded_profile_names.add(name);
            }
        }
    }

    public static boolean isCustomSettingsActive(DataContainer container) {
        HashStructure allChainedProperties = container.getProperties();
        HashStructure chained = allChainedProperties.getOrCreateHashStructure(DATA_KEY);
        return chained.isAnyValueOverridden(DeploymentPanelContent.getPropertyKeys());
    }

    public void setDeploymentProfiles(Profile[] profiles) {
        HashStructure profileDefinitions = this.getProfileDefinitions();
        ArrayList<String> tempList = new ArrayList<String>();
        for (String name : this._unloaded_profile_names) {
            tempList.add(name);
        }
        int size = profiles.length;
        for (int i = 0; i < size; ++i) {
            String name = profiles[i].getName();
            tempList.add(name);
            if (profileDefinitions.containsKey(name)) continue;
            profileDefinitions.putHashStructure(name, profiles[i].getHashStructure());
        }
        Collections.sort(tempList);
        ListStructure profileList = this.getProfileList();
        profileList.mirror(tempList);
        String[] names = profileDefinitions.keySet().toArray(new String[profileDefinitions.size()]);
        for (int i = names.length - 1; i >= 0; --i) {
            String name = names[i];
            if (tempList.contains(name)) continue;
            profileDefinitions.remove(name);
            if (!name.equals(this.getDefaultDeploymentProfileName())) continue;
            this.setDefaultDeploymentProfile(null);
        }
        this.loadProfiles();
    }

    @Deprecated
    public static Profile getProfileByShortLabel(DataContainer container, String name) {
        DeploymentProfiles depProfiles = DeploymentProfiles.getInstance(container);
        if (depProfiles == null) {
            return null;
        }
        Profile[] allProfiles = depProfiles.getProfiles();
        for (int i = 0; i < allProfiles.length; ++i) {
            Profile profile = allProfiles[i];
            if (name.equals(profile.getShortLabel())) {
                return profile;
            }
            if (!profile.mayHaveChildren()) continue;
            Iterator subProfileIterator = profile.getChildren();
            while (subProfileIterator != null && subProfileIterator.hasNext()) {
                Profile subProfile = (Profile)subProfileIterator.next();
                if (!subProfile.getShortLabel().equals(name)) continue;
                return subProfile;
            }
        }
        return null;
    }

    @Deprecated
    private static Profile getProfileByName(DataContainer container, String name, boolean createTemp) {
        DeploymentProfiles deploymentProfiles;
        HashStructure profileDefinitions;
        HashStructure profileHashStructure;
        if (name.indexOf("#") > 0) {
            StringTokenizer st = new StringTokenizer(name, "#");
            String parentName = st.nextToken();
            String childName = st.nextToken();
            Profile parent = DeploymentProfiles.getProfileByName(container, parentName, createTemp);
            Iterator children = parent.getChildren();
            while (children.hasNext()) {
                Profile child = (Profile)children.next();
                if (!child.getName().equals(childName)) continue;
                return child;
            }
        }
        if ((profileHashStructure = (profileDefinitions = (deploymentProfiles = DeploymentProfiles.getInstance(container)).getProfileDefinitions()).getHashStructure(name)) == null) {
            if (createTemp) {
                profileHashStructure = HashStructure.newInstance();
            } else {
                return null;
            }
        }
        try {
            Profile profile = Deployment.createDeploymentProfile(profileHashStructure, container);
            return profile;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Profile getProfileByName(String name) {
        Profile[] profiles;
        if (name == null) {
            return null;
        }
        for (Profile p : profiles = this.getProfiles()) {
            if (name.equals(p.getName())) {
                return p;
            }
            if (!p.mayHaveChildren()) continue;
            Iterator iter = p.getChildren();
            while (iter != null && iter.hasNext()) {
                Profile child = (Profile)iter.next();
                if (!name.equals(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    @Deprecated
    public static boolean profileExists(DataContainer container, Profile profile) {
        if (profile.isContainedProfile()) {
            Profile tempProfile = DeploymentProfiles.getProfileByName(container, profile.getParentProfileName(), false);
            if (tempProfile != null && tempProfile.mayHaveChildren()) {
                Iterator profileIter = tempProfile.getChildren();
                while (profileIter != null && profileIter.hasNext()) {
                    Profile childProfile = (Profile)profileIter.next();
                    if (childProfile == null || !childProfile.getName().equals(profile.getName())) continue;
                    return true;
                }
            }
        } else {
            Profile tempProfile = DeploymentProfiles.getProfileByName(container, profile.getName(), false);
            if (profile != null) {
                return true;
            }
        }
        return false;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Iterator getChildren() {
        return new ProfileIterator(this);
    }

    public Attributes getAttributes() {
        return null;
    }

    public Object getData() {
        return this;
    }

    public String getShortLabel() {
        return this._container.getShortLabel();
    }

    public String getLongLabel() {
        return this._container.getLongLabel();
    }

    public Icon getIcon() {
        return this._container.getIcon();
    }

    public String getToolTipText() {
        return this._container.getToolTipText();
    }

    public String toString() {
        return this._container.toString();
    }

    public class ProfileIterator
    implements Iterator {
        private final Iterator _iter;

        ProfileIterator(DeploymentProfiles profiles) {
            this._iter = Arrays.asList(profiles.getProfiles()).iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        public Object next() {
            return this._iter.next();
        }

        @Override
        public void remove() {
            this._iter.remove();
        }
    }
}

