/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.Colors;
import oracle.javatools.ui.RichHintLabel;
import oracle.jdeveloper.deploy.AutoSyncSettings;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.SecurityDeploymentSettings;
import oracle.jdeveloper.deploy.dt.DeployProfileDt;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdevimpl.deploy.common.DependentLibrary;
import oracle.jdevimpl.deploy.common.LibraryToolkitHelper;
import oracle.jdevimpl.deploy.res.DtArb;

public final class DeploymentPanelContent
implements ActionListener {
    private JPanel _panel;
    private DataContainer _dc;
    private JButton editButton;
    private JButton newButton;
    private JButton deleteButton;
    private JButton setDefaultButton;
    private Profile _defaultProfile;
    private JTreeCellData _defaultProfileCellData;
    private JMutableTreeNode _root = new JMutableTreeNode(new JTreeCellData(""));
    private DefaultTreeModel _treeModel = new DefaultTreeModel((TreeNode)this._root);
    private CustomJTree _tree = new CustomJTree((TreeModel)this._treeModel);
    private JScrollPane profileTreePane = new JScrollPane();
    private JCheckBox _autoSyncJdbc = new JCheckBox();
    private JCheckBox _overwriteApplicationPolicies = new JCheckBox();
    private JCheckBox _overwriteCredentials = new JCheckBox();
    private JCheckBox _migrateUsersAndGroups = new JCheckBox();
    private Set usedNames = new TreeSet();
    private List newlyCreatedProfiles = new ArrayList();
    private DeploymentProfiles _deploymentProfiles;
    private TraversableContext _tc;
    private boolean _isAppLevel;
    private AutoSyncSettings _ass;
    private SecurityDeploymentSettings _sds;
    public static final String CUSTOM_SETTINGS_ACTIVE = "Custom-Settings-Active";
    private static final String[] PROPERTY_KEYS = new String[]{"profileDefinitions", "profileList"};

    static String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public DeploymentPanelContent(JPanel panel) {
        this(panel, false);
    }

    public DeploymentPanelContent(JPanel panel, boolean isAppLevel) {
        this._panel = panel;
        this._tree.setRootVisible(false);
        this._isAppLevel = isAppLevel;
        this.profileTreePane.getViewport().add((Component)this._tree, null);
        JLabel profilesLabel = new JLabel();
        this.editButton = new JButton();
        this.newButton = new JButton();
        this.deleteButton = new JButton();
        this.setDefaultButton = new JButton();
        ResourceUtils.resLabel((JLabel)profilesLabel, (Component)this._tree, (String)DtArb.getString(116));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)DtArb.getString(117));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)DtArb.getString(118));
        ResourceUtils.resButton((AbstractButton)this.deleteButton, (String)DtArb.getString(119));
        ResourceUtils.resButton((AbstractButton)this.setDefaultButton, (String)DtArb.getString(120));
        this._tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DeploymentPanelContent.this.updateButtons();
            }
        });
        this._tree.addMouseListener((MouseListener)new MouseAdapter(){
            DefaultMutableTreeNode node;

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path = DeploymentPanelContent.this._tree.getPathForLocation(e.getX(), e.getY());
                if (path != null && e.getClickCount() == 2) {
                    DeploymentPanelContent.this.editProfile();
                }
            }
        });
        this.editButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.setDefaultButton.addActionListener(this);
        this._panel.setLayout(new GridBagLayout());
        int x = 0;
        int y = 0;
        this._panel.add((Component)profilesLabel, new GridBagConstraints(x, y, 0, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 0, 0));
        if (isAppLevel) {
            this._panel.add((Component)this.profileTreePane, new GridBagConstraints(x, ++y, 1, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this._panel.add((Component)this.profileTreePane, new GridBagConstraints(x, ++y, 1, 0, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this._panel.add((Component)this.editButton, new GridBagConstraints(++x, y, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this._panel.add((Component)this.newButton, new GridBagConstraints(x, ++y, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this._panel.add((Component)this.deleteButton, new GridBagConstraints(x, ++y, 0, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        if (this._isAppLevel) {
            ResourceUtils.resButton((AbstractButton)this._autoSyncJdbc, (String)DtArb.getString(135));
            this._autoSyncJdbc.addActionListener(this);
            this._panel.add((Component)this._autoSyncJdbc, new GridBagConstraints(0, ++y, 0, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            if (this._ass != null && this._ass.getAutoSyncFlag()) {
                this._autoSyncJdbc.setSelected(true);
            } else {
                this._autoSyncJdbc.setSelected(false);
            }
            JPanel securityDeploymentOptions = this.createSecurityDeploymentOptionsPanel();
            securityDeploymentOptions.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(DtArb.getString(138)), BorderFactory.createEmptyBorder(0, 8, 8, 8)));
            this._panel.add((Component)securityDeploymentOptions, new GridBagConstraints(0, ++y, 0, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
            this._panel.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 0, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    private JPanel createSecurityDeploymentOptionsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this._overwriteApplicationPolicies, (String)DtArb.getString(139));
        ResourceUtils.resButton((AbstractButton)this._overwriteCredentials, (String)DtArb.getString(140));
        ResourceUtils.resButton((AbstractButton)this._migrateUsersAndGroups, (String)DtArb.getString(141));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 17;
        gbc.fill = 2;
        RichHintLabel labelOverwrite = new RichHintLabel();
        labelOverwrite.setHtmlText(DtArb.getString(142));
        labelOverwrite.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        RichHintLabel labelMigrate = new RichHintLabel();
        labelMigrate.setHtmlText(DtArb.getString(143));
        labelMigrate.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        panel.add((Component)labelOverwrite, gbc);
        panel.add((Component)this._overwriteApplicationPolicies, gbc);
        panel.add((Component)this._overwriteCredentials, gbc);
        panel.add((Component)labelMigrate, gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        panel.add((Component)this._migrateUsersAndGroups, gbc);
        this._overwriteApplicationPolicies.setSelected(this._sds != null && this._sds.getOverwriteApplicationPoliciesFlag());
        this._overwriteCredentials.setSelected(this._sds != null && this._sds.getOverwriteCredentialsFlag());
        this._migrateUsersAndGroups.setSelected(this._sds != null && this._sds.getMigrateUsersAndGroupsFlag());
        this._overwriteApplicationPolicies.addActionListener(this);
        this._overwriteCredentials.addActionListener(this);
        this._migrateUsersAndGroups.addActionListener(this);
        return panel;
    }

    protected JMutableTreeNode addProfileToTree(Profile profile, JMutableTreeNode parentTreeNode) {
        JTreeCellData cellData = this.createJTreeCellData(profile);
        if (cellData != null) {
            cellData.setUserObject((Object)profile);
            JMutableTreeNode childTreeNode = new JMutableTreeNode(cellData);
            parentTreeNode.add((MutableTreeNode)childTreeNode);
            Iterator iter = profile.getChildren();
            if (iter != null) {
                ArrayList<JMutableTreeNode> childrenToAdd = new ArrayList<JMutableTreeNode>();
                while (iter.hasNext()) {
                    Profile childProfile = (Profile)iter.next();
                    JTreeCellData childCellData = this.createJTreeCellData(childProfile);
                    if (childCellData == null) continue;
                    childCellData.setUserObject((Object)childProfile);
                    childrenToAdd.add(new JMutableTreeNode(childCellData));
                }
                if (childrenToAdd.size() > 0) {
                    Collections.sort(childrenToAdd, new JMTNComparator());
                    Iterator addIter = childrenToAdd.iterator();
                    while (addIter.hasNext()) {
                        childTreeNode.add((MutableTreeNode)((JMutableTreeNode)addIter.next()));
                    }
                }
            }
            return childTreeNode;
        }
        return null;
    }

    protected void addChildren(Element parentElem, JMutableTreeNode parentTreeNode) {
        Iterator iter = parentElem.getChildren();
        ArrayList<JMutableTreeNode> childrenToAdd = new ArrayList<JMutableTreeNode>();
        if (iter != null) {
            while (iter.hasNext()) {
                Object child = iter.next();
                Profile profile = (Profile)child;
                JTreeCellData cellData = this.createJTreeCellData(profile);
                if (cellData == null) continue;
                cellData.setUserObject((Object)profile);
                JMutableTreeNode childTreeNode = new JMutableTreeNode(cellData);
                childrenToAdd.add(childTreeNode);
                if (!profile.mayHaveChildren()) continue;
                this.addChildren(profile, childTreeNode);
            }
        }
        if (childrenToAdd.size() > 0) {
            Collections.sort(childrenToAdd, new JMTNComparator());
            Iterator addIter = childrenToAdd.iterator();
            while (addIter.hasNext()) {
                parentTreeNode.add((MutableTreeNode)((JMutableTreeNode)addIter.next()));
            }
        }
    }

    protected JTreeCellData createJTreeCellData(Element elem) {
        JTreeCellData treeCellData = new JTreeCellData(elem.getIcon(), this.getElementDisplayLabel(elem), false);
        treeCellData.setToolTipText(elem.getToolTipText());
        if (this.isDefaultProfile(elem)) {
            this._defaultProfileCellData = treeCellData;
        }
        return treeCellData;
    }

    private Profile getSelectedProfile() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        JTreeCellData cellData = (JTreeCellData)node.getUserObject();
        return (Profile)cellData.getUserObject();
    }

    private boolean isSelectedProfileaChild() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return false;
        }
        return node.getLevel() > 1;
    }

    public void setTraversableContext(TraversableContext tc) {
        this._tc = tc;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.editButton) {
            this.editProfile();
        } else if (source == this.newButton) {
            this.newProfile();
        } else if (source == this.deleteButton) {
            this.deleteProfile();
        } else if (source == this.setDefaultButton) {
            this.setDefaultProfile();
        } else if (this._isAppLevel && source == this._autoSyncJdbc) {
            if (this._ass != null && this._autoSyncJdbc.isSelected()) {
                this._ass.setAutoSyncFlag(Boolean.TRUE);
            } else {
                this._ass.setAutoSyncFlag(Boolean.FALSE);
            }
        } else if (source == this._overwriteApplicationPolicies && this._isAppLevel && this._sds != null) {
            this._sds.setOverwriteApplicationPoliciesFlag(this._overwriteApplicationPolicies.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        } else if (source == this._overwriteCredentials && this._isAppLevel && this._sds != null) {
            this._sds.setOverwriteCredentialsFlag(this._overwriteCredentials.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        } else if (source == this._migrateUsersAndGroups && this._isAppLevel && this._sds != null) {
            this._sds.setMigrateUsersAndGroupsFlag(this._migrateUsersAndGroups.isSelected() ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    void setSelectionRow() {
        Profile editedProfile;
        this._tree.setSelectionRow(0);
        Context context = (Context)this._tc.find(Context.class);
        if (context != null && (editedProfile = (Profile)context.getProperty("edited-profile")) != null) {
            TreeModel model = this._tree.getModel();
            Object root = model.getRoot();
            for (int i = 0; i < model.getChildCount(root); ++i) {
                Object object = model.getChild(root, i);
                JMutableTreeNode treeNode = (JMutableTreeNode)model.getChild(root, i);
                JTreeCellData cellData = (JTreeCellData)treeNode.getUserObject();
                if (!cellData.getUserObject().equals(editedProfile)) continue;
                this._tree.setSelectionRow(i);
                break;
            }
        }
    }

    void loadFrom(DataContainer dc) {
        this._dc = dc;
        this._deploymentProfiles = DeploymentProfiles.getInstance(this._dc, ProjectSettingsTraversablePanel.editingUserProperties((Namespace)this._tc));
        this._root.removeAllChildren();
        this._defaultProfile = this._deploymentProfiles.getDefaultDeploymentProfile();
        this.addChildren(this._deploymentProfiles, this._root);
        this.updateButtons();
        this.usedNames = this._deploymentProfiles.getProfileNames();
        this._tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)this._root));
        this.setSelectionRow();
        this._ass = AutoSyncSettings.getInstance(dc);
        if (this._isAppLevel && this._ass != null && this._ass.getAutoSyncFlag() && this._autoSyncJdbc != null) {
            this._autoSyncJdbc.setSelected(true);
        } else {
            this._autoSyncJdbc.setSelected(false);
        }
        this._sds = SecurityDeploymentSettings.getInstance(dc);
        this._overwriteApplicationPolicies.setSelected(this._isAppLevel && this._sds.getOverwriteApplicationPoliciesFlag());
        this._overwriteCredentials.setSelected(this._isAppLevel && this._sds.getOverwriteCredentialsFlag());
        this._migrateUsersAndGroups.setSelected(this._isAppLevel && this._sds.getMigrateUsersAndGroupsFlag());
    }

    void commitTo() {
        Enumeration e = this._root.children();
        ArrayList<Profile> profiles = new ArrayList<Profile>();
        while (e.hasMoreElements()) {
            JMutableTreeNode treeNode = (JMutableTreeNode)e.nextElement();
            JTreeCellData cellData = (JTreeCellData)treeNode.getUserObject();
            profiles.add((Profile)cellData.getUserObject());
        }
        this._deploymentProfiles.setDeploymentProfiles(profiles.toArray(new Profile[0]));
        if (this._defaultProfile != null) {
            this._deploymentProfiles.setDefaultDeploymentProfile(this._defaultProfile);
        }
    }

    private void updateButtons() {
        Profile profile = this.getSelectedProfile();
        if (profile == null) {
            this.newButton.setEnabled(true);
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        } else if (this.isSelectedProfileaChild()) {
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(false);
            this.setDefaultButton.setEnabled(false);
        } else {
            this.newButton.setEnabled(true);
            this.editButton.setEnabled(true);
            this.deleteButton.setEnabled(true);
            this.setDefaultButton.setEnabled(true);
        }
    }

    private void editProfile() {
        Profile profile = this.getSelectedProfile();
        if (profile != null) {
            this.editProfile(profile);
        }
    }

    private void editProfile(Profile profile) {
        try {
            DeployProfileDt dt = Deployment.getProfileDesignTime(profile.getClass());
            Context context = this.getContext();
            if (context.getProperty("edited-profile") == null) {
                context.setProperty("edited-profile", (Object)profile);
            }
            Boolean custom = ProjectSettingsTraversablePanel.editingUserProperties((Namespace)this._tc);
            context.setProperty(CUSTOM_SETTINGS_ACTIVE, (Object)custom);
            dt.launchDialog(context, profile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void newProfile() {
        Object newProfile;
        NewDialog newDialog = new NewDialog(this.usedNames);
        ProfileInfo profileInfo = newDialog.showDialog();
        if (profileInfo != null && (newProfile = Deployment.createDeploymentProfile(this._dc, profileInfo.profileName, profileInfo.profileDt.getDataClass())) != null) {
            this.editProfile((Profile)newProfile);
            JMutableTreeNode newNode = this.addProfileToTree((Profile)newProfile, this._root);
            TreePath path = new TreePath(newNode.getPath());
            this._tree.setSelectionPath(path);
            this._tree.updateUI();
            this.updateButtons();
            this.usedNames.add(profileInfo.profileName);
            this.newlyCreatedProfiles.add(newProfile);
            this.commitTo();
        }
    }

    private boolean isDefaultProfile(Element elem) {
        Profile profile;
        return elem instanceof Profile && (profile = (Profile)elem).equals(this._defaultProfile);
    }

    private String getProfileTypeLabel(Element elem) {
        DeployProfileDt ddt = Deployment.getProfileDesignTime(elem.getClass());
        if (ddt != null) {
            return " (" + ddt.getShortLabel() + ")";
        }
        return "";
    }

    private String getElementDisplayLabel(Element elem) {
        String label = elem.getShortLabel() + this.getProfileTypeLabel(elem);
        if (this.isDefaultProfile(elem)) {
            label = label + " " + DtArb.getString(134);
        }
        return label;
    }

    private void setDefaultProfile() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        JTreeCellData cellData = (JTreeCellData)node.getUserObject();
        Profile profile = (Profile)cellData.getUserObject();
        if (profile == null) {
            return;
        }
        this._defaultProfile = profile;
        if (this._defaultProfileCellData != null) {
            this._defaultProfileCellData.setText(this.getElementDisplayLabel((Element)this._defaultProfileCellData.getUserObject()));
        }
        this._defaultProfileCellData = cellData;
        this._defaultProfileCellData.setText(this.getElementDisplayLabel((Element)this._defaultProfileCellData.getUserObject()));
        this._tree.updateUI();
    }

    private void test() {
        DependentLibrary[] depLibs;
        LibraryToolkitHelper helper = new LibraryToolkitHelper();
        long timeIn = System.currentTimeMillis();
        Context context = new Context();
        context.setElement((Element)this.getSelectedProfile());
        helper.buildDependentLibraries(context);
        long timeOut = System.currentTimeMillis();
        QueryCriteria criteria = new QueryCriteria();
        DependentLibrary[] dependentLibraries = helper.getDependentLibraries(criteria);
        System.out.println("---------------Library Build--------------------------------------------------------------");
        for (DependentLibrary depLib : depLibs = helper.getDependentLibraries(null)) {
            System.out.println(depLib);
        }
        System.out.println("---------------DONE-----------------------------------------------------------------------");
        long elapsedTime = timeOut - timeIn;
        System.out.println("time Elapsed on Build: " + elapsedTime + "ms.");
    }

    private void deleteProfile() {
        int selectedRow = -1;
        TreePath currentSelection = this._tree.getSelectionPath();
        if (currentSelection != null) {
            selectedRow = this._tree.getMinSelectionRow();
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelection.getLastPathComponent();
            JMutableTreeNode parent = (JMutableTreeNode)currentNode.getParent();
            if (parent != null) {
                Profile profile = this.getSelectedProfile();
                String profileName = profile.getName();
                this._treeModel.removeNodeFromParent(currentNode);
                if (selectedRow + 1 < this._tree.getRowCount()) {
                    this._tree.setSelectionRow(selectedRow + 1);
                } else if (selectedRow - 1 >= -1) {
                    this._tree.setSelectionRow(selectedRow - 1);
                }
                this._tree.updateUI();
                this.updateButtons();
                this.usedNames.remove(profileName);
                if (this.newlyCreatedProfiles.contains(profile)) {
                    this.newlyCreatedProfiles.remove(profile);
                }
                if (profile.equals(this._defaultProfile)) {
                    this._defaultProfile = null;
                }
                this.commitTo();
            }
        }
    }

    public void finishNewProfileCreation() {
        Iterator iter = this.newlyCreatedProfiles.iterator();
        Context context = this.getContext();
        while (iter.hasNext()) {
            Profile newProfile = (Profile)iter.next();
            DeployProfileDt dt = Deployment.getProfileDesignTime(newProfile.getClass());
            dt.finishCreation(context, newProfile);
        }
    }

    private Context getContext() {
        Context context = Context.newIdeContext();
        if (this._dc instanceof Project) {
            context.setProject((Project)this._dc);
        } else if (this._dc instanceof Workspace) {
            context.setWorkspace((Workspace)this._dc);
        }
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (selectedNode != null) {
            JTreeCellData selectedCell = (JTreeCellData)selectedNode.getUserObject();
            Profile selectedProfile = (Profile)selectedCell.getUserObject();
            context.setProperty("edited-profile", (Object)selectedProfile);
        }
        if (this._dc != null) {
            DeployUtil.setProfileDataContainer(context, this._dc);
        }
        return context;
    }

    protected class JMTNComparator
    implements Comparator {
        private final Collator _collator = Collator.getInstance();

        protected JMTNComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            JMutableTreeNode node1 = (JMutableTreeNode)o1;
            JMutableTreeNode node2 = (JMutableTreeNode)o2;
            return this._collator.compare(node1.getModel().getText(), node2.getModel().getText());
        }

        @Override
        public boolean equals(Object o) {
            return o != null && o.getClass() == this.getClass();
        }
    }

    class ProfileInfo {
        public String profileName;
        public DeployProfileDt profileDt;

        ProfileInfo() {
        }
    }

    class NewDialog
    extends JPanel
    implements DocumentListener,
    ActionListener {
        private JTextField nameTextField;
        private DescriptionScrollPane descrScrollPane;
        private JComboBox archiveTypeComboBox;
        private JEWTDialog dlg;
        private Set usedNames;
        private HashMap profileNameClassPair;
        private ProfileInfo profileInfo;
        private boolean _nameModifiedByUser;

        NewDialog(Set usedNames) {
            super(new GridBagLayout());
            this.descrScrollPane = new DescriptionScrollPane();
            this.profileNameClassPair = new HashMap();
            this.profileInfo = new ProfileInfo();
            this._nameModifiedByUser = false;
            Dimension dim = new Dimension(500, 220);
            this.setPreferredSize(dim);
            this.usedNames = usedNames;
            JLabel profileDescr = new JLabel();
            profileDescr.setText(DtArb.getString(7));
            JLabel nameLabel = new JLabel();
            this.nameTextField = new JTextField();
            JLabel archiveTypeLabel = new JLabel();
            JLabel descrLabel = new JLabel();
            List<DeployProfileDt> profileDtList = Deployment.getProfileDesignTimeList();
            ArrayList<String> archiveTypeArray = new ArrayList<String>();
            String defaultType = "";
            for (int i = 0; i < profileDtList.size(); ++i) {
                DeployProfileDt profileDt = profileDtList.get(i);
                if ((!(DeploymentPanelContent.this._dc instanceof Workspace) || !profileDt.supportsApplicationLevelCreation()) && (!(DeploymentPanelContent.this._dc instanceof Project) || !profileDt.supportsProjectLevelCreation())) continue;
                archiveTypeArray.add(profileDt.getDisplayName());
                boolean isDefaultProfileType = false;
                if (defaultType == null || defaultType.length() == 0) {
                    if (DeploymentPanelContent.this._dc instanceof Workspace && profileDt.getDataClass().getSimpleName().equals("EarProfile")) {
                        isDefaultProfileType = true;
                    } else if (DeploymentPanelContent.this._dc instanceof Project && profileDt.getDataClass().getSimpleName().equals("ArchiveProfile")) {
                        isDefaultProfileType = true;
                    }
                }
                if (isDefaultProfileType) {
                    defaultType = profileDt.getDisplayName();
                    this.profileInfo.profileDt = profileDt;
                    this.nameTextField.setText(profileDt.getUniqueName(usedNames));
                    this.descrScrollPane.setText(profileDt.getLongLabel());
                    this.descrScrollPane.setForeground(Colors.HINT_TEXT);
                }
                this.profileNameClassPair.put(profileDt.getDisplayName(), profileDt);
            }
            Collections.sort(archiveTypeArray);
            this.archiveTypeComboBox = new JComboBox(new NonNullableComboBoxModel(archiveTypeArray.toArray()));
            this.archiveTypeComboBox.setSelectedItem(defaultType);
            this.archiveTypeComboBox.addActionListener(this);
            ResourceUtils.resLabel((JLabel)descrLabel, (Component)this.descrScrollPane.getLabelComponent(), (String)DtArb.getString(133));
            ResourceUtils.resLabel((JLabel)nameLabel, (Component)this.nameTextField, (String)DtArb.getString(131));
            ResourceUtils.resLabel((JLabel)archiveTypeLabel, (Component)this.archiveTypeComboBox, (String)DtArb.getString(132));
            this.nameTextField.getDocument().addDocumentListener(this);
            int y = 0;
            this.add((Component)profileDescr, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 5), 0, 0));
            this.add((Component)archiveTypeLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.archiveTypeComboBox, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)nameLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)this.nameTextField, new GridBagConstraints(0, y++, 0, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)descrLabel, new GridBagConstraints(0, y++, 0, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            this.add((Component)this.descrScrollPane, new GridBagConstraints(0, y++, 0, 0, 1.0, 0.0, 17, 1, new Insets(2, 5, 0, 5), 0, 0));
            this.add((Component)new JLabel(), new GridBagConstraints(0, y, 0, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        ProfileInfo showDialog() {
            String title = DtArb.getString(124);
            JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this, (Component)this.nameTextField, (String)title);
            this.setJEWTDialog(dlg);
            dlg.setOKButtonEnabled(this.canOk());
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_newdeploymentprofile_html");
            if (WizardLauncher.runDialog((JDialog)dlg)) {
                this.profileInfo.profileName = this.getNewName();
                return this.profileInfo;
            }
            return null;
        }

        private void setJEWTDialog(JEWTDialog dlg) {
            this.dlg = dlg;
            dlg.addVetoableChangeListener(new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt) && NewDialog.this.veto()) {
                        throw new PropertyVetoException("no", evt);
                    }
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeployProfileDt dt;
            JComboBox cb = (JComboBox)e.getSource();
            String archiveType = (String)cb.getSelectedItem();
            this.profileInfo.profileDt = dt = (DeployProfileDt)this.profileNameClassPair.get(archiveType);
            if (!this._nameModifiedByUser) {
                this.nameTextField.getDocument().removeDocumentListener(this);
                this.nameTextField.setText(dt.getUniqueName(this.usedNames));
                this.nameTextField.getDocument().addDocumentListener(this);
            }
            this.descrScrollPane.setText(dt.getLongLabel());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            this._nameModifiedByUser = true;
            this.dlg.setOKButtonEnabled(this.canOk());
        }

        private boolean canOk() {
            return this.nameTextField.getText().length() > 0;
        }

        private boolean veto() {
            String name = this.nameTextField.getText();
            try {
                DeploymentProfiles.validateProfileName(this.usedNames, name, this.dlg.getTitle());
            }
            catch (TraversalException te) {
                te.showMessageDialog((Component)this);
                return true;
            }
            return false;
        }

        private String getNewName() {
            return this.nameTextField.getText();
        }
    }
}

