/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Attributes;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Displayable;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.HashStructureNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeInfo;
import oracle.ide.model.Project;
import oracle.ide.model.ResourcePaths;
import oracle.ide.model.Workspace;
import oracle.ide.model.XMLDataNode;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.model.panels.PropertiesDialog;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.dt.CreateProfilePanel;
import oracle.jdeveloper.deploy.dt.DeployDesignTime;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.InvalidProfileException;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.dt.ProfileOperationException;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.res.DtArb;

public abstract class DeployProfileDt
extends DeployDesignTime
implements NodeInfo,
Displayable {
    private transient Context _creationContext;

    public Class getNodeClass() {
        return XMLDataNode.class;
    }

    public Icon getIcon() {
        return DeployArb.getIcon(5);
    }

    public String getXMLNamespaceURI() {
        return null;
    }

    public Attributes getAttributes() {
        return new ElementAttributes(ElementAttributes.DELETEABLE | ElementAttributes.SAVEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.CLOSEABLE);
    }

    public String getShortLabel() {
        return null;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public String toString() {
        return this.getShortLabel();
    }

    protected boolean isCreatedInContainer() {
        return true;
    }

    protected boolean launchDialog(Context context, Profile profile) {
        return true;
    }

    protected Profile newProfileInstance(DataContainer container, String profileName) {
        return null;
    }

    public void addDeploymentSubmenu(Context context, JMenu profileSubMenu) {
    }

    public String getMostRecentDeployTarget() {
        return DtArb.getString(29);
    }

    protected String[] getTechnologyKeys() {
        return null;
    }

    private DataContainer getContainer(Context context) {
        Project container;
        Node contextNode = context.getNode();
        if (contextNode != null) {
            contextNode = (Node)contextNode.getData();
        }
        if (contextNode instanceof DataContainer) {
            container = (DataContainer)context.getNode().getData();
        } else {
            container = context.getProject();
            if (container == null) {
                container = context.getWorkspace();
            }
        }
        return container;
    }

    protected Node createDesignTimeNode(Context context) {
        return null;
    }

    protected Profile newContainerDeploymentProfile(Context context) {
        Object newProfile;
        DataContainer container = this.getContainer(context);
        DeployUtil.setProfileDataContainer(context, container);
        Namespace data = new Namespace();
        DeploymentProfiles deploymentProfiles = DeploymentProfiles.getInstance(container);
        Map definedProfiles = deploymentProfiles.getDefinedProfiles(false);
        TreeSet usedNames = new TreeSet();
        usedNames.addAll(definedProfiles.keySet());
        data.put("usedNames", usedNames);
        String profileName = this.getUniqueName(usedNames);
        data.put("defaultProfileName", (Object)profileName);
        data.put("profileDt", (Object)this);
        CreateProfilePanel createPanel = new CreateProfilePanel();
        String title = DtArb.format(28, this.getDisplayName());
        TDialogLauncher launcher = new TDialogLauncher((Component)Ide.getMainWindow(), title, (Traversable)createPanel, data);
        launcher.setPackDialog(true);
        boolean userSaidOK = false;
        userSaidOK = launcher.showDialog();
        if (userSaidOK && (newProfile = Deployment.createDeploymentProfile(container, profileName = (String)data.find("profileName"), this.getDataClass())) != null) {
            ((Profile)newProfile).setName(profileName);
            try {
                DeploymentProfiles.getInstance(container).addProfile((Profile)newProfile);
                context.setProperty("edited-profile", newProfile);
                if (this.launchDialog(context, (Profile)newProfile)) {
                    this.finishCreation(context, (Profile)newProfile);
                }
                String[] path = new String[]{DeployArb.getString(103)};
                if (container instanceof Project) {
                    ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)((Project)container), (String[])path);
                } else if (container instanceof Workspace) {
                    PropertiesDialog dialog = PropertiesDialog.getInstance((String)"Application");
                    dialog.showDialog(context, (Frame)Ide.getMainWindow(), (HashStructureNode)container, path);
                }
                return newProfile;
            }
            catch (InvalidProfileException e) {
                e.printStackTrace();
            }
            catch (ProfileOperationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void finishCreation(Context profileContext, Profile profile) {
    }

    private static HashStructure getProfileHash(URL projectURL, String profileName) {
        try {
            Project project = (Project)NodeFactory.findOrCreate((URL)projectURL);
            HashStructure profilesHash = project.getSharedPropertiesOnly().getOrCreateHashStructure("deployment-profiles");
            HashStructure profileHash = profilesHash.getOrCreateHashStructure(profileName);
            return profileHash;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected abstract String getDisplayName();

    protected abstract String getDefaultProfileName();

    protected URL newUniqueURL(Context context) {
        Project project = context.getProject();
        URL firstResourceDir = ResourcePaths.getInstance((PropertyStorage)project).getProjectResourcesPath().getFirstEntry();
        if (firstResourceDir == null) {
            firstResourceDir = project != null ? URLFileSystem.getParent((URL)project.getURL()) : URLFactory.newDirURL((String)Ide.getWorkDirectory());
        }
        DefaultNameGenerator nameGen = new DefaultNameGenerator(this.getDefaultProfileName(), this.getSuffix());
        URL defaultURL = URLFactory.newUniqueURL((URL)firstResourceDir, (NameGenerator)nameGen);
        return defaultURL;
    }

    public String getUniqueName(Set usedNames) {
        String name;
        DefaultNameGenerator nameGen = new DefaultNameGenerator(this.getDefaultProfileName(), null);
        while (usedNames.contains(name = nameGen.nextName())) {
        }
        return name;
    }

    protected final URL ensureSuffix(URL selectedURL) {
        return URLFileSystem.ensureSuffix((URL)selectedURL, (String)this.getSuffix());
    }

    protected String getSuffix() {
        return ".deploy";
    }

    protected Node findOrCreateDeployNode(URL saveURL) throws IllegalAccessException, InstantiationException {
        Node deployNode = NodeFactory.find((URL)saveURL);
        Class nodeClass = this.getNodeClass();
        if (deployNode == null || deployNode.getClass() != nodeClass) {
            NodeFactory.uncache((URL)saveURL);
            return NodeFactory.findOrCreate((Class)nodeClass, (URL)saveURL);
        }
        return deployNode;
    }

    protected final Context getCreationContext() {
        return this._creationContext;
    }

    protected final void setCreationContext(Context context) {
        this._creationContext = context;
    }

    public boolean supportsApplicationLevelCreation() {
        return false;
    }

    public boolean supportsProjectLevelCreation() {
        return true;
    }

    public boolean addToApplicationAssemblyOnProfileAutogen() {
        return false;
    }
}

