/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.net.URLPath;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.common.SelectionRule;

public class SelectionRules
extends DefaultLinkedDirtyable
implements Copyable {
    private HashStructure _hash;

    public SelectionRules() {
        this(HashStructure.newInstance());
    }

    public SelectionRules(HashStructure hash) {
        this._hash = hash;
    }

    private static SelectionRule[] getDefaultSelectionRules() {
        return new SelectionRule[]{SelectionRule.newExclude("WEB-INF/temp/**"), SelectionRule.newExclude("WEB-INF/classes/jsp_servlet/**"), SelectionRule.newExclude(".wlsjsps/"), SelectionRule.newExclude(".wlLibs/"), SelectionRule.newExclude("**/.svn/"), SelectionRule.newExclude("**/CVS/"), SelectionRule.newExclude("**/.ade_path"), SelectionRule.newExclude("**/.data/**"), SelectionRule.newExclude("**.cdi"), SelectionRule.newExclude("**.contrib"), SelectionRule.newExclude("**.keep"), SelectionRule.newExclude("**.rvi"), SelectionRule.newExclude(".jsps/"), SelectionRule.newExclude(".tags/"), SelectionRule.newExclude(".dtags/"), SelectionRule.newExclude("**/*.jht"), SelectionRule.newExclude("**/*.jjt"), SelectionRule.newExclude("**/*.jxt"), SelectionRule.newInclude("**")};
    }

    public static SelectionRules newDefaultSelectionRules() {
        SelectionRules rules = new SelectionRules();
        rules.setRules(SelectionRules.getDefaultSelectionRules());
        return rules;
    }

    public Object copyTo(Object target) {
        SelectionRules copy = target != null ? (SelectionRules)target : new SelectionRules();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(SelectionRules copy) {
        this._hash.copyTo(copy._hash);
    }

    public SelectionRule[] getRules() {
        ListStructure list = this._hash.getListStructure("rules");
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return SelectionRules.getDefaultSelectionRules();
        }
        int n = list.size();
        SelectionRule[] selectionRules = new SelectionRule[n];
        for (int i = 0; i < n; ++i) {
            HashStructure ruleHash = (HashStructure)list.get(i);
            selectionRules[i] = (SelectionRule)new SelectionRule(ruleHash).copyTo(null);
        }
        return selectionRules;
    }

    public void setRules(SelectionRule[] rules) {
        if (!Arrays.equals(this.getRules(), rules)) {
            this.setRulesImpl(rules);
            this.markDirty(true);
        }
    }

    private void setRulesImpl(SelectionRule[] rules) {
        this.unlinkEmbeddedDirtyables(this.getRules());
        this._hash.remove("rules");
        if (rules != null) {
            ListStructure list = this._hash.getOrCreateListStructure("rules");
            if (!Arrays.equals(rules, SelectionRules.getDefaultSelectionRules())) {
                int n = list.size();
                for (int i = 0; i < rules.length; ++i) {
                    SelectionRule selectionRule = rules[i];
                    HashStructure ruleHash = selectionRule.getHashStructure();
                    list.add((Object)ruleHash);
                }
            }
            this._hash.putListStructure("rules", list);
        }
        this.linkEmbeddedDirtyables(this.getRules());
    }

    public SelectionRule findFirstConsumingRule(String path, int startingAt, boolean mustAlsoMatch) {
        SelectionRule[] rules = this.getRules();
        if (rules != null) {
            int n = rules.length;
            for (int i = startingAt; i < n; ++i) {
                SelectionRule rule = rules[i];
                if (rule == null) continue;
                int consumeType = rule.consumes(path);
                if (consumeType == 0) {
                    return mustAlsoMatch ? null : rule;
                }
                if (consumeType != 1) continue;
                return rule;
            }
        }
        return null;
    }

    public SelectionRule findMatchingRule(String path) {
        SelectionRule[] rules = this.getRules();
        if (rules != null) {
            for (SelectionRule rule : rules) {
                if (rule == null || !rule.matches(path)) continue;
                return rule;
            }
        }
        return null;
    }

    public boolean isIncluded(String path) {
        SelectionRule matchingRule = this.findMatchingRule(path);
        return matchingRule != null ? matchingRule.isInclude() : false;
    }

    public boolean isExcluded(String path) {
        SelectionRule matchingRule = this.findMatchingRule(path);
        return matchingRule != null ? matchingRule.isExclude() : false;
    }

    public void addInclude(String pattern, boolean reduce) {
        if (pattern != null) {
            this.addRuleImpl(SelectionRule.newInclude(pattern), reduce);
        }
    }

    public void addExclude(String pattern, boolean reduce) {
        if (pattern != null) {
            this.addRuleImpl(SelectionRule.newExclude(pattern), reduce);
        }
    }

    public TriStateBoolean inferFromRules(URL url, URLPath contribPath) {
        return this.inferFromRules(contribPath.toRelativePath(url));
    }

    public TriStateBoolean inferFromRules(String relPath) {
        return this.inferFromRules(relPath, false);
    }

    public TriStateBoolean inferFromRules(String relPath, boolean mustAlsoMatch) {
        TriStateBoolean inference = TriStateBoolean.FALSE;
        if (ModelUtil.hasLength((String)relPath)) {
            SelectionRule consumingRule = this.findFirstConsumingRule(relPath, 0, mustAlsoMatch);
            if (consumingRule != null) {
                inference = consumingRule.matches(relPath) ? TriStateBoolean.getState((boolean)consumingRule.isInclude()) : TriStateBoolean.TRI_STATE;
            }
        } else {
            inference = TriStateBoolean.TRUE;
        }
        return inference;
    }

    private void addRuleImpl(SelectionRule rule, boolean reduce) {
        ArrayList<SelectionRule> rulesList;
        block23: {
            SelectionRule[] rules = this.getRules();
            String pattern = rule.getPattern();
            rulesList = new ArrayList<SelectionRule>();
            if (rules != null) {
                rulesList.addAll(Arrays.asList(rules));
            }
            if (rulesList.size() == 0) {
                if (rule.isExclude()) {
                    return;
                }
            } else if (reduce) {
                SelectionRule firstRule;
                if ("**".equals(pattern) && (firstRule = (SelectionRule)rulesList.get(0)) != null && "**".equals(firstRule.getPattern())) {
                    rulesList.remove(0);
                }
                if (!SelectionRules.containsWildcard(pattern)) {
                    Iterator iterReduce = rulesList.iterator();
                    boolean matchingAntagonistRemoved = false;
                    while (iterReduce.hasNext()) {
                        SelectionRule curRule = (SelectionRule)iterReduce.next();
                        if (curRule == null) continue;
                        String curPattern = curRule.getPattern();
                        if (curPattern != null) {
                            if ("**".equals(curPattern)) {
                                if (curRule.getType() == rule.getType()) {
                                    this.setRulesImpl(rulesList);
                                    return;
                                }
                            } else if (curRule.matches(pattern)) {
                                boolean isSameType;
                                boolean bl = isSameType = curRule.getType() == rule.getType();
                                if (SelectionRules.containsWildcard(curPattern)) {
                                    if (isSameType) {
                                        this.setRulesImpl(rulesList);
                                        return;
                                    }
                                } else {
                                    if (curPattern.equals(pattern)) {
                                        iterReduce.remove();
                                        if (isSameType) continue;
                                        matchingAntagonistRemoved = true;
                                        continue;
                                    }
                                    if (isSameType) {
                                        this.setRulesImpl(rulesList);
                                        return;
                                    }
                                }
                            } else {
                                if (curPattern.startsWith(pattern) && (pattern.endsWith("/") || curPattern.charAt(pattern.length()) == '/')) {
                                    iterReduce.remove();
                                    continue;
                                }
                                if (!pattern.startsWith(curPattern) || !curPattern.endsWith("/") && pattern.charAt(curPattern.length()) != '/') continue;
                                if (curRule.getType() == rule.getType()) {
                                    this.setRulesImpl(rulesList);
                                    return;
                                }
                            }
                        }
                        break block23;
                    }
                    if (matchingAntagonistRemoved && rule.isExclude()) {
                        this.setRulesImpl(rulesList);
                        return;
                    }
                    if (rulesList.size() == 0 && rule.isExclude()) {
                        this.setRulesImpl(rulesList);
                        return;
                    }
                }
            }
        }
        rulesList.add(0, rule);
        this.setRulesImpl(rulesList);
    }

    private void setRulesImpl(ArrayList rulesList) {
        this.setRulesImpl(rulesList.toArray(new SelectionRule[rulesList.size()]));
    }

    private static boolean containsWildcard(String pattern) {
        return pattern.indexOf(42) >= 0;
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((SelectionRules)o);
    }

    protected final boolean equalsImpl(SelectionRules other) {
        return Arrays.equals(this.getRules(), other.getRules());
    }
}

