/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyInfoFactory;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdevimpl.deploy.res.CommonArb;

public class SelectionRule
extends DefaultLinkedDirtyable
implements Copyable {
    public static final int INCLUDE = 0;
    public static final int EXCLUDE = 1;
    static final int DOES_NOT_CONSUME = -1;
    static final int CONSUMES_ONLY = 0;
    static final int CONSUMES_AND_MATCHES = 1;
    private HashStructure _hash;

    public SelectionRule() {
        this(HashStructure.newInstance());
    }

    public SelectionRule(HashStructure hash) {
        this._hash = hash;
    }

    SelectionRule(int type, String pattern) {
        this();
        this.setType(type);
        this.setPattern(pattern);
    }

    public static SelectionRule newInclude(String pattern) {
        return new SelectionRule(0, pattern);
    }

    public static SelectionRule newExclude(String pattern) {
        return new SelectionRule(1, pattern);
    }

    public Object copyTo(Object target) {
        SelectionRule copy = target != null ? (SelectionRule)target : new SelectionRule();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(SelectionRule copy) {
        this._hash.copyTo(copy._hash);
    }

    public int getType() throws AttributeMarker {
        return this._hash.getInt("type");
    }

    public void setType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException();
        }
        if (this.getType() != type) {
            this._hash.putInt("type", type);
            this.markDirty(true);
        }
    }

    public String getPattern() throws AttributeMarker {
        return this._hash.getString("pattern");
    }

    public void setPattern(String pattern) {
        if (ModelUtil.areDifferent((Object)this.getPattern(), (Object)pattern)) {
            this._hash.putString("pattern", pattern);
            this.markDirty(true);
        }
    }

    public boolean isInclude() {
        return this.getType() == 0;
    }

    public boolean isExclude() {
        return this.getType() == 1;
    }

    int consumes(String path) {
        String pattern = this.getPattern();
        if (pattern == null || path == null) {
            return -1;
        }
        if ("**".equals(pattern)) {
            return 1;
        }
        int[] indexes = new int[]{0, 0};
        boolean matches = this.matchesImpl(path, indexes);
        if (matches) {
            return 1;
        }
        int highestPathIndex = indexes[0];
        int highestPatternIndex = indexes[1];
        if (highestPathIndex == path.length() && (pattern.charAt(highestPatternIndex) == '/' || highestPathIndex > 0 && highestPatternIndex > 0 && path.charAt(highestPathIndex - 1) == '/' && pattern.charAt(highestPatternIndex - 1) == '/')) {
            return 0;
        }
        return -1;
    }

    public boolean matches(String path) {
        String pattern = this.getPattern();
        if (pattern == null || path == null) {
            return false;
        }
        if ("**".equals(pattern)) {
            return true;
        }
        return this.matchesImpl(path, new int[]{0, 0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean matchesImpl(String path, int[] indexes) {
        String pattern = this.getPattern();
        int iPath = indexes[0];
        int iPattern = indexes[1];
        try {
            boolean bl;
            int nPath = path.length();
            int nPattern = pattern.length();
            block9: while (iPath < nPath && iPattern < nPattern) {
                if (pattern.charAt(iPattern) == '*') {
                    char curPathChar;
                    boolean slashLookbehind = true;
                    if (iPattern > 0) {
                        slashLookbehind = pattern.charAt(iPattern - 1) == '/';
                    }
                    int numStars = 0;
                    while (iPattern < nPattern && pattern.charAt(iPattern) == '*') {
                        ++numStars;
                        ++iPattern;
                    }
                    if (iPattern >= nPattern) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    boolean consumeSlash = numStars > 1;
                    boolean slashLookahead = false;
                    if (consumeSlash && slashLookbehind) {
                        while (iPattern < nPattern && pattern.charAt(iPattern) == '/') {
                            slashLookahead = true;
                            ++iPattern;
                        }
                        if (iPattern >= nPattern) {
                            boolean bl3 = true;
                            return bl3;
                        }
                    }
                    char nextPatternChar = pattern.charAt(iPattern);
                    boolean slashStarStarSlash = slashLookbehind && slashLookahead;
                    char c = curPathChar = iPath > 0 ? path.charAt(iPath - 1) : (char)'\u0000';
                    while (iPath < nPath) {
                        char prevPathChar = curPathChar;
                        curPathChar = path.charAt(iPath);
                        if (!(curPathChar != nextPatternChar && nextPatternChar != '*' || !this.matchesImpl(path, new int[]{iPath, iPattern}) || (!slashStarStarSlash || prevPathChar != '/' && prevPathChar != '\u0000') && slashStarStarSlash)) {
                            boolean bl4 = true;
                            return bl4;
                        }
                        if (curPathChar == '/') {
                            if (!consumeSlash) continue block9;
                            if (this.matchesImpl(path, new int[]{iPath, iPattern})) {
                                boolean bl5 = true;
                                return bl5;
                            }
                        }
                        ++iPath;
                    }
                    continue;
                }
                if (pattern.charAt(iPattern) == path.charAt(iPath)) {
                    ++iPattern;
                    ++iPath;
                    continue;
                }
                bl = false;
                return bl;
            }
            while (iPattern < nPattern && pattern.charAt(iPattern) == '*') {
                ++iPattern;
            }
            if (iPath == nPath) {
                bl = iPattern == nPattern;
                return bl;
            }
            bl = path.charAt(iPath) == '/' || pattern.charAt(iPattern - 1) == '/';
            return bl;
        }
        finally {
            indexes[0] = iPath;
            indexes[1] = iPattern;
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((SelectionRule)o);
    }

    protected final boolean equalsImpl(SelectionRule other) {
        return this._hash.equals((Object)other._hash);
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public String toString() {
        switch (this.getType()) {
            case 0: {
                return CommonArb.format(13, this.getPattern());
            }
            case 1: {
                return CommonArb.format(14, this.getPattern());
            }
        }
        return CommonArb.getString(15);
    }

    public static PropertyInfo[] getPropertyInfos() {
        PropertyInfoFactory pif = new PropertyInfoFactory(SelectionRule.class);
        return new PropertyInfo[]{pif.newAttr("type", "Type"), pif.newAttr("pattern", "Pattern")};
    }
}

