/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.HashMap;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;

public class ModuleContext
extends HashMap<String, Object> {
    private static final String DEPLOY_SHELL_KEY = DeployShell.class.getName();
    private static final String ARCHIVE_KEY = Archive.class.getName();
    private static final String ARCHIVE_OPTIONS_KEY = ArchiveOptions.class.getName();

    protected ModuleContext() {
    }

    public static ModuleContext newInstance(DeployShell shell, Archive archive, ArchiveOptions options) {
        return new ModuleContext(shell, archive, options);
    }

    protected ModuleContext(DeployShell shell, Archive archive, ArchiveOptions options) {
        this.setDeployShell(shell);
        this.setArchive(archive);
        this.setArchiveOptions(options);
    }

    public DeployShell getDeployShell() {
        return (DeployShell)((Object)this.get(DEPLOY_SHELL_KEY));
    }

    public void setDeployShell(DeployShell shell) {
        this.put(DEPLOY_SHELL_KEY, shell);
    }

    public Archive getArchive() {
        return (Archive)this.get(Archive.class.getName());
    }

    public void setArchive(Archive archive) {
        this.put(ARCHIVE_KEY, archive);
    }

    public ArchiveOptions getArchiveOptions() {
        return (ArchiveOptions)this.get(ArchiveOptions.class.getName());
    }

    public void setArchiveOptions(ArchiveOptions archiveOptions) {
        this.put(ARCHIVE_OPTIONS_KEY, archiveOptions);
    }

    public Element getDeployElement() {
        return DeployUtil.getDeployElement(this.getDeployShell());
    }
}

