/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.Arrays;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.SelectionRules;

public class LibraryFileGroup
extends FileGroup {
    public static final String DEFAULT_INTERNAL_NAME = "libraries";
    public static final int ARCHIVES_AS_FILES = 0;
    public static final int ARCHIVES_AS_VIRTUAL_DIRECTORIES = 1;

    public LibraryFileGroup() {
        this((String)null);
    }

    public LibraryFileGroup(HashStructure hash) {
        super(hash);
    }

    public LibraryFileGroup(String displayName) {
        this(displayName, null);
    }

    public LibraryFileGroup(String displayName, String internalName) {
        this(displayName, internalName, new SelectionRules());
    }

    private LibraryFileGroup(String displayName, String internalName, SelectionRules filters) {
        super(displayName, internalName);
        this.setFilters(filters);
    }

    public static LibraryFileGroup newDefaultGroup(String displayName) {
        SelectionRules filters = new SelectionRules();
        filters.addInclude("**", false);
        return new LibraryFileGroup(displayName, DEFAULT_INTERNAL_NAME, filters);
    }

    @Override
    public final int type() {
        return 3;
    }

    @Override
    public Object copyTo(Object target) {
        LibraryFileGroup copy = target != null ? (LibraryFileGroup)target : new LibraryFileGroup();
        this.copyToImpl(copy);
        return copy;
    }

    public Object[] getSelectedLibraries() {
        ListStructure list = this._hash.getListStructure("selectedLibraries");
        if (list == null) {
            return null;
        }
        return list.toArray();
    }

    public void setSelectedLibraries(Object[] selectedLibraries) {
        if (!Arrays.equals(this.getSelectedLibraries(), selectedLibraries)) {
            ListStructure list = this._hash.getOrCreateListStructure("selectedLibraries");
            list.clear();
            list.addAll(Arrays.asList(selectedLibraries));
            this.markDirty(true);
        }
    }

    public void addSelectedLibrary(Object id) {
        Object[] selectedLibraries = this.getSelectedLibraries();
        if (selectedLibraries != null) {
            if (!Arrays.asList(selectedLibraries).contains(id)) {
                int n = selectedLibraries.length;
                Object[] temp = new Object[n + 1];
                System.arraycopy(selectedLibraries, 0, temp, 0, n);
                temp[n] = id;
                this.setSelectedLibraries(temp);
                this.markDirty(true);
            }
        } else {
            this.setSelectedLibraries(new Object[]{id});
        }
    }

    public int getSelectionMode() {
        return this._hash.getInt("selectionMode");
    }

    public void setSelectionMode(int selectionMode) {
        if (selectionMode < 0 || selectionMode > 1) {
            throw new IllegalArgumentException();
        }
        if (this.getSelectionMode() != selectionMode) {
            this._hash.putInt("selectionMode", selectionMode);
            this.markDirty(true);
        }
    }

    public SelectionRules getFilters() {
        HashStructure filterHash = this._hash.getHashStructure("filters");
        if (filterHash == null) {
            return null;
        }
        return new SelectionRules(filterHash);
    }

    public void setFilters(SelectionRules filters) {
        if (ModelUtil.areDifferent((Object)this.getFilters(), (Object)filters)) {
            this.setFiltersImpl(filters);
            this.markDirty(true);
        }
    }

    private void setFiltersImpl(SelectionRules filters) {
        this.unlinkEmbeddedDirtyable(this.getFilters());
        this._hash.putHashStructure("filters", filters.getHashStructure());
        this.linkEmbeddedDirtyable(this.getFilters());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((LibraryFileGroup)o);
    }
}

