/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.Arrays;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.jdeveloper.deploy.common.DynamicDeployer;

public final class BatchDeployer
extends AbstractDeployer {
    private final Deployer[] deployers_;
    private final boolean[] deployerPrepared_;

    public BatchDeployer(int deploySequenceId, int[] deploySequenceIds) {
        super(deploySequenceId);
        this.deployers_ = new Deployer[deploySequenceIds.length];
        for (int i = 0; i < deploySequenceIds.length; ++i) {
            int id = deploySequenceIds[i];
            this.deployers_[i] = new DynamicDeployer(deploySequenceIds[i]);
        }
        this.deployerPrepared_ = new boolean[this.deployers_.length];
    }

    public Deployer[] getDeployers() {
        return this.deployers_;
    }

    @Override
    public void prepareImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        for (int i = 0; i < this.deployers_.length; ++i) {
            this.deployerPrepared_[i] = true;
            this.deployers_[i].prepare(deploySequenceId, shell);
        }
    }

    @Override
    public void deployImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        for (int i = 0; i < this.deployers_.length; ++i) {
            this.deployers_[i].deploy(deploySequenceId, shell);
        }
    }

    @Override
    public void finishImpl(int deploySequenceId, DeployShell shell) {
        for (int i = 0; i < this.deployers_.length; ++i) {
            if (!this.deployerPrepared_[i]) continue;
            this.deployers_[i].finish(deploySequenceId, shell);
        }
    }

    @Override
    public void cancelImpl(int deploySequenceId, DeployShell shell) {
        for (int i = this.deployers_.length - 1; i >= 0; --i) {
            if (!this.deployerPrepared_[i]) continue;
            this.deployers_[i].cancel(deploySequenceId, shell);
        }
    }

    @Override
    public boolean canDeploy(int deploySequenceId) {
        boolean ret = super.canDeploy(deploySequenceId);
        if (!ret) {
            for (int i = 0; i < this.deployers_.length && !(ret = this.deployers_[i].canDeploy(deploySequenceId)); ++i) {
            }
        }
        return ret;
    }

    @Override
    public String toString() {
        return super.toString() + " " + Arrays.toString(this.deployers_);
    }
}

