/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import oracle.ide.model.DataContainer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdevimpl.deploy.SecurityDeploymentPreferences;

public class SecurityDeploymentSettings
extends HashStructureAdapter {
    public static final String DATA_KEY = DeploymentProfiles.class.getName();
    public static final String OVERWRITE_APP_POLICIES_KEY = "Security-Deployment-Overwrite-Application-Policies-Key";
    public static final String OVERWRITE_CREDENTIALS_KEY = "Security-Deployment-Overwrite-Credentials-Key";
    public static final String MIGRATE_USERS_AND_GROUPS_KEY = "Security-Deployment-Migrate-Users-And-Groups-Key";
    private DataContainer _container = null;

    private SecurityDeploymentSettings(HashStructure hash, DataContainer container) {
        super(hash);
        this._container = container;
    }

    public static SecurityDeploymentSettings getInstance(DataContainer container) {
        return SecurityDeploymentSettings.getInstance(container, SecurityDeploymentSettings.isCustomSettingsActive(container));
    }

    public static SecurityDeploymentSettings getInstance(DataContainer container, boolean userPropertiesMode) {
        HashStructure properties = SecurityDeploymentSettings.getContainerProperties(container, userPropertiesMode);
        return new SecurityDeploymentSettings(properties.getOrCreateHashStructure(DATA_KEY), container);
    }

    private static HashStructure getContainerProperties(DataContainer container, boolean userPropertiesMode) {
        return userPropertiesMode ? container.getUserPropertiesOnly() : container.getSharedPropertiesOnly();
    }

    public boolean getOverwriteApplicationPoliciesFlag() {
        boolean flag = this.getHashStructure().getBoolean(OVERWRITE_APP_POLICIES_KEY, true);
        return flag;
    }

    public void setOverwriteApplicationPoliciesFlag(Boolean flag) {
        this.getHashStructure().putBoolean(OVERWRITE_APP_POLICIES_KEY, flag.booleanValue());
    }

    public boolean getMigrateUsersAndGroupsFlag() {
        boolean defaultValue = SecurityDeploymentPreferences.getInstance().getMigrateUsersAndGroupsDefault();
        boolean flag = this.getHashStructure().getBoolean(MIGRATE_USERS_AND_GROUPS_KEY, defaultValue);
        return flag;
    }

    public void setMigrateUsersAndGroupsFlag(Boolean flag) {
        this.getHashStructure().putBoolean(MIGRATE_USERS_AND_GROUPS_KEY, flag.booleanValue());
    }

    public boolean getOverwriteCredentialsFlag() {
        boolean flag = this.getHashStructure().getBoolean(OVERWRITE_CREDENTIALS_KEY, true);
        return flag;
    }

    public void setOverwriteCredentialsFlag(Boolean flag) {
        this.getHashStructure().putBoolean(OVERWRITE_CREDENTIALS_KEY, flag.booleanValue());
    }

    public static boolean isCustomSettingsActive(DataContainer container) {
        HashStructure allChainedProperties = container.getProperties();
        HashStructure chained = allChainedProperties.getOrCreateHashStructure(DATA_KEY);
        return chained.isAnyValueOverridden(new String[]{OVERWRITE_APP_POLICIES_KEY, OVERWRITE_CREDENTIALS_KEY, MIGRATE_USERS_AND_GROUPS_KEY});
    }
}

