/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import oracle.ide.nulls.NullPrintWriter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DefaultArchive;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeploymentModuleIO;
import oracle.jdeveloper.deploy.DeploymentModuleIOFactory;
import oracle.jdeveloper.deploy.DeploymentModuleListener;
import oracle.jdevimpl.deploy.stripe.DeploymentModuleImpl;

public abstract class DeploymentModule
extends DefaultArchive
implements PropertyStorage {
    public static final String MODULEIO_FILE = "Persistence.FILE";
    public static final String MODULEIO_DIRECTORY = "Persistence.DIRECTORY";
    public static final String MODULEIO_PACKINGLIST_FILE = "Persistence.PackingList.FILE";
    public static final String MODULEIO_PACKINGLIST_DIRECTORY = "Persistence.PackingList.DIRECTORY";
    public static final String MODULE_ID_KEY = "MODULE_ID";

    protected DeploymentModule() {
        super(false);
    }

    public static DeploymentModule create(String ioModule) {
        return DeploymentModule.create(null, ioModule, (PrintWriter)new NullPrintWriter(), null);
    }

    public static DeploymentModule create(Archive archive, String ioModule, PrintWriter printWriter, Object[] initialTags) {
        return DeploymentModuleImpl.create(archive, ioModule, printWriter, initialTags);
    }

    public static DeploymentModule create(String ioModule, PrintWriter printWriter) {
        return DeploymentModule.create(null, ioModule, printWriter, null);
    }

    public abstract URL getURL();

    public abstract void setURL(URL var1) throws IOException;

    public abstract void setModuleIO(String var1);

    public abstract DeploymentModule[] getContainedModules();

    public abstract void load() throws IOException;

    public abstract OutputStream openOutputStream(ArchiveEntry var1) throws IOException;

    public abstract InputStream openInputStream(ArchiveEntry var1) throws IOException;

    public static void close(Throwable throwable, Object ... streams) throws Throwable {
        DeploymentModuleImpl.close(throwable, streams);
    }

    public static void close(Object ... streams) {
        DeploymentModuleImpl.close(streams);
    }

    public abstract void commit() throws DeployException;

    public abstract void rollback() throws DeployException;

    public abstract void release() throws DeployException;

    public static void addChangeListener(DeploymentModuleListener listener) {
        DeploymentModuleImpl.addChangeListenerImpl(listener);
    }

    public static void removeChangeListener(DeploymentModuleListener listener) {
        DeploymentModuleImpl.removeChangeListenerImpl(listener);
    }

    public static void addModuleIOFactory(DeploymentModuleIOFactory factory) {
        DeploymentModuleImpl.addModuleIOFactoryImpl(factory);
    }

    public abstract PrintWriter getPrintWriter();

    public abstract void addTag(Object var1);

    public abstract Object[] getTags();

    public abstract Object removeTag(Object var1);

    public abstract DeploymentModuleIO getModuleIO();

    public abstract void setModuleId(String var1);

    public abstract String getModuleId();
}

