/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import oracle.ide.Context;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeployerFactory;
import oracle.jdeveloper.deploy.DeployerListener;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.ListenerCondition;
import oracle.jdeveloper.deploy.ProfileListenerCondition;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdevimpl.deploy.fwk.DeploymentManagerImpl;
import oracle.jdevimpl.deploy.fwk.ListenerSupport;

public abstract class DeploymentManager {
    private static DeploymentManagerImpl impl_ = null;
    private static final String DEBUG_REGEX = System.getProperty("deployment.debug");

    protected DeploymentManager() {
    }

    static synchronized DeploymentManagerImpl getImpl() {
        return impl_;
    }

    public static void addDeployerListener(ListenerCondition condition, DeployerListener listener, double priority) {
        DeploymentManager.getImpl().addDeployerListener(condition, listener, priority);
    }

    public static void addDeployerListener(int deploymentSequenceId, Class<? extends Profile> profileClass, PlatformType platformType, DeployerListener listener) {
        DeploymentManager.addDeployerListener(deploymentSequenceId, profileClass, platformType, 0.5, listener);
    }

    public static void addDeployerListener(int deploymentSequenceId, Class<? extends Profile> profileClass, PlatformType platformType, double priority, DeployerListener listener) {
        DeploymentManager.getImpl().addDeployerListener(new ProfileListenerCondition(deploymentSequenceId, profileClass, platformType), listener, priority);
    }

    public static void removeDeployerListener(ListenerCondition condition, DeployerListener listener) {
        DeploymentManager.getImpl().removeDeployerListener(condition, listener);
    }

    public static void removeDeployerListener(DeployerListener listener) {
        DeploymentManager.getImpl().removeDeployerListener(listener);
    }

    public static int getDeploymentSequenceId(String deploymentSequence) {
        return DeploymentManager.getImpl().getDeploymentSequenceId(deploymentSequence);
    }

    public static String getDeploymentSequenceName(int sequenceId) {
        return DeploymentManager.getImpl().getDeploymentSequenceName(sequenceId);
    }

    public static void registerDeployerFactory(Class clazz, Class parentClazz, DeployerFactory factory) throws MetadataException {
        DeploymentManager.getImpl().registerDeployerFactory(clazz, parentClazz, factory);
    }

    public static void upgradeDeployerFactory(Class clazz, DeployerFactory factory) throws MetadataException {
        DeploymentManager.getImpl().upgradeDeployerFactory(clazz, factory);
    }

    public static void registerDeploymentModuleFactory(Class clazz, DeploymentModuleFactory factory) throws MetadataException {
        DeploymentManager.getImpl().registerDeploymentModuleFactory(clazz, factory);
    }

    public static void upgradeDeploymentModuleFactory(Class clazz, DeploymentModuleFactory factory) throws MetadataException {
        DeploymentManager.getImpl().upgradeDeploymentModuleFactory(clazz, factory);
    }

    public DeployShell getDefaultDeployShell(int deploySequence, Context context) throws DeployException {
        return DeploymentManager.getImpl().getDefaultDeployShell(deploySequence, context);
    }

    public static void deploy(int deploymentSequenceId, Context context) throws Exception {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, context);
    }

    public static void deploy(int deploymentSequenceId, DeployShell shell) throws Exception {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, shell);
    }

    public static void deploy(int deploymentSequenceId, DeployShell shell, Object lock) {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, shell, lock);
    }

    public static void deploy(int deploymentSequenceId, Context context, DeployShellFactory factory) throws Exception {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, context, factory);
    }

    public static void deploy(int deploymentSequenceId, Context context, DeployShellFactory factory, Object lock) throws DeployException, MetadataException {
        DeploymentManager.getImpl().deploy(deploymentSequenceId, context, factory, lock);
    }

    public static boolean printDebug(String prefix, String msg) {
        if (DEBUG_REGEX != null && prefix.matches(DEBUG_REGEX)) {
            System.out.println("DEBUG <step prefix=\"" + prefix + "\">" + msg + "</step>");
            System.out.flush();
        }
        return true;
    }

    public static ListenerSupport getProfileListenerSupport() {
        return DeploymentManager.getImpl().getProfileListenerSupport();
    }

    public static void setDeploymentManager(DeploymentManagerImpl impl) {
        impl_ = impl;
    }
}

