/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.InitialContext;
import javax.swing.Action;
import oracle.ide.Context;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.jndi.Names;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.common.ArchiveElement;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.common.NodeDependable;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.shell.JavaDeployment;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdevimpl.jar.JarNode;

public final class DeployUtil {
    private static final String GALLERY_FOLDER_JNDI_NAME = "deploy/gallery-folder";
    private static final String PROFILE_KEY = "Profile";
    private static final String PROFILE_NAME_KEY = "ProfileName";
    private static final String CONTAINER_TYPE_KEY = "ContainerType";
    private static final String SHORT_COMMAND_KEY = "ShortCommandKey";
    private static final String DEPLOYMENT_MODULE_KEY = "Deployment.deploymentModule";
    private static String PROFILE_DATACONTAINER_KEY = "Profile.Data.Container";

    private DeployUtil() {
    }

    public static List getGalleryList() {
        InitialContext ic = Names.newInitialContext();
        ArrayList children = (ArrayList)Names.lookup((javax.naming.Context)ic, (String)GALLERY_FOLDER_JNDI_NAME);
        if (children == null) {
            children = new ArrayList(10);
            Names.bind((javax.naming.Context)ic, (String)GALLERY_FOLDER_JNDI_NAME, children);
        }
        return children;
    }

    public static URL getDeployPathURL(URL projectURL, URL selectedURL) {
        URL deployDirURL = Deployment.getDeployOutputDir(projectURL);
        if (deployDirURL != null) {
            String fileName = URLFileSystem.getFileName((URL)selectedURL);
            return URLFactory.newURL((URL)deployDirURL, (String)fileName);
        }
        return selectedURL;
    }

    public static ProfileDependable[] getProfileDependables(DataContainer container, Interdependency profile) {
        ArrayList<Dependable> deps = new ArrayList<Dependable>();
        deps.addAll(Arrays.asList(DeployUtil.getContainerProfileDependables(container)));
        deps.addAll(Arrays.asList(DeployUtil.getDependables((Interdependency)profile, ProfileDependable.class)));
        return deps.toArray(new ProfileDependable[deps.size()]);
    }

    public static ProfileDependable[] getContainerProfileDependables(DataContainer container) {
        DependencyConfiguration containerDependencies = DependencyConfiguration.getInstance((PropertyStorage)container);
        ArrayList<ProfileDependable> deps = new ArrayList<ProfileDependable>();
        Iterator iter = containerDependencies.getDependencies();
        while (iter.hasNext()) {
            Dependable dep = (Dependable)iter.next();
            if (!(dep instanceof ProfileDependable)) continue;
            deps.add((ProfileDependable)dep);
        }
        return deps.toArray(new ProfileDependable[deps.size()]);
    }

    public static <T extends Dependable> T[] getDependables(Interdependency interDep, Class<T> type) {
        List<Dependable> deps = DeployUtil.getDependablesList(interDep, type);
        Dependable[] ret = (Dependable[])Array.newInstance(type, deps.size());
        return deps.toArray(ret);
    }

    public static <T extends Dependable> List<T> getDependablesList(Interdependency interDep, Class<T> type) {
        ArrayList<Dependable> deps = new ArrayList<Dependable>();
        Iterator<Dependable> iter = interDep.getDependencies();
        while (iter.hasNext()) {
            Dependable dep = iter.next();
            if (!type.isAssignableFrom(dep.getClass())) continue;
            deps.add(dep);
        }
        return deps;
    }

    public static boolean isForceJarRewrite() {
        DeploymentOptions opts = Deployment.getDeploymentOptions();
        return opts != null ? opts.isForceJarRewrite() : false;
    }

    public static URL getProfileURL(DataContainer container, Profile profile) {
        return DeployUtil.getProfileURL(container.getURL(), profile);
    }

    public static URL getProfileURL(URL containerURL, Profile profile) {
        String refPart = profile.getParentProfileName() + "#" + profile.getName();
        return URLFactory.replaceRefPart((URL)containerURL, (String)profile.getName());
    }

    public static Profile findProfileInElement(URL profileURL, Element parent) {
        return DeployUtil.findProfileInElement(DeployUtil.getProfileName(profileURL), parent);
    }

    public static Profile findProfileInElement(String profileName, Element parent) {
        Profile profile;
        if (parent != null && parent.getData() instanceof DataContainer && (profile = DeployUtil.getProfile((DataContainer)parent.getData(), profileName)) != null) {
            return profile;
        }
        return null;
    }

    public static Profile getProfile(URL profileURL) {
        URL containerURL = DeployUtil.getContainerURL(profileURL);
        try {
            Node obj = NodeFactory.findOrCreate((URL)containerURL);
            if (obj instanceof DataContainer) {
                DataContainer container = (DataContainer)NodeFactory.findOrCreate((URL)containerURL);
                return DeployUtil.getProfile(container, DeployUtil.getProfileName(profileURL));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Profile getProfile(DataContainer container, String profileName) {
        return DeploymentProfiles.getInstance(container).getProfileByName(profileName);
    }

    public static void setProfile(Context context, Profile profile) {
        context.setProperty(PROFILE_KEY, (Object)profile);
        context.setElement((Element)profile);
    }

    public static void setProfile(Context context, Profile profile, DataContainer container) {
        DeployUtil.setProfile(context, profile);
        DeployUtil.setProfileDataContainer(context, container);
    }

    public static Profile getProfile(Context context) {
        return (Profile)context.getProperty(PROFILE_KEY);
    }

    public static String getShortCommandKey(Action action) {
        return (String)action.getValue(SHORT_COMMAND_KEY);
    }

    public static void setShortCommandKey(Action action, String shortCommandKey) {
        action.putValue(SHORT_COMMAND_KEY, shortCommandKey);
    }

    public static String getProfileName(Action action) {
        return (String)action.getValue(PROFILE_NAME_KEY);
    }

    public static void setProfileName(Action action, String profileName) {
        action.putValue(PROFILE_NAME_KEY, profileName);
    }

    public static void setContainerType(Action action, DataContainer container) {
        String containerType = null;
        if (container instanceof Workspace) {
            containerType = "Application";
        } else if (container instanceof Project) {
            containerType = "Project";
        }
        action.putValue(CONTAINER_TYPE_KEY, containerType);
    }

    public static DataContainer getContainer(Action action, Context context) {
        String containerType;
        if (action != null && (containerType = (String)action.getValue(CONTAINER_TYPE_KEY)) != null && containerType.equals("Project")) {
            return context.getProject();
        }
        return context.getWorkspace();
    }

    public static Profile getProfile(DeployShell shell) {
        Context context = shell.getContext();
        return DeployUtil.getProfile(context);
    }

    public static void setDeploymentModule(DeployShell shell, Profile profile, DeploymentModule module) {
        HashMap<Profile, DeploymentModule> profileModuleMap = (HashMap<Profile, DeploymentModule>)shell.getRoot().get(DEPLOYMENT_MODULE_KEY);
        if (profileModuleMap == null) {
            profileModuleMap = new HashMap<Profile, DeploymentModule>();
            shell.getRoot().put(DEPLOYMENT_MODULE_KEY, profileModuleMap);
        }
        profileModuleMap.put(profile, module);
    }

    public static DeploymentModule getDeploymentModule(DeployShell shell, Profile profile) {
        HashMap profileModuleMap = (HashMap)shell.find(DEPLOYMENT_MODULE_KEY);
        if (profileModuleMap != null) {
            return (DeploymentModule)profileModuleMap.get(profile);
        }
        return null;
    }

    @Deprecated
    public static String getProfileName(URL profileURL) {
        return profileURL.getRef();
    }

    public static URL getContainerURL(URL profileURL) {
        return URLFactory.replaceRefPart((URL)profileURL, null);
    }

    @Deprecated
    public static void setProfileDataContainer(Context context, DataContainer container) {
        context.setProperty(PROFILE_DATACONTAINER_KEY, (Object)container);
    }

    @Deprecated
    public static DataContainer getProfileDataContainer(Context context) {
        return (DataContainer)context.getProperty(PROFILE_DATACONTAINER_KEY);
    }

    @Deprecated
    public static DataContainer getProfileDataContainer(DeployShell shell) {
        return DeployUtil.getProfile(shell).getDataContainer();
    }

    @Deprecated
    public static void setProfileDataContainer(Action action, DataContainer container) {
        action.putValue(PROFILE_DATACONTAINER_KEY, container);
    }

    @Deprecated
    public static void setPlatform(Context context, Platform platform) {
        JavaDeployment.getInstance(context).setPlatform(platform);
    }

    @Deprecated
    public static Platform getPlatform(Context context) {
        return JavaDeployment.getInstance(context).getPlatform();
    }

    @Deprecated
    public static Platform getPlatform(DeployShell shell) {
        return JavaDeployment.getInstance(shell).getPlatform();
    }

    public static ProfileDependable[] getProfileDependables(Profile profile, Class<? extends Profile> sourceClass) {
        ArrayList<ProfileDependable> ret = new ArrayList<ProfileDependable>();
        for (ProfileDependable profileDep : (ProfileDependable[])DeployUtil.getDependables((Interdependency)profile, ProfileDependable.class)) {
            Profile source;
            if (!profileDep.doesExist() || !sourceClass.isAssignableFrom((source = profileDep.getProfile()).getClass())) continue;
            ret.add(profileDep);
        }
        return ret.toArray(new ProfileDependable[ret.size()]);
    }

    public static ArchiveEntry createArchiveEntry(NodeDependable nodeDependable, String prefix) {
        URL nodeURL = nodeDependable.getNodeURL();
        String fileName = URLFileSystem.getFileName((URL)nodeURL);
        String entryName = (prefix != null ? prefix : "") + fileName;
        return new ArchiveEntry(entryName, nodeURL);
    }

    public static ArchiveEntry createArchiveEntry(ProfileDependable profileDependable, String prefix) {
        ArchiveProfile archiveProfile = (ArchiveProfile)profileDependable.getProfile();
        URL nodeURL = archiveProfile.getJarURL();
        String fileName = URLFileSystem.getFileName((URL)nodeURL);
        String path = null;
        if (profileDependable instanceof ArchiveElement) {
            path = ((ArchiveElement)((Object)profileDependable)).getPathInArchive();
        }
        String entryName = (path != null ? path : "") + (prefix != null ? prefix : "") + fileName;
        return new ArchiveEntry(entryName, nodeURL);
    }

    public static NodeDependable[] getJarDependables(Interdependency profile) {
        NodeDependable[] nodeDependables = (NodeDependable[])DeployUtil.getDependables((Interdependency)profile, NodeDependable.class);
        ArrayList<NodeDependable> jarNodeDependables = new ArrayList<NodeDependable>();
        for (NodeDependable nodeDep : nodeDependables) {
            if (!(nodeDep.getNode() instanceof JarNode)) continue;
            jarNodeDependables.add(nodeDep);
        }
        return jarNodeDependables.toArray(new NodeDependable[jarNodeDependables.size()]);
    }

    public static NodeDependable[] getAllJarDependables(Interdependency interdep) {
        ArrayList<NodeDependable> seen = new ArrayList<NodeDependable>();
        ArrayList<Object> visitedNodes = new ArrayList<Object>();
        return DeployUtil.getAllJarDependablesImpl(interdep, seen, visitedNodes);
    }

    private static NodeDependable[] getAllJarDependablesImpl(Interdependency interdep, ArrayList<NodeDependable> seen, ArrayList<Object> visitedNodes) {
        Dependable[] dependables;
        NodeDependable[] jarDependables;
        for (NodeDependable jarNodeDep : jarDependables = DeployUtil.getJarDependables(interdep)) {
            if (seen.contains(jarNodeDep)) continue;
            seen.add(jarNodeDep);
        }
        for (Dependable dep : dependables = DeployUtil.getDependables((Interdependency)interdep, Dependable.class)) {
            Element src = dep.getSource();
            if (src instanceof Interdependency && visitedNodes.contains(src)) continue;
        }
        return seen.toArray(new NodeDependable[seen.size()]);
    }

    public static boolean isDependableExist(Dependable dependable) {
        if (dependable instanceof ProfileDependable) {
            return ((ProfileDependable)dependable).doesExist();
        }
        if (dependable instanceof NodeDependable) {
            return ((NodeDependable)dependable).doesExist();
        }
        Element source = dependable.getSource();
        return source != null;
    }

    public static DeploymentOptions getDeploymentOptions(Context context) {
        DeploymentOptions options = null;
        if (context != null) {
            options = (DeploymentOptions)((Object)context.getProperty("deployment-options"));
        }
        if (options == null) {
            options = Deployment.getDeploymentOptions();
        }
        return options;
    }

    public static void setDeploymentOptions(Context context, DeploymentOptions options) {
        context.setProperty("deployment-options", (Object)options);
    }

    public static <T extends Dependable> T[] clearDependencies(Interdependency interDep, Class<T> clazz) {
        Dependable[] allDependants;
        for (Dependable dep : allDependants = DeployUtil.getDependables((Interdependency)interDep, clazz)) {
            interDep.removeDependency(dep);
        }
        return allDependants;
    }

    public static Dependable[] clearAllDependencies(Interdependency interDep) {
        return DeployUtil.clearDependencies((Interdependency)interDep, Dependable.class);
    }

    public static void setDependencies(Interdependency interDep, Dependable[] dependables) {
        DeployUtil.setDependencies((Interdependency)interDep, (Dependable[])dependables, Dependable.class);
    }

    public static <T extends Dependable> T[] setDependencies(Interdependency interDep, T[] dependables, Class<T> clazz) {
        Dependable[] cleared = DeployUtil.clearDependencies((Interdependency)interDep, clazz);
        for (T dep : dependables) {
            interDep.addDependency((Dependable)dep);
        }
        return cleared;
    }

    public static Element getDeployElement(DeployShell shell) {
        Profile element = DeployUtil.getProfile(shell);
        if (element == null) {
            element = shell.getContext().getElement();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static URL[] findFast(Project project, String fileName, String extension) {
        block18: {
            if (extension.indexOf("*") >= 0) {
                throw new IllegalArgumentException("\\* not allowed in extension");
            }
            if (extension != null && !extension.startsWith(".")) {
                throw new IllegalArgumentException("Extension should start with .");
            }
            IndexManager indexMgr = IndexManager.getIndexManager();
            Index index = indexMgr.getIndex(project);
            try {
                URL[] uRLArray;
                QueryCriteria criteria = new QueryCriteria();
                String[] s = fileName.split("\\*");
                for (int i = 0; i < s.length; ++i) {
                    if (s[i].length() == 0) continue;
                    if (i == 0 && fileName.startsWith(s[i])) {
                        criteria.put((Object)"file.name.starts.with", (Object)s[i]);
                        continue;
                    }
                    if (i == s.length - 1 && fileName.endsWith(s[i])) {
                        criteria.put((Object)"file.name.ends.with", (Object)s[i]);
                        continue;
                    }
                    criteria.put((Object)"file.name.contains", (Object)s[i]);
                }
                if (extension != null) {
                    criteria.put((Object)"file.extension", (Object)extension);
                }
                index.lock();
                try {
                    uRLArray = index.blockingQuery(criteria);
                }
                catch (Throwable throwable) {
                    try {
                        index.unlock();
                        throw throwable;
                    }
                    catch (QueryFailedException e) {
                        break block18;
                    }
                    catch (InterruptedException e) {
                        break block18;
                    }
                    catch (LockFailedException e) {
                        break block18;
                        {
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                    }
                }
                index.unlock();
                return uRLArray;
            }
            finally {
                index.release();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static URL[] findFastXml(Project project, String rootElem, String nameSpace) {
        block13: {
            IndexManager indexMgr = IndexManager.getIndexManager();
            Index index = indexMgr.getIndex(project);
            try {
                URL[] uRLArray;
                QueryCriteria criteria = new QueryCriteria();
                criteria.put((Object)"xml.root.element", (Object)rootElem);
                if (ModelUtil.hasLength((String)nameSpace)) {
                    criteria.put((Object)"xml.root.namespace", (Object)nameSpace);
                }
                index.lock();
                try {
                    uRLArray = index.blockingQuery(criteria);
                }
                catch (Throwable throwable) {
                    try {
                        index.unlock();
                        throw throwable;
                    }
                    catch (LockFailedException e) {
                        break block13;
                    }
                    catch (InterruptedException e) {
                        break block13;
                    }
                    catch (QueryFailedException e) {
                        break block13;
                        {
                            catch (Throwable throwable2) {
                                throw throwable2;
                            }
                        }
                    }
                }
                index.unlock();
                return uRLArray;
            }
            finally {
                index.release();
            }
        }
        return null;
    }

    public static boolean isDirectoryLibrary(JLibrary lib) {
        URL testURL;
        Object listEntry;
        URLPath classPath = lib.getClassPath();
        List asList = classPath.asList();
        if (asList.size() == 1 && (listEntry = asList.get(0)) instanceof URL && (testURL = (URL)listEntry).getProtocol().equals("file")) {
            return URLFileSystem.isDirectory((URL)((URL)listEntry));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifestFromApplicationFile(File applicationFile) {
        Manifest manifest = null;
        FileInputStream fis = null;
        if (applicationFile == null) {
            return null;
        }
        try {
            if (applicationFile.isDirectory()) {
                File manifestFile = new File(applicationFile.toURI().getPath() + "META-INF/MANIFEST.MF");
                fis = new FileInputStream(manifestFile);
                manifest = new Manifest(fis);
            } else {
                JarFile jarFile = new JarFile(applicationFile);
                manifest = jarFile.getManifest();
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        return manifest;
    }
}

