/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdevimpl.deploy.logging.DeployLogOutputStream;

public class DefaultDeployShellFactory
implements DeployShellFactory {
    private static DefaultDeployShellFactory instance_ = null;
    final ArrayList<Configurator> configurators_ = new ArrayList();

    @Override
    public DeployShell create(int deploySequenceId, Context context, DeployShell parent) throws DeployException {
        DeployShell newShell;
        if (parent != null) {
            newShell = new DeployShell(parent);
            if (context != null) {
                newShell.setContext(context);
            }
        } else {
            Logger deployLogger = Logger.getLogger("oracle.jdeveloper.deploy");
            newShell = new DeployShell(context, deployLogger);
            newShell.setLog(new PrintWriter(new DeployLogOutputStream(deployLogger), true));
        }
        this.configure(newShell);
        return newShell;
    }

    public static synchronized DefaultDeployShellFactory getInstance() {
        if (instance_ == null) {
            instance_ = new DefaultDeployShellFactory();
        }
        return instance_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfigurator(Configurator configurator) {
        ArrayList<Configurator> arrayList = this.configurators_;
        synchronized (arrayList) {
            this.configurators_.add(configurator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterConfigurator(Configurator configurator) {
        ArrayList<Configurator> arrayList = this.configurators_;
        synchronized (arrayList) {
            return this.configurators_.remove(configurator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(DeployShell shell) throws DeployException {
        ArrayList<Configurator> arrayList = this.configurators_;
        synchronized (arrayList) {
            for (Configurator c : this.configurators_) {
                c.configure(shell);
            }
        }
    }

    private DefaultDeployShellFactory() {
        this.registerConfigurator(new RootConfigurator());
    }

    class RootConfigurator
    implements Configurator {
        RootConfigurator() {
        }

        @Override
        public void configure(DeployShell shell) {
            shell.setDeployShellFactory(DefaultDeployShellFactory.this);
        }
    }

    public static interface Configurator {
        public void configure(DeployShell var1) throws DeployException;
    }
}

