/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import oracle.ide.model.DataContainer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;

public class AutoSyncSettings
extends HashStructureAdapter {
    public static final String DATA_KEY = DeploymentProfiles.class.getName();
    public static final String AUTOSYNC_KEY = "Weblogic-JDBC-Auto-Sync-Key";
    private DataContainer _container = null;

    private AutoSyncSettings(HashStructure hash, DataContainer container) {
        super(hash);
        this._container = container;
    }

    public static AutoSyncSettings getInstance(DataContainer container) {
        return AutoSyncSettings.getInstance(container, AutoSyncSettings.isCustomSettingsActive(container));
    }

    public static AutoSyncSettings getInstance(DataContainer container, boolean userPropertiesMode) {
        HashStructure properties = AutoSyncSettings.getContainerProperties(container, userPropertiesMode);
        return new AutoSyncSettings(properties.getOrCreateHashStructure(DATA_KEY), container);
    }

    private static HashStructure getContainerProperties(DataContainer container, boolean userPropertiesMode) {
        return userPropertiesMode ? container.getUserPropertiesOnly() : container.getSharedPropertiesOnly();
    }

    public boolean getAutoSyncFlag() {
        boolean flag = this.getHashStructure().getBoolean(AUTOSYNC_KEY, true);
        return flag;
    }

    public void setAutoSyncFlag(Boolean flag) {
        this.getHashStructure().putBoolean(AUTOSYNC_KEY, flag.booleanValue());
    }

    public static boolean isCustomSettingsActive(DataContainer container) {
        HashStructure allChainedProperties = container.getProperties();
        HashStructure chained = allChainedProperties.getOrCreateHashStructure(DATA_KEY);
        return chained.isAnyValueOverridden(new String[]{AUTOSYNC_KEY});
    }
}

