/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;

public class PackagePopup
extends JTextField
implements ActionListener {
    protected Project _project;
    protected JavaManager _javaManager;
    protected BrowseHandler _browseHandler;

    public PackagePopup() {
        this.addFocusListener(new SelectOnFocusListener());
    }

    public PackagePopup(Project project) {
        this();
        this.setProject(project);
    }

    public void setProject(Project project) {
        this._project = project;
        this._javaManager = JavaManager.getJavaManager((Project)this._project);
        this._browseHandler = BrowseHandler.createPackageBrowserPopup(this._javaManager, this, null);
    }

    public String getPackage() {
        return this._browseHandler != null ? this._browseHandler.getSelectedItem() : this.getText();
    }

    public void setPackage(String pkgName) {
        this.setText(pkgName);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doBrowse();
    }

    protected void doBrowse() {
        ClassPackageBrowserV2 browserDlg = new ClassPackageBrowserV2();
        int mode = 1;
        String[] result = browserDlg.browseClassOrPackage(this._javaManager, mode, false, (ClassPackageBrowserFilterV2)null, this.getText());
        if (result.length > 0) {
            this.setBrowseResult(result[0]);
        }
    }

    protected final void setBrowseResult(Object result) {
        if (result != null && this.isResultValid(result)) {
            this.setPackage((String)result);
        }
    }

    private boolean isResultValid(Object value) {
        boolean result = false;
        if (value instanceof String) {
            result = IdeUtil.isPackageIdentifier((String)((String)value));
        }
        return result;
    }

    private class SelectOnFocusListener
    implements FocusListener {
        private SelectOnFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            PackagePopup.this.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

