/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.Component;
import java.util.Iterator;
import javax.swing.MutableComboBoxModel;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.model.Project;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;

public class PackagePicker
extends AbstractPicker {
    private Project _proj;

    public PackagePicker() {
        this.setEditable(true);
        this.setValidator(new PackageValidator());
    }

    public PackagePicker(Project proj) {
        this();
        this.setProject(proj);
    }

    public void setProject(Project proj) {
        if (this._proj != proj) {
            Iterator iter;
            MutableComboBoxModel model = (MutableComboBoxModel)this.getModel();
            int size = model.getSize();
            for (int i = size - 1; i >= 0; --i) {
                model.removeElementAt(i);
            }
            ListStructure pkgs = JavaProject.getInstance((Project)proj).getRecentPackages();
            if (pkgs != null && (iter = pkgs.iterator()) != null) {
                while (iter.hasNext()) {
                    model.addElement(iter.next());
                }
            }
            String defPkg = JavaProject.getInstance((Project)proj).getMostRecentPackage();
            this.addValue(defPkg);
            model.setSelectedItem(defPkg);
            this._proj = proj;
        }
    }

    public void setPackage(String pkg) {
        if (pkg == null) {
            pkg = "";
        }
        this.setCurrentValue(pkg);
    }

    public String getPackage() {
        Object value = this.getCurrentValue();
        return value != null ? value.toString() : "";
    }

    protected void doBrowse() {
        if (this._proj != null) {
            String pkg = ClassPackageBrowserV2.browseClassOrPackage((Component)((Object)this), this._proj, 1);
            this.setBrowseResult(pkg);
        }
    }

    protected String getInvalidValueErrorTitle() {
        return ControlsArb.getString((int)67);
    }

    private static class PackageValidator
    implements AbstractPicker.PickerResultValidator {
        private PackageValidator() {
        }

        public boolean isResultValid(Object value) {
            boolean result = false;
            if (value instanceof String) {
                result = IdeUtil.isPackageIdentifier((String)((String)value));
            }
            return result;
        }

        public String getInvalidValueMsg(Object value) {
            return JProjectArb.format((int)126, (Object)value);
        }
    }
}

