/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ide.log.LogPage;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.CompilerPage;
import oracle.jdeveloper.compiler.ProblemsPage;
import oracle.jdeveloper.compiler.Translator;
import oracle.ojc.interfaces.Storage;

public class IdeLog
implements Translator.Log {
    private int errCnt = 0;
    private int wrnCnt = 0;
    private Workspace workspace = null;
    private Project project = null;
    private HashMap asyncLogPages = new HashMap();
    private ArrayList msgList = new ArrayList();
    private HashMap clearCache = new HashMap();

    public void reinit() {
        this.errCnt = 0;
        this.wrnCnt = 0;
        this.workspace = null;
        this.project = null;
        this.asyncLogPages.clear();
        this.msgList.clear();
        this.clearCache.clear();
        this.starting();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace wsp) {
        this.workspace = wsp;
    }

    public static int getPartialUsedStarImportCode() {
        if (oracle.ojc.compiler.Message.warningPartialUsedStarImport != null) {
            return oracle.ojc.compiler.Message.warningPartialUsedStarImport.getNumber();
        }
        return -1;
    }

    public static int getUnusedImportCode() {
        if (oracle.ojc.compiler.Message.warningUnusedImport != null) {
            return oracle.ojc.compiler.Message.warningUnusedImport.getNumber();
        }
        return -1;
    }

    public static boolean isPartiallyUsedImportWarning(Message msg) {
        return msg.code >= 0 && msg.code == IdeLog.getPartialUsedStarImportCode();
    }

    public static boolean isUnusedImportWarning(Message msg) {
        return msg.code >= 0 && msg.code == IdeLog.getUnusedImportCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessages() {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            if (this.asyncLogPages.size() > 0) {
                for (LogPage page : this.asyncLogPages.keySet()) {
                    for (int j = 0; j < this.msgList.size(); ++j) {
                        page.log((Object)((Message)this.msgList.get(j)));
                    }
                }
                this.msgList.clear();
            }
        }
    }

    private void printMsg(boolean warning, Storage source, int line, int col, int errNumber, String errMsg) {
        StringBuffer s = new StringBuffer(CompArb.getString(warning ? 39 : 38));
        if (line > 0) {
            s.append('(');
            s.append(line);
            if (col > 0) {
                s.append(',');
                s.append(col);
            }
            s.append(')');
        }
        s.append(": ");
        s.append(errMsg);
        Message message = new Message(this.workspace, source == null ? null : this.project, source, s.toString(), errNumber, line, col, warning ? 2 : 1);
        this.msgList.add(message);
        this.logMessages();
    }

    @Override
    public void error(Storage source, int line, int col, int errNumber, String errMsg) {
        this.printMsg(false, source, line, col, errNumber, errMsg);
        ++this.errCnt;
    }

    @Override
    public void warning(Storage source, int line, int col, int errNumber, String errMsg) {
        this.printMsg(true, source, line, col, errNumber, errMsg);
        ++this.wrnCnt;
    }

    @Override
    public void clear(Storage source) {
        if (source != null) {
            if (this.clearCache.get(source.getPath()) != null) {
                return;
            }
            this.clearCache.put(source.getPath(), source.getPath());
        }
        Message message = new Message(this.workspace, this.project, source, null, -1, 0, 0, 3);
        this.msgList.add(message);
        this.logMessages();
    }

    private void starting() {
        Message message = new Message(this.workspace, this.project, null, null, -1, 0, 0, 6);
        this.msgList.add(message);
        this.logMessages();
    }

    public void completed() {
        Message message = new Message(this.workspace, this.project, null, null, -1, 0, 0, 4);
        this.msgList.add(message);
        this.logMessages();
    }

    @Override
    public int nerrors() {
        return this.errCnt;
    }

    @Override
    public int nwarnings() {
        return this.wrnCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAsynchronousLogPage(LogPage asyncLogPage) {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            Integer i = (Integer)this.asyncLogPages.get(asyncLogPage);
            if (i == null) {
                i = new Integer(1);
                if (asyncLogPage instanceof CompilerPage) {
                    ((CompilerPage)asyncLogPage).startAsynchronousLogging();
                } else if (asyncLogPage instanceof ProblemsPage) {
                    ((ProblemsPage)asyncLogPage).startAsynchronousLogging();
                }
            } else {
                i = new Integer(i + 1);
            }
            this.asyncLogPages.put(asyncLogPage, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAsynchronousLogPage(LogPage asyncLogPage) {
        HashMap hashMap = this.asyncLogPages;
        synchronized (hashMap) {
            this.logMessages();
            Integer i = (Integer)this.asyncLogPages.get(asyncLogPage);
            if (i != null) {
                if (i > 1) {
                    this.asyncLogPages.put(asyncLogPage, new Integer(i - 1));
                } else {
                    this.asyncLogPages.remove(asyncLogPage);
                    if (asyncLogPage instanceof CompilerPage) {
                        ((CompilerPage)asyncLogPage).finishAsynchronousLogging();
                    } else if (asyncLogPage instanceof ProblemsPage) {
                        ((ProblemsPage)asyncLogPage).finishAsynchronousLogging();
                    }
                }
            }
        }
    }

    public static class Message {
        static final int Normal = 0;
        static final int Error = 1;
        static final int Warning = 2;
        static final int Remove = 3;
        static final int Completed = 4;
        static final int NoDetails = 5;
        static final int Starting = 6;
        public ActivateEvent activateEvent = null;
        public FixEvent fixEvent = null;
        public Object userData = null;
        Workspace workspace;
        Project project;
        Storage fname;
        String msg;
        int line;
        int col;
        int code;
        int kind;

        private Message() {
        }

        private void checkProject() {
            Node n;
            String parentProjectString;
            if (this.project != null && (parentProjectString = this.project.getProperty("realProject")) != null && (n = NodeFactory.find((URL)URLFactory.newFileURL((String)parentProjectString))) instanceof Project) {
                this.project = (Project)n;
            }
        }

        public Message(Workspace wsp, Project project, Storage fname, String msg, int code, int line, int col, int kind) {
            this.fname = fname;
            this.msg = msg;
            this.workspace = wsp;
            this.project = project;
            this.code = code;
            this.line = line;
            this.col = col;
            this.kind = kind;
            this.checkProject();
        }

        public Message(Workspace wsp, Project project, Storage fname, String msg, int code, int line, int col) {
            this(wsp, project, fname, msg, code, line, col, 0);
        }

        public String toString() {
            return this.msg;
        }

        public boolean isWarning() {
            return this.kind == 2;
        }

        public boolean isError() {
            return this.kind == 1;
        }

        public boolean isRemove() {
            return this.kind == 3;
        }

        public boolean isStarting() {
            return this.kind == 6;
        }

        public boolean isCompleted() {
            return this.kind == 4;
        }

        public boolean isNoDetails() {
            return this.kind == 5;
        }

        public Project getProject() {
            return this.project;
        }

        public Workspace getWorkspace() {
            return this.workspace;
        }

        public String getMessage() {
            return this.msg;
        }
    }

    public static interface FixEvent {
        public void fix(Message var1);

        public boolean canFix(Message var1);
    }

    public static interface ActivateEvent {
        public void activate(Message var1);
    }
}

