/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import oracle.ide.Addin;
import oracle.ide.compiler.Compiler;
import oracle.ide.compiler.CopyListener;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ResourcePaths;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.CompArb;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdeveloper.compiler.UnifiedBuildSystem;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.ojc.interfaces.Storage;

public class CopyTranslator
implements Translator,
Addin {
    private Translator.Log log = null;
    private String[] copyResSpec = null;
    private boolean reverseCopyRes = false;
    private boolean native2asciiAvailable = true;
    private Method native2asciiMainDotConvert = null;
    private Object native2asciiMainInstance = null;

    @Override
    public String getName() {
        return "CopyTranslator";
    }

    @Override
    public ArrayList getInputTypes() {
        if (this.copyResSpec != null && !this.reverseCopyRes) {
            ArrayList<String> v = new ArrayList<String>(this.copyResSpec.length);
            for (int i = 0; i < this.copyResSpec.length; ++i) {
                v.add(this.copyResSpec[i]);
            }
            return v;
        }
        return new ArrayList(0);
    }

    @Override
    public ArrayList getOutputTypes() {
        ArrayList v = new ArrayList(0);
        return v;
    }

    @Override
    public boolean canBuild(Storage store) {
        return JCompiler.isCopyable(store.getName(), this.copyResSpec, this.reverseCopyRes);
    }

    @Override
    public boolean needToBuild(Storage store) {
        return false;
    }

    @Override
    public void setLog(Translator.Log log) {
        this.log = log;
    }

    @Override
    public void setParameter(String name, String value) {
        throw new Error();
    }

    @Override
    public void setProject(Project project) {
        if (project != null) {
            this.copyResSpec = JCompiler.getCopyRes(project);
            this.reverseCopyRes = JCompiler.getReverseCopyRes(project);
        }
    }

    @Override
    public void updateProject(Project project) {
        this.setProject(project);
    }

    private void initializeListeners(Project prj) {
        ArrayList cls = JCompiler.getInstance().copyListeners;
        for (int i = 0; i < cls.size(); ++i) {
            CopyListener listener = (CopyListener)cls.get(i);
            long startTime = System.nanoTime();
            listener.initialize(prj);
            long endTime = System.nanoTime();
            PerformanceLogger.get().log("CopyListener.initialize()", listener.getClass().getName(), endTime - startTime);
        }
    }

    private boolean handledByListeners(URL url, URL[] outURLArray) {
        ArrayList cls = JCompiler.getInstance().copyListeners;
        for (int i = 0; i < cls.size(); ++i) {
            CopyListener listener = (CopyListener)cls.get(i);
            long startTime = System.nanoTime();
            boolean handled = listener.handleCopy(url, outURLArray);
            long endTime = System.nanoTime();
            PerformanceLogger.get().log("CopyListener.handleCopy", listener.getClass().getName(), endTime - startTime);
            if (!handled) continue;
            return true;
        }
        return false;
    }

    private void terminateListeners() {
        ArrayList cls = JCompiler.getInstance().copyListeners;
        for (int i = 0; i < cls.size(); ++i) {
            ((CopyListener)cls.get(i)).terminate();
        }
    }

    private boolean native2ascii(Storage f, URL srcUrl, URL destUrl) {
        String in = new File(srcUrl.getPath()).getPath();
        File outFile = new File(destUrl.getPath());
        File outDir = outFile.getParentFile();
        String out = outFile.getPath();
        Throwable excpt = null;
        try {
            Object[] args;
            if (this.native2asciiMainInstance == null) {
                Class<?> c = Class.forName("sun.tools.native2ascii.Main");
                this.native2asciiMainDotConvert = c.getMethod("convert", String[].class);
                this.native2asciiMainInstance = c.newInstance();
            }
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            if (((Boolean)this.native2asciiMainDotConvert.invoke(this.native2asciiMainInstance, args = new Object[]{new String[]{"-encoding", IdeUtil.getIdeEncoding(), in, out}})).booleanValue()) {
                return true;
            }
        }
        catch (Throwable e) {
            excpt = e;
            this.native2asciiAvailable = false;
        }
        String excptStr = excpt != null ? excpt.getMessage() : "";
        String msg = CompArb.format(69, f.getName(), excptStr);
        this.log.error(f, 0, 0, 0, msg);
        return false;
    }

    private void performCopy(Storage f, URL url, String srcName, Node node, URL outname) throws IOException {
        boolean n2a;
        UnifiedBuildSystem.getInstance().markTranslated(this, f);
        boolean bl = n2a = this.native2asciiAvailable && srcName.endsWith(".properties");
        if (UnifiedBuildSystem.showCompileProgress) {
            int msgId = n2a ? 68 : 65;
            Compiler.getCompiler().logOutMsg("  ");
            Compiler.getCompiler().logOutMsg(CompArb.format(msgId, srcName));
            Compiler.getCompiler().logOutMsg("\n");
        }
        URL n2aOutname = null;
        if (n2a) {
            File tmpFile = File.createTempFile("JDev", null);
            n2aOutname = outname;
            outname = URLFactory.newFileURL((String)tmpFile.toString());
        }
        if (node != null) {
            InputStream is = node instanceof TextNode ? ((TextNode)node).getInputStream(false) : node.getInputStream();
            URLFileSystem.copy((InputStream)is, (URL)outname);
            is.close();
        } else {
            URLFileSystem.copy((URL)url, (URL)outname);
        }
        if (!(!n2a || this.native2asciiAvailable && this.native2ascii(f, outname, n2aOutname))) {
            URLFileSystem.copy((URL)outname, (URL)n2aOutname);
        }
    }

    @Override
    public int translate(Project prj, boolean rebuild, ArrayList sources, ArrayList results) {
        UnifiedBuildSystem.getInstance().beginMarking(this);
        Project jprj = prj;
        URL outpath = JavaProject.getInstance((Project)jprj).getOutputDirectory();
        String outpathFilePath = outpath != null ? new File(outpath.getPath()).getPath() : null;
        URLPath htmlpath = new URLPath(J2eeSettings.getInstance(jprj).getHtmlRootDirectory());
        this.initializeListeners(prj);
        URLPath sourceUrlPath = PathsConfiguration.getInstance((Project)jprj).getSourcePath();
        URLPath resourceUrlPath = ResourcePaths.getInstance((PropertyStorage)jprj).getProjectResourcesPath();
        int errcnt = 0;
        for (int i = 0; i < sources.size() && !Thread.currentThread().isInterrupted(); ++i) {
            String str;
            Storage f = (Storage)sources.get(i);
            try {
                long srcTime;
                URL url;
                Node node = f instanceof IdeStorage ? ((IdeStorage)f).node : null;
                URL uRL = url = node != null ? node.getURL() : URLFactory.newFileURL((String)f.getPath());
                if (outpathFilePath != null && new File(url.getPath()).getPath().startsWith(outpathFilePath)) continue;
                URL[] outURLArray = new URL[]{null};
                if (this.handledByListeners(url, outURLArray)) {
                    UnifiedBuildSystem.getInstance().markTranslated(this, f);
                    continue;
                }
                URL outname = outURLArray[0];
                String srcName = null;
                if (sourceUrlPath != null) {
                    srcName = sourceUrlPath.toRelativePath(url);
                }
                if (outname == null && srcName == null && htmlpath.toRelativePath(url) != null) continue;
                if (srcName == null && resourceUrlPath != null) {
                    srcName = resourceUrlPath.toRelativePath(url);
                }
                if (outname == null) {
                    if (srcName == null) {
                        if (!UnifiedBuildSystem.showCompileProgress) continue;
                        Compiler.getCompiler().logOutMsg("  ");
                        Compiler.getCompiler().logOutMsg(CompArb.format(66, f.toString()));
                        Compiler.getCompiler().logOutMsg("\n");
                        continue;
                    }
                    outname = URLFactory.newURL((URL)outpath, (String)srcName);
                } else if (srcName == null) {
                    srcName = url.getPath();
                }
                if (node == null && !URLFileSystem.exists((URL)url)) {
                    int idx = 59;
                    String str2 = CompArb.format(59, f.getName());
                    this.log.error(f, 0, 0, 0, str2);
                    ++errcnt;
                    continue;
                }
                if (outpath == null) {
                    this.log.error(f, 0, 0, 0, CompArb.getString(61));
                    ++errcnt;
                    continue;
                }
                long l = srcTime = node != null ? node.getTimestamp() : URLFileSystem.lastModified((URL)url);
                if (!rebuild && srcTime <= URLFileSystem.lastModified((URL)outname) || node != null && node.getURL().equals(outname) || node == null && url.equals(outname)) continue;
                if (!URLFileSystem.isReadOnly((URL)outname)) {
                    this.performCopy(f, url, srcName, node, outname);
                    continue;
                }
                this.log.error(f, 0, 0, 0, CompArb.getString(57));
                ++errcnt;
                continue;
            }
            catch (FileNotFoundException e) {
                int idx = 59;
                str = CompArb.format(59, f.getPath());
                this.log.error(f, 0, 0, 0, str);
                ++errcnt;
                continue;
            }
            catch (IOException e) {
                int idx = 117;
                str = CompArb.format(117, f.getPath());
                this.log.error(f, 0, 0, 0, str);
                ++errcnt;
                continue;
            }
            catch (Exception e) {
                FeedbackManager.reportException((String)"Exception in CopyTranslator while copying file", (Throwable)e);
                this.log.error(f, 0, 0, 0, CompArb.getString(89));
                ++errcnt;
            }
        }
        this.terminateListeners();
        return errcnt;
    }

    public void initialize() {
        JCompiler.getInstance().registerTranslator(this);
    }
}

