/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.jdeveloper.compiler.BuildNode;
import oracle.jdeveloper.compiler.Translator;

class BuildGraph {
    ArrayList buildRoots = new ArrayList(5);
    HashMap buildNodes = new HashMap(19);

    BuildGraph() {
    }

    static boolean isPreprocessor(Translator translator) {
        ArrayList in = translator.getInputTypes();
        ArrayList out = translator.getOutputTypes();
        if (in.size() >= 1 && in.size() == out.size()) {
            for (int i = 0; i < in.size(); ++i) {
                if (out.contains(in.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void walkAndInsertInOrderedList(BuildNode n, ArrayList result) {
        if (n.marker == 0 && n.translator != null) {
            int j;
            for (int i = 0; i < n.children.size(); ++i) {
                BuildNode c = (BuildNode)n.children.get(i);
                this.walkAndInsertInOrderedList(c, result);
            }
            n.marker = 1;
            for (j = 0; j < result.size() && result.get(j) != n.translator; ++j) {
            }
            if (j >= result.size()) {
                result.add(0, n.translator);
                if (n.preProcessors != null) {
                    for (int k = 0; k < n.preProcessors.size(); ++k) {
                        Translator t = (Translator)n.preProcessors.get(k);
                        if (result.contains(t)) continue;
                        result.add(0, t);
                    }
                }
            }
        }
    }

    public ArrayList getOrderedTranslatorList() {
        ArrayList result = new ArrayList();
        for (int i = 0; i < this.buildRoots.size(); ++i) {
            BuildNode n = (BuildNode)this.buildRoots.get(i);
            this.walkAndInsertInOrderedList(n, result);
        }
        Iterator e = this.buildNodes.values().iterator();
        while (e.hasNext()) {
            ((BuildNode)e.next()).marker = 0;
        }
        return result;
    }

    private boolean walkChildren(BuildNode node, int marker) {
        if (node.marker == marker) {
            System.out.println("error: walkGraph: circularity detected with node");
            return false;
        }
        node.marker = marker;
        for (int i = 0; i < node.children.size(); ++i) {
            if (this.walkChildren((BuildNode)node.children.get(i), marker)) continue;
            return false;
        }
        if (node.children.size() != 0 ^ node.translator != null && node.translator != null && node.translator.getOutputTypes().size() > 0 && !BuildGraph.isPreprocessor(node.translator)) {
            System.out.println("internal error: walkGraph: node with children should have a translator && node without them shouldn't have one");
        }
        node.marker = -1;
        return true;
    }

    private boolean checkGraph() {
        boolean result = true;
        for (int i = 0; i < this.buildRoots.size(); ++i) {
            if (this.walkChildren((BuildNode)this.buildRoots.get(i), i + 1)) continue;
            result = false;
        }
        for (BuildNode node : this.buildNodes.values()) {
            if (node.marker == 0) {
                System.out.println("checkGraph: node is not reachable");
                result = false;
            }
            node.marker = 0;
        }
        return result;
    }

    boolean rebuild(HashMap translators) {
        this.buildNodes.clear();
        this.buildRoots.clear();
        for (String ext : translators.keySet()) {
            ArrayList al = (ArrayList)translators.get(ext);
            for (int ti = 0; ti < al.size(); ++ti) {
                Translator t = (Translator)al.get(ti);
                BuildNode node = (BuildNode)this.buildNodes.get(ext);
                if (node == null) {
                    node = new BuildNode(ext, t);
                    this.buildNodes.put(ext, node);
                    this.buildRoots.add(node);
                } else if (node != null && !node.containsTranslator(t)) {
                    node.addTranslator(t);
                }
                if (BuildGraph.isPreprocessor(t)) continue;
                ArrayList children = t.getOutputTypes();
                for (int i = 0; i < children.size(); ++i) {
                    int j;
                    String childExt = (String)children.get(i);
                    BuildNode child = (BuildNode)this.buildNodes.get(childExt);
                    if (child == null) {
                        child = new BuildNode(childExt, (ArrayList)translators.get(childExt));
                        this.buildNodes.put(childExt, child);
                    }
                    if (child == node) continue;
                    for (j = 0; j < child.parents.size() && child.parents.get(j) != node; ++j) {
                    }
                    if (j >= child.parents.size()) {
                        child.parents.add(node);
                    }
                    for (j = 0; j < node.children.size() && node.children.get(j) != child; ++j) {
                    }
                    if (j < node.children.size()) continue;
                    node.children.add(child);
                }
            }
        }
        int i = 0;
        while (i < this.buildRoots.size()) {
            BuildNode n = (BuildNode)this.buildRoots.get(i);
            if (n.parents.size() > 0) {
                this.buildRoots.remove(i);
                continue;
            }
            ++i;
        }
        return this.checkGraph() && this.buildRoots.size() > 0;
    }
}

