/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.javapckg;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.model.PathsConfiguration;

public class PackageSourceModel
extends SourceModel {
    @Override
    public String getExtension() {
        return null;
    }

    @Override
    protected String getContentSetKey() {
        return PathsConfiguration.JAVA_CONTENT_SET_KEY;
    }

    @Override
    protected URLPath getSourcePath() {
        return PathsConfiguration.getInstance((Project)this.getProject()).getProjectSourcePath();
    }

    @Override
    public final void setRelativeDirectory(String newDir) {
        int idx;
        if (newDir != null && (idx = newDir.indexOf(46)) >= 0) {
            newDir = (idx = newDir.lastIndexOf(47, idx)) >= 0 ? newDir.substring(0, idx) : "";
        }
        super.setRelativeDirectory(newDir);
    }

    @Override
    public URL getDirectory() {
        return this._getDirectory(false);
    }

    private URL _getDirectory(boolean fastDefault) {
        if (fastDefault) {
            return super.getDirectory();
        }
        String dirString = super.getDirectoryString();
        if (dirString.length() == 0 || this.getProject() == null) {
            return super.getBaseURL();
        }
        Context context = new Context(null, super.getProject());
        URL url = PathsConfiguration.getURLForPackage((String)dirString, (Context)context);
        return url;
    }

    private static boolean createPath(URL rootFolder, List<String> folderNames) {
        URL previousFolder = rootFolder;
        for (int i = 0; i < folderNames.size(); ++i) {
            String folderName = folderNames.get(i);
            URL dirURL = URLFactory.newDirURL((URL)previousFolder, (String)folderName);
            if (!URLFileSystem.exists((URL)dirURL) && !URLFileSystem.mkdir((URL)dirURL)) {
                return false;
            }
            previousFolder = dirURL;
        }
        return true;
    }

    @Override
    public Node createNode() {
        URL dirURL;
        if (!URLFileSystem.exists((URL)this.getDirectory()) && !URLFileSystem.mkdir((URL)this.getDirectory())) {
            return null;
        }
        if (this.getFileName().contains(".")) {
            this.setFileName(this.getFileName().replace('.', File.separatorChar));
            String[] folderTokens = this.getFileName().split(File.separator);
            ArrayList<String> pathToFolder = new ArrayList<String>(Arrays.asList(folderTokens));
            PackageSourceModel.createPath(this.getDirectory(), pathToFolder.subList(0, folderTokens.length - 1));
        }
        if (URLFileSystem.mkdir((URL)(dirURL = URLFactory.newDirURL((String)this.getURL().getPath()))) || URLFileSystem.exists((URL)dirURL) && URLFileSystem.delete((URL)dirURL) && URLFileSystem.mkdir((URL)URLFactory.newDirURL((String)this.getURL().toString()))) {
            this.setURL(URLFactory.newURL((URL)dirURL, (String)"package.html"));
            return super.createNode();
        }
        return null;
    }
}

