/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.javapckg;

import java.awt.Component;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.builder.AbstractBuilderModel;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.file.FileBuilder;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.file.FileBuilderPanel;
import oracle.jdeveloper.builder.javapckg.PackageBuilderPanel;
import oracle.jdeveloper.builder.javapckg.PackageSourceModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class PackageBuilder
extends FileBuilder {
    private FileBuilderPanel _panel = null;

    @Override
    public String getShortLabel() {
        return BuilderArb.getString(169);
    }

    public String getLongLabel() {
        return BuilderArb.getString(170);
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"package.png");
    }

    @Override
    protected String _getTitleString() {
        return this.getShortLabel();
    }

    @Override
    protected String getHelpID() {
        return "f1_idecreatejavapackagedialog_html";
    }

    @Override
    protected AbstractBuilderModel _buildModel(Context context) {
        return new EmptyPackageBuilderModel(context, (Component)((Object)this._panel));
    }

    @Override
    protected Image getHeaderImage() {
        return OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/package_header.png"));
    }

    @Override
    protected BaliWizardPanel buildPanel(Context context, BaliWizardState state) {
        this._panel = new PackageBuilderPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this._panel), this.getHelpID());
        return this._panel;
    }

    @Override
    protected String getHeaderDescription() {
        return BuilderArb.getString(171);
    }

    private class EmptyPackageBuilderModel
    extends FileBuilderModel {
        private final Component builderGUI;

        public EmptyPackageBuilderModel(Context context, Component gui) {
            super(context);
            this.builderGUI = gui;
        }

        @Override
        public String getFileType() {
            return BuilderArb.getString(169);
        }

        @Override
        public String getBuilderType() {
            return "Package";
        }

        @Override
        protected boolean buildFile(Node node) {
            if (super.buildFile(node)) {
                URL url;
                if (node != null && !URLFileSystem.exists((URL)(url = node.getURL()))) {
                    try {
                        URLFileSystem.openOutputStream((URL)url).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        protected String getBaseName() {
            return "package";
        }

        @Override
        protected String getDefaultRelativeDirectory(Project project) {
            return "";
        }

        @Override
        protected void initializeSourceDir(Context ctx) {
            Context context = new Context(ctx);
            if (ctx != null && ctx.getElement() == null) {
                if (ctx.getNode() != null) {
                    context.setElement((Element)ctx.getNode());
                } else if (ctx.getProject() != null) {
                    context.setElement((Element)ctx.getProject());
                }
            }
            super.initializeSourceDir(context);
        }

        @Override
        protected SourceModel createSourceModel() {
            return new PackageSourceModel();
        }

        @Override
        public void reportError(String title, String msg, String helpID) {
            MessageDialog.error((Component)((Object)PackageBuilder.this._panel), (Object)msg, (String)title, (String)helpID);
        }

        @Override
        public boolean isRaiseEditor() {
            return false;
        }

        @Override
        protected boolean shouldAddToProjectContent() {
            return false;
        }
    }
}

