/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.folder;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.TreeNode;
import oracle.ide.Context;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetFolder;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.GalleryArb;
import oracle.ideimpl.navigator.delete.model.FileSystemModelUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.builder.AbstractBuilderModel;
import oracle.jdeveloper.builder.SourceModel;
import oracle.jdeveloper.builder.file.FileBuilder;
import oracle.jdeveloper.builder.file.FileBuilderModel;
import oracle.jdeveloper.builder.folder.FolderBuilderPanel;
import oracle.jdeveloper.builder.folder.FolderSourceModel;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class FolderBuilder
extends FileBuilder {
    @Override
    public String getShortLabel() {
        return BuilderArb.getString(164);
    }

    public String getLongLabel() {
        return BuilderArb.getString(165);
    }

    @Override
    public Icon getIcon() {
        return OracleIcons.getIcon((String)"folder.png");
    }

    @Override
    protected String _getTitleString() {
        return this.getShortLabel();
    }

    @Override
    protected String getHelpID() {
        return "f1_idecreatefolderdialog_html";
    }

    @Override
    protected AbstractBuilderModel _buildModel(Context context) {
        return new EmptyFolderBuilderModel(context);
    }

    @Override
    protected Image getHeaderImage() {
        return OracleIcons.toImage((Icon)OracleIcons.getIcon((String)"header/folder_header.png"));
    }

    @Override
    protected BaliWizardPanel buildPanel(Context context, BaliWizardState state) {
        FolderBuilderPanel panel = new FolderBuilderPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)panel), this.getHelpID());
        return panel;
    }

    @Override
    protected String getHeaderDescription() {
        return BuilderArb.getString(166);
    }

    private static class EmptyFolderBuilderModel
    extends FileBuilderModel {
        private ContentSet m_contentSet;

        public EmptyFolderBuilderModel(Context context) {
            super(context);
        }

        @Override
        public String getFileType() {
            return GalleryArb.getString((int)29);
        }

        @Override
        public String getBuilderType() {
            return "Folder";
        }

        @Override
        protected boolean buildFile(Node node) {
            if (super.buildFile(node)) {
                URL url;
                if (node != null && !URLFileSystem.exists((URL)(url = node.getURL()))) {
                    try {
                        URLFileSystem.openOutputStream((URL)url).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        protected String getBaseName() {
            return "folder";
        }

        @Override
        protected String getDefaultRelativeDirectory(Project project) {
            return "";
        }

        @Override
        protected void initializeSourceDir(Context ctx) {
            Context context = new Context(ctx);
            if (ctx != null && ctx.getElement() == null) {
                if (ctx.getNode() != null) {
                    context.setElement((Element)ctx.getNode());
                } else if (ctx.getProject() != null) {
                    context.setElement((Element)ctx.getProject());
                }
            }
            super.initializeSourceDir(context);
            this.m_contentSet = this.findContentSetFromSelection(ctx);
        }

        private ContentSet findContentSetFromSelection(Context context) {
            ContentSet cs = ProjectContent.getInstance((PropertyStorage)this.getProject()).getContentSet("oracle.ide.model.ResourcePaths/resourcesContentSet");
            TNode[] selectedTNodes = ExplorerContext.getTNodes((Context)context);
            if (selectedTNodes != null) {
                for (TNode selectedTNode : selectedTNodes) {
                    for (TreeNode treeNode : selectedTNode.getPath()) {
                        TNode tnode;
                        if (!(treeNode instanceof TNode) || !((tnode = (TNode)treeNode).getData() instanceof ContentSetFolder)) continue;
                        cs = ((ContentSetFolder)tnode.getData()).getContentSet();
                    }
                }
            }
            return cs;
        }

        @Override
        protected SourceModel createSourceModel() {
            return new FolderSourceModel();
        }

        @Override
        public boolean isRaiseEditor() {
            return false;
        }

        @Override
        protected boolean shouldAddToProjectContent() {
            return true;
        }

        @Override
        protected void addFileToProject(Node node) {
            if (this.m_contentSet.getContentSetName() != null && this.m_contentSet.getContentSetName().equals(ProjectContent.getInstance((PropertyStorage)this.getProject()).getContentSet("oracle.ide.model.ResourcePaths/resourcesContentSet").getContentSetName())) {
                URL newNodeURL = node.getURL();
                this.getProject().ensureOpen();
                String newResourceURL = URLFileSystem.toRelativeSpec((URL)newNodeURL, (URL)URLFactory.newDirURL((File)FileSystemModelUtils.urlToFile((URL)this.getProject().getURL()).getParentFile()), (boolean)false);
                int indexOfSeparator = newResourceURL.lastIndexOf(File.separator);
                String filePortion = newResourceURL.substring(0, indexOfSeparator + 1);
                this.m_contentSet.getPatternFilters().addInclude(filePortion);
            }
        }
    }
}

