/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.builder.cls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.Context;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.model.Project;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.jdeveloper.builder.cls.AttributePanel;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.builder.cls.GeneratorElement;
import oracle.jdeveloper.builder.resource.BuilderArb;
import oracle.jdeveloper.controls.ClassPopup;
import oracle.jdeveloper.controls.PackagePopup;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.wizard.common.BaliWizardPanel;
import oracle.jdeveloper.wizard.common.BaliWizardState;

public class ClassBuilderPanel
extends JPanel
implements BaliWizardPanel {
    protected GridBagLayout mainLayout = new GridBagLayout();
    protected JLabel clsLabel = new JLabel();
    protected JTextField clsField = new JTextField();
    protected JLabel pkgLabel = new JLabel();
    protected PackagePopup pkgPopup = new PackagePopup();
    protected JButton pkgBrowse = new JButton();
    protected ClassPackageBrowserV2 pkgBrowser = new ClassPackageBrowserV2();
    protected JLabel baseLabel = new JLabel();
    protected ClassPopup baseClassPopup = new ClassPopup();
    protected JButton baseBrowse = new JButton();
    protected AttributePanel attrPanel = new AttributePanel();
    private ClassBuilderModel savedState;
    private static int FILENAME_DISPLAY_MAX_LENGTH = 80;

    public ClassBuilderPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.clsField.getDocument().addDocumentListener(new DataFieldDocumentListener());
        this.pkgBrowse.addActionListener(this.pkgPopup);
        ResourceUtils.resLabel((JLabel)this.clsLabel, (Component)this.clsField, (String)BuilderArb.getString(6));
        ResourceUtils.resLabel((JLabel)this.pkgLabel, (Component)this.pkgPopup, (String)BuilderArb.getString(7));
        Border buttonBorder = BorderFactory.createEmptyBorder(6, 6, 6, 6);
        IconicButtonUI.install((AbstractButton)this.pkgBrowse);
        this.pkgBrowse.setContentAreaFilled(false);
        this.pkgBrowse.setBorder(buttonBorder);
        this.pkgBrowse.setToolTipText(BuilderArb.getString(4));
        this.pkgBrowse.setIcon(OracleIcons.getIcon((String)"lov.png"));
        this.baseBrowse.addActionListener(this.baseClassPopup);
        IconicButtonUI.install((AbstractButton)this.baseBrowse);
        this.baseBrowse.setContentAreaFilled(false);
        this.baseBrowse.setBorder(buttonBorder);
        this.baseBrowse.setToolTipText(BuilderArb.getString(151));
        this.baseBrowse.setIcon(OracleIcons.getIcon((String)"lov.png"));
        ResourceUtils.resLabel((JLabel)this.baseLabel, (Component)this.baseClassPopup, (String)BuilderArb.getString(9));
        this.setLayout(this.mainLayout);
        this.add((Component)this.clsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.clsField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 6, 5, 5), 0, 0));
        this.add((Component)this.pkgLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.pkgPopup, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 6, 5, 5), 0, 0));
        this.add((Component)this.pkgBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.baseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.baseClassPopup, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 6, 0, 5), 0, 0));
        this.add((Component)this.baseBrowse, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.attrPanel, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 17, 1, new Insets(11, 0, 0, 0), 0, 0));
    }

    @Override
    public void initializeFromState(BaliWizardState theState) {
        ClassBuilderModel state;
        this.savedState = state = (ClassBuilderModel)theState;
        this.pkgPopup.setProject(state.getProject());
        this.baseClassPopup.setProject(state.getProject());
        this.baseClassPopup.setText(state.getDefaultBaseClass());
        this.baseClassPopup.setValidator(new ClassValidator(state, this.pkgPopup));
        this.baseClassPopup.setClassBuilderModel(state);
        if (state.isSuperclassEditable()) {
            this.baseClassPopup.setEditable(true);
        }
        this.clsField.setText(state.getClassName());
        this.pkgPopup.setText(state.getPackage());
        if (!state.hasAttributes()) {
            this.attrPanel.setVisible(false);
        }
        MutableComboBoxModel model = state.getModel();
        Object selectedItem = model.getSelectedItem();
        this.attrPanel.setModel(model);
        boolean frameAttributes = false;
        Context context = null;
        if (selectedItem instanceof GeneratorElement) {
            GeneratorElement generatorElement = (GeneratorElement)selectedItem;
            String name = generatorElement.getClassName();
            frameAttributes = JFrame.class.getName().equals(name);
            context = state.getContext();
        }
        model.setSelectedItem(selectedItem);
        state.getBuilderDialog().setInitialFocus((Component)this.clsField);
        if (frameAttributes) {
            this.baseClassPopup.getDocument().addDocumentListener(new ClassFieldDocumentListener(this.attrPanel, context));
        }
    }

    @Override
    public boolean validateAndWriteToState(BaliWizardState theState) {
        String classObject;
        String baseName;
        String clsName;
        ClassBuilderModel state = (ClassBuilderModel)theState;
        boolean result = false;
        String pkgName = this.pkgPopup.getText();
        if (pkgName != null) {
            pkgName = pkgName.trim();
        }
        if ((clsName = this.clsField.getText()) != null) {
            clsName = clsName.trim();
        }
        if ((baseName = (classObject = this.baseClassPopup.getText()).toString()) != null && (baseName = baseName.trim()).length() == 0 && this.savedState.isObjectBaseClass()) {
            baseName = "java.lang.Object";
        }
        try {
            state.setPackage(pkgName);
            state.setClassName(clsName);
            ClassValidator validator = (ClassValidator)this.baseClassPopup.getValidator();
            if (validator != null && !validator.isResultValid(baseName)) {
                state.reportError(BuilderArb.getString(35), BuilderArb.format(36, baseName), null);
                this.baseClassPopup.requestFocus();
                result = false;
            } else {
                Object baseValue = this.savedState.encodeValue(baseName);
                this._addBaseClassToModelValue(baseValue);
                this.savedState.getModel().setSelectedItem(baseValue);
                result = this.attrPanel.validateAttributes();
            }
        }
        catch (ClassBuilderModel.IllegalPackageNameException ex) {
            state.reportError(BuilderArb.getString(29), BuilderArb.format(30, pkgName, BuilderArb.getString(32)), "f1_idedclassnameinvalid_html");
            this.pkgPopup.requestFocus();
        }
        catch (ClassBuilderModel.IllegalClassNameException ex) {
            state.reportError(BuilderArb.getString(28), BuilderArb.format(30, this._getDisplayName(clsName, false), BuilderArb.getString(31)), "f1_idedclassnameinvalid_html");
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.DuplicateClassException ex) {
            this.clsField.requestFocus();
        }
        catch (ClassBuilderModel.InvalidFileException ex) {
            state.reportError(BuilderArb.getString(22), BuilderArb.format(141, this._getDisplayName(ex.getPath(), true)), null);
        }
        catch (ClassBuilderModel.UserCancelledFileException ex) {
            this.clsField.requestFocus();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addBaseClassToModelValue(Object value) {
        MutableComboBoxModel model;
        if (value == null || value.toString().length() == 0) {
            return;
        }
        MutableComboBoxModel mutableComboBoxModel = model = this.savedState.getModel();
        synchronized (mutableComboBoxModel) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (!model.getElementAt(i).equals(value)) continue;
                return;
            }
            model.addElement(value);
        }
    }

    private String _getDisplayName(String name, boolean shortenInMiddle) {
        String result = name;
        if (name.length() > FILENAME_DISPLAY_MAX_LENGTH) {
            result = shortenInMiddle ? BuilderArb.format(140, name.substring(0, FILENAME_DISPLAY_MAX_LENGTH / 2), name.substring(name.length() - FILENAME_DISPLAY_MAX_LENGTH / 2)) : BuilderArb.format(139, name.substring(0, FILENAME_DISPLAY_MAX_LENGTH));
        }
        return result;
    }

    public final void setTopLabel(String text) {
        throw new UnsupportedOperationException("setTopLabel() no longer supported");
    }

    private class ClassFieldDocumentListener
    implements DocumentListener {
        private final AttributePanel attrPanel;
        private final Context context;

        ClassFieldDocumentListener(AttributePanel attrPanel, Context context) {
            this.attrPanel = attrPanel;
            this.context = context;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updateOptionalSettings(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updateOptionalSettings(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updateOptionalSettings(e);
        }

        private void updateOptionalSettings(DocumentEvent e) {
            Document document = e.getDocument();
            boolean optionalSettingsEnabled = false;
            try {
                String className = document.getText(0, document.getLength()).trim();
                optionalSettingsEnabled = this.isJFrame(className);
            }
            catch (BadLocationException ignored) {
                // empty catch block
            }
            this.attrPanel.setEnabled(optionalSettingsEnabled);
        }

        private boolean isJFrame(String className) {
            try {
                Class<?> type = Class.forName(className);
                return JFrame.class.isAssignableFrom(type);
            }
            catch (ClassNotFoundException e) {
                if (this.context == null) {
                    return false;
                }
                Project project = this.context.getProject();
                if (project == null) {
                    return false;
                }
                JavaManager manager = JavaManager.getInstance((Project)this.context.getProject());
                JavaClass type = manager.getClass(className);
                if (type == null) {
                    return false;
                }
                return type.isSubtypeOf((JavaType)manager.getClass(JFrame.class.getName()));
            }
        }
    }

    private class DataFieldDocumentListener
    implements DocumentListener {
        private DataFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.enableOK(e);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableOK(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.enableOK(e);
        }

        private void enableOK(DocumentEvent de) {
            Document document = de.getDocument();
            try {
                boolean enable = document.getText(0, document.getLength()).trim().length() > 0;
                ClassBuilderPanel.this.savedState.getBuilderDialog().setOKButtonEnabled(enable);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static class ClassValidator
    implements AbstractPicker.PickerResultValidator {
        private ClassBuilderModel _model;
        private PackagePopup _packagePopup;

        public ClassValidator(ClassBuilderModel model, PackagePopup packagePopup) {
            this._model = model;
            this._packagePopup = packagePopup;
        }

        public boolean isResultValid(Object value) {
            String clsName;
            boolean result = false;
            String pkgName = this._packagePopup.getPackage();
            if (pkgName == null) {
                pkgName = "";
            }
            result = value instanceof JavaClass ? this._model.validateClass((JavaClass)value, pkgName) : (clsName = value.toString()).length() > 0 && this._model.validateClassType(clsName, pkgName);
            return result;
        }

        public String getInvalidValueMsg(Object result) {
            return BuilderArb.format(36, result.toString());
        }
    }
}

