/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.java;

import java.util.Collection;
import java.util.Iterator;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.jdeveloper.audit.java.JavaTransformAdapter;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.audit.java.JavaHelper;

public class JavaTransformContext
extends TransformContext {
    private JavaManager manager;
    private SourceFile file;

    public JavaTransformContext(JavaTransformAdapter adapter, Transform transform, Violation violation, Location location) {
        super((TransformAdapter)adapter, transform, violation, location);
    }

    public JavaManager getJavaManager() {
        if (this.manager == null) {
            this.manager = JavaManager.getJavaManager((Project)this.getProject());
        }
        return this.manager;
    }

    public SourceFile getSourceFile() {
        if (this.file != null) {
            return this.file;
        }
        this.file = (SourceFile)this.getModelAdapter().getRoot();
        return this.file;
    }

    public SourceFactory getSourceFactory() {
        return this.getSourceFile().getFactory();
    }

    public JavaClass getType(String qualifiedName) {
        return this.getSourceFile().getProvider().getClass(qualifiedName);
    }

    public JavaClass[] getTypes(String[] qualifiedNames) {
        JavaProvider provider = this.getSourceFile().getProvider();
        JavaClass[] types = new JavaClass[qualifiedNames.length];
        for (int i = 0; i < qualifiedNames.length; ++i) {
            types[i] = provider.getClass(qualifiedNames[i]);
        }
        return types;
    }

    public void ensureImport(JavaType type) {
        if (type == null) {
            return;
        }
        if (type instanceof JavaTypeVariable) {
            return;
        }
        if (type instanceof JavaWildcardType) {
            return;
        }
        this.ensureImport(type.getQualifiedName());
    }

    public void ensureImport(String typeName) {
        JavaHelper.addImport(this.getSourceFile(), typeName);
    }

    public void ensureImportRetained(String typeName) {
        SourceImport impor = JavaHelper.addImport(this.getSourceFile(), typeName, true);
        if (impor != null) {
            ((JavaTransformAdapter)this.getAdapter()).retainImport(impor);
        }
    }

    public void ensureImports(Collection types) {
        if (types == null) {
            return;
        }
        Iterator i = types.iterator();
        while (i.hasNext()) {
            this.ensureImport((JavaType)i.next());
        }
    }

    public void ensureImports(String[] typeNames) {
        if (typeNames == null) {
            return;
        }
        for (int i = 0; i < typeNames.length; ++i) {
            this.ensureImport(typeNames[i]);
        }
    }
}

