/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.java;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import javax.swing.undo.UndoableEdit;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.java.JavaTransformContext;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.TextFileModelAdapter;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdeveloper.audit.transform.TransformAdapter;
import oracle.jdeveloper.audit.transform.TransformContext;
import oracle.jdeveloper.audit.transform.TransformSequenceContext;
import oracle.jdeveloper.audit.transform.UndoableEditCommand;

public class JavaTransformAdapter
extends TransformAdapter {
    private static final Log LOG = new Log("transformer");
    private SourceTransaction transaction;
    private UndoableEditCommand command;
    private TextBuffer buffer;
    private Set<SourceImport> initialUnusedImports;
    private Set<SourceImport> retainedImports;
    private TransformSequenceContext sequenceContext;

    public Class getContextClass() {
        return JavaTransformContext.class;
    }

    public TransformContext createContext(Transform transform, Violation violation, Location location) {
        return new JavaTransformContext(this, transform, violation, location);
    }

    public void beginTransformSequence(TransformSequenceContext sequenceContext) throws Exception {
        super.beginTransformSequence(sequenceContext);
        TextFileModelAdapter model = (TextFileModelAdapter)sequenceContext.getModel();
        SourceFile file = (SourceFile)model.getRoot();
        if (!file.isCompiled()) {
            file.compile();
        }
        this.initialUnusedImports = new HashSet<SourceImport>();
        for (SourceImport impor : file.getSourceImports()) {
            if (impor.isUsed()) continue;
            this.initialUnusedImports.add(impor);
        }
        this.retainedImports = new HashSet<SourceImport>();
        sequenceContext.setAttribute("initialUnusedImports", this.initialUnusedImports);
        sequenceContext.setAttribute("retainedImports", this.retainedImports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransform(TransformContext context) {
        if (this.transaction != null) {
            throw new IllegalStateException("transaction already begun");
        }
        TextFileModelAdapter model = (TextFileModelAdapter)context.getModel();
        this.buffer = model.getTextBuffer();
        int cid = this.buffer.getChangeId();
        this.buffer.readUnlock();
        this.buffer.writeLock();
        try {
            this.buffer.readLock();
            if (cid != this.buffer.getChangeId()) {
                throw new ExpiredTextBufferException();
            }
            this.command = new UndoableEditCommand(context.getTransform().boundLabel(context), model.getTextNode(), context.getProject(), context.getWorkspace());
            SourceFile file = (SourceFile)model.getRoot();
            this.transaction = file.beginTransaction();
        }
        finally {
            if (this.transaction == null) {
                this.buffer.writeUnlock();
                this.clearFields();
            }
        }
    }

    public void beginTransform(TransformContext context, TransformSequenceContext sequenceContext) {
        this.sequenceContext = sequenceContext;
        this.beginTransform(context);
    }

    public void endTransform(TransformContext context) throws Exception {
        if (this.transaction == null) {
            throw new IllegalStateException("transaction not begun");
        }
        context.getModel().verifyReadTransaction();
        UndoableEdit edit = this.transaction.commit();
        if (edit != null) {
            this.command.addEdit(edit);
            Location selection = this.getSelection();
            if (selection != null) {
                this.command.setSelection(selection.getModel().getUrl(), selection.getOffset(), selection.getLength());
            }
            CommandProcessor.getInstance().invoke((Command)this.command);
        }
        this.buffer.writeUnlock();
        this.clearFields();
    }

    public void cancelTransform(TransformContext context) throws Exception {
        if (this.transaction == null) {
            throw new IllegalStateException("transaction not begun");
        }
        this.transaction.abort();
        this.buffer.writeUnlock();
        this.clearFields();
    }

    private void clearFields() {
        this.transaction = null;
        this.command = null;
        this.buffer = null;
        this.initialUnusedImports = null;
        this.retainedImports = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransformSequence(TransformSequenceContext sequenceContext) throws Exception {
        TextFileModelAdapter model = (TextFileModelAdapter)sequenceContext.getModel();
        TextBuffer buffer = model.getTextBuffer();
        int cid = buffer.getChangeId();
        SourceTransaction transaction = null;
        buffer.readUnlock();
        buffer.writeLock();
        try {
            buffer.readLock();
            if (cid != buffer.getChangeId()) {
                throw new ExpiredTextBufferException();
            }
            SourceFile file = (SourceFile)model.getRoot();
            transaction = file.beginTransaction();
            file.compile();
            List imports = file.getSourceImports();
            this.initialUnusedImports = (HashSet)sequenceContext.getAttribute("initialUnusedImports");
            this.retainedImports = (HashSet)sequenceContext.getAttribute("retainedImports");
            ArrayList<SourceImport> unusedImports = new ArrayList<SourceImport>();
            for (SourceImport impor : imports) {
                if (impor.isUsed() || this.initialUnusedImports.contains(impor) || this.retainedImports.contains(impor)) continue;
                unusedImports.add(impor);
            }
            imports.removeAll(unusedImports);
            UndoableEdit edit = transaction.commit();
            transaction = null;
            UndoableEditCommand command = new UndoableEditCommand("Remove Unused Imports", model.getTextNode(), sequenceContext.getModel().getProject(), sequenceContext.getModel().getWorkspace());
            if (edit != null) {
                command.addEdit(edit);
                Location selection = this.getSelection();
                if (selection != null) {
                    command.setSelection(selection.getModel().getUrl(), selection.getOffset(), selection.getLength());
                }
                CommandProcessor.getInstance().invoke((Command)command);
            }
        }
        catch (CancellationException e) {
            LOG.trace("CancellationException while processing {0}", (Object)((SourceFile)model.getRoot()).getURL());
        }
        finally {
            if (transaction != null) {
                transaction.abort();
            }
            buffer.writeUnlock();
            this.initialUnusedImports = null;
            this.retainedImports = null;
        }
    }

    public void cancelTransformSequence(TransformSequenceContext sequenceContext) throws Exception {
    }

    void retainImport(SourceImport impor) {
        if (this.sequenceContext != null) {
            this.retainedImports = (HashSet)this.sequenceContext.getAttribute("retainedImports");
            if (this.retainedImports != null) {
                this.retainedImports.add(impor);
            }
            this.sequenceContext.setAttribute("retainedImports", this.retainedImports);
        }
    }
}

