/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.dialogs.filter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.CheckBoxListPanel;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.filter.FileTypeIncludeFilter;
import oracle.ide.help.HelpSystem;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;

public class FileTypeIncludeFilterPanel
extends JPanel
implements ListSelectionListener {
    private JLabel _listPanelLbl = new JLabel();
    private CheckBoxListPanel _listPanel;
    private FileTypeIncludeFilter _filter;
    private JLabel _otherLbl = new JLabel();
    private JTextField _otherFld = new JTextField();
    private JRadioButton _selectedDirRB = new JRadioButton();
    private JRadioButton _allDirRB = new JRadioButton();
    private ButtonGroup _buttonGroup = new ButtonGroup();
    private JCheckBox _recurseCB = new JCheckBox();
    private JButton _addToListBtn = new JButton();
    private JButton _removeFromListBtn = new JButton();
    private JRadioButton _allTypesRB = new JRadioButton();
    private JRadioButton _selectedTypesRB = new JRadioButton();
    private ButtonGroup _typeButtonGroup = new ButtonGroup();
    private static final String HELP_TOPIC = "f1_idedfiletypestoexclude_html";

    public FileTypeIncludeFilterPanel(FileTypeIncludeFilter filter) {
        this._filter = filter;
        this.initPanel(true);
    }

    public FileTypeIncludeFilterPanel(FileTypeIncludeFilter filter, boolean showDir) {
        this._filter = filter;
        this.initPanel(showDir);
    }

    private void initPanel(boolean showDirectory) {
        ResourceUtils.resButton((AbstractButton)this._allTypesRB, (String)DialogsArb.getString((int)32));
        ResourceUtils.resButton((AbstractButton)this._selectedTypesRB, (String)DialogsArb.getString((int)33));
        ResourceUtils.resButton((AbstractButton)this._allDirRB, (String)DialogsArb.getString((int)22));
        ResourceUtils.resLabel((JLabel)this._otherLbl, (Component)this._otherFld, (String)DialogsArb.getString((int)26));
        ResourceUtils.resButton((AbstractButton)this._recurseCB, (String)DialogsArb.getString((int)24));
        ResourceUtils.resButton((AbstractButton)this._addToListBtn, (String)DialogsArb.getString((int)28));
        this._addToListBtn.setEnabled(false);
        this._addToListBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTypeIncludeFilterPanel.this._addToListBtn_actionPerformed(e);
            }
        });
        ResourceUtils.resButton((AbstractButton)this._removeFromListBtn, (String)DialogsArb.getString((int)29));
        this._removeFromListBtn.setEnabled(false);
        this._removeFromListBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileTypeIncludeFilterPanel.this._removeFromListBtn_actionPerformed(e);
            }
        });
        this._otherFld.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileTypeIncludeFilterPanel.this._addToListBtn.setEnabled(e.getDocument().getLength() > 0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileTypeIncludeFilterPanel.this._addToListBtn.setEnabled(e.getDocument().getLength() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this._listPanel = new CheckBoxListPanel(this._filter.getListModel());
        this._listPanel.getScrollPane().getViewport().setViewSize(new Dimension(100, 200));
        ResourceUtils.resLabel((JLabel)this._listPanelLbl, (Component)this._listPanel.getList(), (String)DialogsArb.getString((int)34));
        this._listPanel.addButton(this._removeFromListBtn);
        this._listPanel.layoutButtons();
        this.setLayout(new GridBagLayout());
        this._typeButtonGroup.add(this._allTypesRB);
        this._typeButtonGroup.add(this._selectedTypesRB);
        this.add((Component)this._allTypesRB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._allTypesRB.setSelected(true);
        this.add((Component)this._selectedTypesRB, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 10, 0), 0, 0));
        ItemSelectableTracker tracker = new ItemSelectableTracker((ItemSelectable)this._selectedTypesRB, new Component[]{this._listPanel.getList(), this._listPanel.getSelectAllButton(), this._listPanel.getDeselectAllButton(), this._otherFld, this._recurseCB, this._allDirRB, this._selectedDirRB});
        this.add((Component)this._listPanelLbl, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._listPanel, new GridBagConstraints(0, 3, 3, 4, 1.0, 1.0, 17, 1, new Insets(0, 5, 15, 0), 0, 0));
        this.add((Component)this._otherLbl, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._otherFld, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this._addToListBtn, new GridBagConstraints(2, 8, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        if (showDirectory) {
            this._buttonGroup.add(this._selectedDirRB);
            this._buttonGroup.add(this._allDirRB);
            this._allDirRB.setSelected(true);
            this.add((Component)this._allDirRB, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
            this._recurseCB.setSelected(true);
            this.add((Component)this._selectedDirRB, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.add((Component)this._recurseCB, new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        }
        this._listPanel.getList().addListSelectionListener((ListSelectionListener)this);
        this._listPanel.getList().setSelectionMode(0);
    }

    public boolean showDialog(Component parent, String selectedDir) {
        if (this._filter == null) {
            this._filter = new FileTypeIncludeFilter();
        }
        ResourceUtils.resButton((AbstractButton)this._selectedDirRB, (String)DialogsArb.format((int)21, (Object)selectedDir));
        JEWTDialog dialog = this.createDialog(parent);
        if (dialog == null) {
            return false;
        }
        if (dialog.runDialog()) {
            this.commitTo(this._filter);
            return true;
        }
        return false;
    }

    public boolean showDialog(Component parent) {
        JEWTDialog dialog = this.createDialog(parent);
        if (dialog == null) {
            return false;
        }
        if (dialog.runDialog()) {
            this.commitTo(this._filter);
            return true;
        }
        return false;
    }

    protected JEWTDialog createDialog(Component parent) {
        this._filter.clearAllSelectedFilters();
        this._filter.populateListModel();
        this.loadFrom(this._filter);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, HELP_TOPIC);
        JEWTDialog dialog = DialogUtil.createJEWTDialogOwnedBy((Component)parent);
        if (dialog == null) {
            return null;
        }
        dialog.setCenterOver(parent);
        dialog.setContent((Component)this);
        dialog.setInitialFocus((Component)this._listPanel.getList());
        dialog.setTitle(DialogsArb.getString((int)27));
        dialog.setButtonMask(7);
        dialog.setResizable(true);
        dialog.setPreferredSize(new Dimension(400, 500));
        return dialog;
    }

    private void loadFrom(FileTypeIncludeFilter filter) {
        if (filter.getIncludeAllFiles()) {
            this._allTypesRB.setSelected(true);
        } else {
            this._selectedTypesRB.setSelected(true);
        }
        this._recurseCB.setSelected(filter.getRecurseDirectories());
        if (filter.getApplyToDirectory() == 1) {
            this._selectedDirRB.setSelected(true);
            this._allDirRB.setSelected(false);
        } else {
            this._selectedDirRB.setSelected(false);
            this._allDirRB.setSelected(true);
        }
        String exclusions = filter.getUserDefinedExclusions();
        if (ModelUtil.hasLength((String)exclusions)) {
            this._otherFld.setText(exclusions);
            this._addToListBtn.setEnabled(true);
        } else {
            this._addToListBtn.setEnabled(false);
        }
    }

    private void commitTo(FileTypeIncludeFilter filter) {
        filter.setIncludeAllFiles(this._allTypesRB.isSelected());
        filter.setRecurseDirectories(this._recurseCB.isSelected());
        int applyValue = this._selectedDirRB.isSelected() ? 1 : 0;
        filter.setApplyToDirectory(applyValue);
        filter.setUserDefinedExclusions(this._otherFld.getText());
        filter.setSelectedFilters();
    }

    private void _addToListBtn_actionPerformed(ActionEvent e) {
        StringTokenizer st = new StringTokenizer(this._otherFld.getText(), ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (this._filter.addUserDefinedValueToList(token)) continue;
            JOptionPane.showMessageDialog(this, DialogsArb.format((int)30, (Object)token), DialogsArb.getString((int)31), 0);
        }
        this._otherFld.setText("");
        this._addToListBtn.setEnabled(false);
    }

    private void _removeFromListBtn_actionPerformed(ActionEvent e) {
        int selIndex = this._listPanel.getList().getSelectedIndex();
        this._filter.removeUserDefinedValueFromList(selIndex);
        selIndex = Math.min(selIndex, this._listPanel.getList().getModel().getSize() - 1);
        this._listPanel.getList().setSelectedIndex(selIndex);
        this._listPanel.getList().requestFocus();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int idx = this._listPanel.getList().getSelectedIndex();
        if (idx < 0 || idx > this._listPanel.getList().getModel().getSize() - 1) {
            return;
        }
        if (this._filter.isListElementLocked(idx)) {
            this._removeFromListBtn.setEnabled(false);
        } else {
            this._removeFromListBtn.setEnabled(true);
        }
    }
}

