/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.TreeMaker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import oracle.jdevimpl.javacompiler.JavacTreeScanner;

public class JavacCompiler {
    public void doJavacTaskImplCompilation(JavacTaskImpl javacTaskImpl, String excludedClasses, boolean forceCodeGen) throws IOException {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        JavaCompiler sunJavacCompiler = null;
        if (forceCodeGen) {
            sunJavacCompiler = new JavaCompiler(javacTaskImpl.getContext());
        }
        Iterable<? extends CompilationUnitTree> compilationUnits = javacTaskImpl.parse();
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (sunJavacCompiler != null) {
            sunJavacCompiler.log.nerrors = 0;
        }
        Iterable<? extends Element> typeElements = javacTaskImpl.enter(compilationUnits);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (sunJavacCompiler != null) {
            sunJavacCompiler.log.nerrors = 0;
        }
        javacTaskImpl.analyze(typeElements);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (sunJavacCompiler != null) {
            sunJavacCompiler.log.nerrors = 0;
        }
        javacTaskImpl.analyze(null);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (sunJavacCompiler != null) {
            sunJavacCompiler.log.nerrors = 0;
        }
        if (forceCodeGen || excludedClasses != null) {
            ArrayList<String> excludedClassesList = new ArrayList<String>();
            if (excludedClasses != null) {
                StringTokenizer tokenizer = new StringTokenizer(excludedClasses, File.pathSeparator, false);
                while (tokenizer.hasMoreTokens()) {
                    excludedClassesList.add(tokenizer.nextToken());
                }
            }
            TreeMaker treeMaker = TreeMaker.instance(javacTaskImpl.getContext());
            Trees trees = Trees.instance(javacTaskImpl);
            if (treeMaker != null && trees != null) {
                JavacTreeScanner treeScanner = new JavacTreeScanner(javacTaskImpl.getContext(), treeMaker, excludedClassesList);
                for (TypeElement typeElement : typeElements) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    ClassTree classTree = trees.getTree(typeElement);
                    classTree.accept(treeScanner, null);
                }
            }
        }
        javacTaskImpl.generate(typeElements);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (sunJavacCompiler != null) {
            sunJavacCompiler.log.nerrors = 0;
        }
        javacTaskImpl.generate(null);
    }
}

