/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.jdevimpl.javacompiler.FileReadTextBuffer;

public class JavaDependencyProvider {
    private ArrayList<Data> data = new ArrayList();
    private HashMap classMap = new HashMap();
    private HashMap fileMap = new HashMap();
    private String sourceJDK = "1.6";
    private String encoding;
    private static final int MAGIC_HEADER_10_1_3 = 0x10010300;
    private long tickHolder;

    public JavaDependencyProvider() {
    }

    public JavaDependencyProvider(String encoding) {
        this.encoding = encoding;
    }

    public void reinit() {
        this.data.clear();
        this.classMap.clear();
        this.fileMap.clear();
    }

    private void collectSourceFile(SourceFile sf, File path, boolean dependant, int dataIndex) throws IOException {
        Data newData = new Data();
        newData.fileName = path.getPath();
        newData.lastModified = path.lastModified();
        newData.packageName = sf.getPackageName();
        newData.isDependency = dependant;
        List typeList = sf.getPossibleTypes();
        String[] typeArray = new String[typeList.size()];
        typeList.toArray(typeArray);
        newData.typeReferences = typeArray;
        List classList = sf.getSourceClasses();
        Iterator it = classList.iterator();
        String[] classArray = new String[classList.size()];
        int i = 0;
        while (it.hasNext()) {
            classArray[i] = ((SourceClass)it.next()).getName();
            ++i;
        }
        newData.definedClasses = classArray;
        List imports = sf.getSourceImports();
        it = imports.iterator();
        String[] importArray = new String[imports.size()];
        int i2 = 0;
        while (it.hasNext()) {
            importArray[i2] = ((SourceImport)it.next()).getName();
            ++i2;
        }
        newData.imports = importArray;
        if (dataIndex == -1) {
            this.data.add(newData);
        } else {
            this.data.set(dataIndex, newData);
        }
    }

    private static String[] resolveTypes(String pkgName, String[] types, String[] imports, HashMap pkgs, HashMap classMap) {
        int i;
        HashMap<String, String> importSuffixes = new HashMap<String, String>();
        ArrayList<String> wideImports = new ArrayList<String>();
        boolean javaLangFound = false;
        for (i = 0; i < imports.length; ++i) {
            String imp = imports[i];
            int lastDot = imp.lastIndexOf(46);
            if (lastDot < 0) continue;
            if (imp.endsWith("*")) {
                String wideImport = imp.substring(0, lastDot);
                if (pkgs.get(wideImport) != null) {
                    wideImports.add(wideImport);
                }
                javaLangFound = wideImport.equals("java.lang");
                continue;
            }
            importSuffixes.put(imp.substring(lastDot + 1), imp);
        }
        if (!javaLangFound && pkgs.get("java.lang") != null) {
            wideImports.add("java.lang");
        }
        for (i = 0; i < types.length; ++i) {
            String clsName;
            String match;
            String type = types[i];
            int dot = type.indexOf(46);
            if (dot >= 0) {
                if (classMap.get(type) != null) continue;
                type = type.substring(0, dot);
            }
            if ((match = (String)importSuffixes.get(type)) != null) {
                types[i] = match;
                continue;
            }
            boolean found = false;
            for (int j = 0; j < wideImports.size(); ++j) {
                String qName = (String)wideImports.get(j) + type;
                if (classMap.get(qName) == null) continue;
                types[i] = qName;
                found = true;
                break;
            }
            if (found || classMap.get(clsName = pkgName + '.' + type) == null) continue;
            types[i] = clsName;
        }
        return types;
    }

    private void computeDependencies() {
        String pkgName;
        this.classMap.clear();
        HashMap<String, String> pkgs = new HashMap<String, String>();
        for (Data currentData : this.data) {
            pkgName = currentData.packageName;
            if (pkgs.get(pkgName) == null) {
                pkgs.put(pkgName, pkgName);
            }
            File file = currentData.getFile();
            String[] classes = currentData.definedClasses;
            for (int j = 0; j < classes.length; ++j) {
                String className = pkgName + '.' + classes[j];
                if (this.classMap.get(className) == null) {
                    HashMap<String, File> usedBy = new HashMap<String, File>();
                    usedBy.put(" sourcefile ", file);
                    this.classMap.put(className, usedBy);
                    continue;
                }
                File otherSource = (File)((HashMap)this.classMap.get(className)).get(" sourcefile ");
                System.out.println("DependencyProvider Error: class " + className + " from source " + file.getPath() + " already defined in source " + otherSource.getPath());
            }
        }
        for (Data currentData : this.data) {
            pkgName = currentData.packageName;
            String[] typeList = currentData.typeReferences;
            String[] imports = currentData.imports;
            currentData.typeReferences = JavaDependencyProvider.resolveTypes(pkgName, typeList, imports, pkgs, this.classMap);
        }
        for (Data currentData : this.data) {
            File file = currentData.getFile();
            String[] types = currentData.typeReferences;
            for (int j = 0; j < types.length; ++j) {
                HashMap usedBy = (HashMap)this.classMap.get(types[j]);
                if (usedBy == null || usedBy.get(file) != null) continue;
                usedBy.put(file, file);
            }
        }
    }

    private static String[] readStringArray(DataInputStream is, ArrayList strArray) throws IOException {
        String[] a = new String[is.readInt()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (String)strArray.get(is.readInt());
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File dependencyFile, boolean dependant) throws IOException {
        byte[] ba;
        ArrayList<String> strArray;
        FileInputStream fileInput = null;
        FilterInputStream dataInput = null;
        try {
            fileInput = new FileInputStream(dependencyFile);
            dataInput = new DataInputStream(fileInput);
            if (((DataInputStream)dataInput).readInt() != 0x10010300) {
                throw new IOException("invalid magic signature");
            }
            int strCount = ((DataInputStream)dataInput).readInt();
            strArray = new ArrayList<String>(strCount);
            for (int i = 0; i < strCount; ++i) {
                strArray.add(((DataInputStream)dataInput).readUTF());
            }
            ba = new byte[((DataInputStream)dataInput).readInt()];
            ((DataInputStream)dataInput).read(ba);
        }
        finally {
            if (dataInput != null) {
                dataInput.close();
            } else if (fileInput != null) {
                fileInput.close();
            }
        }
        dataInput = null;
        ByteArrayInputStream byteInput = null;
        try {
            byteInput = new ByteArrayInputStream(ba);
            dataInput = new DataInputStream(byteInput);
            int dataCount = ((DataInputStream)dataInput).readInt();
            assert (dataCount % 7 == 0);
            for (int i = 0; i < dataCount; i += 7) {
                Data currentData = new Data();
                currentData.fileName = (String)strArray.get(((DataInputStream)dataInput).readInt());
                currentData.lastModified = ((DataInputStream)dataInput).readLong();
                currentData.packageName = (String)strArray.get(((DataInputStream)dataInput).readInt());
                currentData.typeReferences = JavaDependencyProvider.readStringArray((DataInputStream)dataInput, strArray);
                currentData.definedClasses = JavaDependencyProvider.readStringArray((DataInputStream)dataInput, strArray);
                currentData.imports = JavaDependencyProvider.readStringArray((DataInputStream)dataInput, strArray);
                boolean dep = ((DataInputStream)dataInput).readBoolean();
                currentData.isDependency = dependant || dep;
                this.data.add(currentData);
            }
        }
        finally {
            if (dataInput != null) {
                dataInput.close();
            } else if (byteInput != null) {
                byteInput.close();
            }
        }
    }

    private static int indexedStr(String str, HashMap strMap, ArrayList strArray) {
        Integer I = (Integer)strMap.get(str);
        if (I != null) {
            return I;
        }
        int i = strArray.size();
        strArray.add(str);
        strMap.put(str, new Integer(i));
        return i;
    }

    private static void writeStringArray(String[] strs, DataOutputStream os, HashMap strMap, ArrayList strArray) throws IOException {
        os.writeInt(strs.length);
        for (int i = 0; i < strs.length; ++i) {
            os.writeInt(JavaDependencyProvider.indexedStr(strs[i], strMap, strArray));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File cdiFile) throws IOException {
        FileOutputStream fileOutput = null;
        FilterOutputStream dataOutput = null;
        ByteArrayOutputStream byteArray = null;
        HashMap strMap = new HashMap();
        ArrayList strArray = new ArrayList();
        try {
            byteArray = new ByteArrayOutputStream(this.data.size() / 6 * 32);
            dataOutput = new DataOutputStream(byteArray);
            ((DataOutputStream)dataOutput).writeInt(this.data.size() * 7);
            for (Data currentData : this.data) {
                ((DataOutputStream)dataOutput).writeInt(JavaDependencyProvider.indexedStr(currentData.fileName, strMap, strArray));
                ((DataOutputStream)dataOutput).writeLong(currentData.lastModified);
                ((DataOutputStream)dataOutput).writeInt(JavaDependencyProvider.indexedStr(currentData.packageName, strMap, strArray));
                JavaDependencyProvider.writeStringArray(currentData.typeReferences, (DataOutputStream)dataOutput, strMap, strArray);
                JavaDependencyProvider.writeStringArray(currentData.definedClasses, (DataOutputStream)dataOutput, strMap, strArray);
                JavaDependencyProvider.writeStringArray(currentData.imports, (DataOutputStream)dataOutput, strMap, strArray);
                ((DataOutputStream)dataOutput).writeBoolean(currentData.isDependency);
            }
        }
        finally {
            if (dataOutput != null) {
                dataOutput.close();
            } else if (byteArray != null) {
                byteArray.close();
            }
        }
        dataOutput = null;
        try {
            fileOutput = new FileOutputStream(cdiFile);
            dataOutput = new DataOutputStream(fileOutput);
            ((DataOutputStream)dataOutput).writeInt(0x10010300);
            ((DataOutputStream)dataOutput).writeInt(strArray.size());
            for (int j = 0; j < strMap.size(); ++j) {
                ((DataOutputStream)dataOutput).writeUTF((String)strArray.get(j));
            }
            ((DataOutputStream)dataOutput).writeInt(byteArray.size());
            dataOutput.write(byteArray.toByteArray());
        }
        finally {
            if (dataOutput != null) {
                dataOutput.close();
            } else if (fileOutput != null) {
                fileOutput.close();
            }
        }
    }

    public ArrayList updateData(ArrayList fileList, boolean rebuild, boolean synch) throws IOException {
        ArrayList<File> newParses = new ArrayList<File>();
        int javaParserJ2SE = this.getJavaParserJ2SE();
        this.fileMap.clear();
        for (int i = 0; i < this.data.size(); ++i) {
            Data currentData = this.data.get(i);
            this.fileMap.put(currentData.getFile(), new Integer(i));
        }
        int filesParsed = 0;
        this.startTiming();
        for (int i = 0; i < fileList.size(); ++i) {
            SourceFile sf;
            FileReadTextBuffer buffer;
            long d2;
            long d1;
            if (Thread.currentThread().isInterrupted()) {
                return new ArrayList(0);
            }
            File file = (File)fileList.get(i);
            Integer I = (Integer)this.fileMap.get(fileList.get(i));
            if (!rebuild && I != null && (d1 = this.data.get((int)I.intValue()).lastModified) >= (d2 = file.lastModified()) || (buffer = FileReadTextBuffer.init(file, this.encoding)) == null || (sf = JavaParser.parse((ReadTextBuffer)buffer, (int)javaParserJ2SE)) == null) continue;
            this.collectSourceFile(sf, file, false, I != null ? I : -1);
            newParses.add(file);
            ++filesParsed;
        }
        if (synch) {
            this.startTiming();
            HashMap inputMap = new HashMap();
            for (int i = 0; i < fileList.size(); ++i) {
                inputMap.put(fileList.get(i), fileList.get(i));
            }
            int emptyCount = 0;
            for (int i = 0; i < this.data.size(); ++i) {
                Data currentData = this.data.get(i);
                if (currentData.isDependency || inputMap.get(currentData.getFile()) != null) continue;
                this.data.set(i, null);
                ++emptyCount;
            }
            if (emptyCount > 0) {
                ArrayList<Data> newData = new ArrayList<Data>(this.data.size() - emptyCount);
                for (int i = 0; i < this.data.size(); ++i) {
                    Data currentData = this.data.get(i);
                    if (currentData == null) continue;
                    newData.add(currentData);
                }
                this.data = newData;
            }
            this.fileMap.clear();
            for (int i = 0; i < this.data.size(); ++i) {
                Data currentData = this.data.get(i);
                this.fileMap.put(currentData.getFile(), new Integer(i));
            }
        }
        this.startTiming();
        this.computeDependencies();
        return newParses;
    }

    public Collection getDependants(ArrayList fileList, boolean includeSelf) {
        int i;
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (includeSelf) {
            for (i = 0; i < fileList.size(); ++i) {
                Object o = fileList.get(i);
                map.put(o, o);
            }
        }
        for (i = 0; i < fileList.size(); ++i) {
            File file = (File)fileList.get(i);
            Integer I = (Integer)this.fileMap.get(file);
            if (I == null) {
                throw new IllegalArgumentException(file.getPath() + " not found in table");
            }
            int iVal = I;
            Data currentData = this.data.get(iVal);
            String[] classes = currentData.definedClasses;
            for (int j = 0; j < classes.length; ++j) {
                String className = currentData.packageName + '.' + classes[j];
                HashMap usedBy = (HashMap)this.classMap.get(className);
                Collection files = usedBy.values();
                for (Object o : files) {
                    if (map.get(o) != null) continue;
                    map.put(o, o);
                }
            }
        }
        return map.values();
    }

    void rebaseCdiFile(File cdiFile, String oldBasePath, String newBasePath) throws IOException {
        this.load(cdiFile, false);
        boolean updateFileSeparator = oldBasePath.substring(0, 3).indexOf(File.separatorChar) < 0;
        char oldFileSeparator = '\u0000';
        if (updateFileSeparator) {
            oldFileSeparator = '\\' == File.separatorChar ? (char)'/' : '\\';
        }
        int entriesSkipped = 0;
        int entriesModified = 0;
        for (Data currentData : this.data) {
            if (currentData.fileName.startsWith(oldBasePath)) {
                String tail = currentData.fileName.substring(oldBasePath.length());
                if (updateFileSeparator) {
                    tail = tail.replace(oldFileSeparator, File.separatorChar);
                }
                currentData.fileName = newBasePath + tail;
                ++entriesModified;
                continue;
            }
            System.out.println("Entry skipped: " + currentData.fileName);
            ++entriesSkipped;
        }
        this.save(cdiFile);
    }

    public void setSourceJdk(String sourceJDK) {
        if (sourceJDK != null) {
            this.sourceJDK = sourceJDK;
        }
    }

    private int getJavaParserJ2SE() {
        if (this.sourceJDK.startsWith("1.")) {
            if (this.sourceJDK.equals("1.6")) {
                return 4;
            }
            if (this.sourceJDK.equals("1.5")) {
                return 3;
            }
            if (this.sourceJDK.equals("1.4")) {
                return 2;
            }
            if (this.sourceJDK.equals("1.3")) {
                return 1;
            }
            return 4;
        }
        if (this.sourceJDK.startsWith("6.")) {
            return 4;
        }
        if (this.sourceJDK.startsWith("5.")) {
            return 3;
        }
        return 4;
    }

    private void startTiming() {
        this.tickHolder = System.currentTimeMillis();
    }

    private long elapsedTimeMs() {
        return System.currentTimeMillis() - this.tickHolder;
    }

    private class Data {
        File cachedFile;
        String fileName;
        long lastModified;
        String packageName;
        String[] typeReferences;
        String[] definedClasses;
        String[] imports;
        boolean isDependency;

        private Data() {
        }

        File getFile() {
            if (this.cachedFile == null) {
                this.cachedFile = new File(this.fileName);
            }
            return this.cachedFile;
        }
    }
}

