/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;
import oracle.jdevimpl.javacompiler.ResourceUtils;
import oracle.ojc.interfaces.Storage;
import oracle.ojc.storage.DirectoryStorage;
import oracle.ojc.storage.JarStorage;

public class JavaCompilerOptions {
    private String pathSeparator = System.getProperty("path.separator");
    private boolean checkUnusedJars;
    private boolean verbose;
    private JavaCompilerLog log;

    public JavaCompilerOptions() {
    }

    public JavaCompilerOptions(boolean checkUnusedJars, boolean verbose, JavaCompilerLog log) {
        this();
        this.checkUnusedJars = checkUnusedJars;
        this.verbose = verbose;
        this.log = log;
    }

    List<Storage> makeClassPath(String pathList, String pathKind) throws IllegalArgumentException {
        String msg = ResourceUtils.format("PARSING_PATH", "Parsing path: {0}", pathKind);
        this.logMessage(msg);
        String[] as = JavaCompilerOptions.stringToArray(pathList, this.pathSeparator);
        if (as == null) {
            return new ArrayList<Storage>(0);
        }
        int size = as.length;
        ArrayList<Storage> storageList = new ArrayList<Storage>(size + 10);
        HashSet<String> storagesSeen = new HashSet<String>(size + 10);
        for (int i = 0; i < size; ++i) {
            String dirname = as[i];
            if (dirname == null || dirname.length() <= 0) continue;
            File dirfile = new File(dirname);
            this.addClassPathItemToList(pathKind, storageList, storagesSeen, dirname, dirfile, null, "   ");
        }
        msg = ResourceUtils.format("DONE_PARSING_PATH", "Done parsing path: {0}", pathKind);
        this.logMessage(msg);
        return storageList;
    }

    private static String[] stringToArray(String s, String separator) {
        if (s == null) {
            return null;
        }
        int index = 0;
        int cnt = 0;
        while (true) {
            ++cnt;
            if ((index = s.indexOf(separator, index)) < 0) break;
            ++index;
        }
        if (cnt == 0) {
            return null;
        }
        String[] result = new String[cnt];
        int lastIndex = 0;
        cnt = 0;
        while (true) {
            if ((index = s.indexOf(separator, lastIndex)) < 0) break;
            result[cnt++] = s.substring(lastIndex, index);
            lastIndex = index + 1;
        }
        result[cnt] = s.substring(lastIndex);
        return result;
    }

    private void addClassPathItemToList(String pathKind, ArrayList<Storage> list, HashSet<String> storagesSeen, String dirname, File dirfile, Storage enclosingJar, String indent) throws IllegalArgumentException {
        if (dirname.indexOf("..") >= 0) {
            try {
                dirname = dirfile.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (storagesSeen.contains(dirname)) {
            String msg = ResourceUtils.format("SKIPPING_DUPLICATE_ENTRY", "Skipping duplicate entry: {0}", dirname);
            this.logMessage(indent + msg);
            return;
        }
        storagesSeen.add(dirname);
        this.logMessage(indent + dirname);
        if (dirname.endsWith(".jar") || dirname.endsWith(".zip")) {
            String cp;
            Attributes mainAttrs;
            Manifest manifest;
            JarStorage jarStorage = new JarStorage(dirfile);
            if (!jarStorage.isOpen()) {
                String msg = ResourceUtils.format("ENTRY_DOES_NOT_EXIST", "Path entry does not exist: {0}", dirname);
                this.logMessage(indent + msg);
                return;
            }
            list.add((Storage)jarStorage);
            if (this.checkUnusedJars) {
                jarStorage.setProperty("javacompiler.enclosing.jar", enclosingJar != null ? enclosingJar : jarStorage);
                if (enclosingJar == null) {
                    Boolean used = jarStorage.getPath().replace('\\', '/').indexOf("/jre/") > 0;
                    jarStorage.setProperty("javacompiler.enclosing.jar.used", (Object)used);
                }
            }
            if ((manifest = jarStorage.getManifest()) != null && (mainAttrs = manifest.getMainAttributes()) != null && (cp = mainAttrs.getValue(Attributes.Name.CLASS_PATH)) != null && cp.trim().length() > 0) {
                ArrayList<String> classpathEntries = new ArrayList<String>();
                StringTokenizer st = new StringTokenizer(cp);
                while (st.hasMoreTokens()) {
                    classpathEntries.add(st.nextToken());
                }
                if (this.verbose) {
                    int i;
                    String msg = ResourceUtils.getString("PARSING_MANIFEST_PATH", "Parsing manifest path:");
                    String prefix = indent + msg;
                    this.logMessage(prefix + (String)classpathEntries.get(0));
                    StringBuilder spaces = new StringBuilder(prefix.length());
                    for (i = 0; i < prefix.length(); ++i) {
                        spaces.append(' ');
                    }
                    for (i = 1; i < classpathEntries.size(); ++i) {
                        this.logMessage(spaces.toString() + (String)classpathEntries.get(i));
                    }
                }
                File dir = dirfile.getParentFile();
                for (String entry : classpathEntries) {
                    File cpItemFile = new File(dir, entry);
                    this.addClassPathItemToList(pathKind, list, storagesSeen, cpItemFile.getAbsolutePath(), cpItemFile, (Storage)jarStorage, indent + "   ");
                }
                String msg = ResourceUtils.getString("DONE_PARSING_MANIFEST_PATH", "Done parsing manifest path");
                this.logMessage(indent + msg);
            }
        } else if (dirfile.isDirectory()) {
            list.add((Storage)new DirectoryStorage(dirfile));
        }
    }

    private void logMessage(String message) {
        if (this.verbose) {
            if (this.log != null) {
                this.log.println(message);
            } else {
                System.out.println(message);
            }
        }
    }
}

