/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.OracleExtension;
import com.sun.jdi.OracleReferenceType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.JDWP;
import com.sun.tools.jdi.JDWPException;
import com.sun.tools.jdi.ReferenceTypeImpl;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;

public class OracleReferenceTypeImpl
extends ReferenceTypeImpl
implements OracleReferenceType {
    private boolean isSourceInfoCached;
    private boolean sourceInformationAbsent;
    private String sourceTimeStamp;
    private OracleReferenceType sourcePrimaryRefType;
    private ReferenceTypeImpl refType;
    private static Vector scUnsupportedVMs = new Vector(5);
    private static WeakHashMap scRefTypes = new WeakHashMap();

    private OracleReferenceTypeImpl(ReferenceTypeImpl referenceTypeImpl) throws AbsentInformationException {
        super(referenceTypeImpl.vm, referenceTypeImpl.ref);
        if (!referenceTypeImpl.vm.name().startsWith("Oracle Multi") || OracleReferenceTypeImpl.isUnsupportedVM(scUnsupportedVMs, referenceTypeImpl.vm)) {
            throw new AbsentInformationException();
        }
        this.refType = referenceTypeImpl;
        this.isSourceInfoCached = false;
    }

    private String fetchSource(boolean bl) throws AbsentInformationException {
        this.isSourceInfoCached = true;
        try {
            JDWP.OracleExtension.SourceCode sourceCode = JDWP.OracleExtension.SourceCode.process(this.vm, this, bl);
            if (this.ref != sourceCode.primaryTypeID) {
                ReferenceTypeImpl referenceTypeImpl = this.vm.referenceType(sourceCode.primaryTypeID, sourceCode.refTypeTag);
                this.sourcePrimaryRefType = OracleExtension.convert(referenceTypeImpl);
                return null;
            }
            this.sourcePrimaryRefType = this;
            this.sourceTimeStamp = sourceCode.timeStamp;
            return sourceCode.source;
        }
        catch (JDWPException jDWPException) {
            if (jDWPException.errorCode() == 101) {
                this.sourceInformationAbsent = true;
                throw new AbsentInformationException();
            }
            if (jDWPException.errorCode() == 99) {
                OracleReferenceTypeImpl.addUnsupportedVM(scUnsupportedVMs, this.vm);
                this.sourceInformationAbsent = true;
                throw new AbsentInformationException();
            }
            throw jDWPException.toJDIException();
        }
    }

    public OracleReferenceType sourcePrimaryReferenceType() throws AbsentInformationException {
        if (!this.isSourceInfoCached) {
            this.fetchSource(true);
        }
        if (this.sourceInformationAbsent) {
            throw new AbsentInformationException();
        }
        return this.sourcePrimaryRefType;
    }

    public String sourceTimeStamp() throws AbsentInformationException {
        if (!this.isSourceInfoCached) {
            this.fetchSource(true);
        }
        if (this.sourceInformationAbsent || !this.sourcePrimaryRefType.equals(this)) {
            throw new AbsentInformationException();
        }
        return this.sourceTimeStamp;
    }

    public String sourceCode() throws AbsentInformationException {
        String string = null;
        if (!this.isSourceInfoCached || !this.sourceInformationAbsent && this.sourcePrimaryRefType.equals(this)) {
            string = this.fetchSource(false);
        }
        if (this.sourceInformationAbsent || !this.sourcePrimaryRefType.equals(this)) {
            throw new AbsentInformationException();
        }
        return string;
    }

    boolean isAssignableTo(ReferenceType referenceType) {
        return this.refType.isAssignableTo(referenceType);
    }

    List inheritedTypes() {
        return this.refType.inheritedTypes();
    }

    void addVisibleMethods(Map map) {
        this.refType.addVisibleMethods(map);
    }

    public List allMethods() {
        return this.refType.allMethods();
    }

    private static boolean isUnsupportedVM(Vector vector, VirtualMachine virtualMachine) {
        int n = 0;
        while (n < vector.size()) {
            VirtualMachine virtualMachine2 = (VirtualMachine)((WeakReference)vector.elementAt(n)).get();
            if (vector == null) {
                vector.remove(n);
            } else if (virtualMachine.equals(virtualMachine2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void addUnsupportedVM(Vector vector, VirtualMachine virtualMachine) {
        if (OracleReferenceTypeImpl.isUnsupportedVM(scUnsupportedVMs, virtualMachine)) {
            return;
        }
        WeakReference<VirtualMachine> weakReference = new WeakReference<VirtualMachine>(virtualMachine);
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) == null) {
                vector.setElementAt(weakReference, n);
                return;
            }
            ++n;
        }
        vector.addElement(weakReference);
    }

    public static OracleReferenceType convert(ReferenceType referenceType) throws AbsentInformationException {
        OracleReferenceType oracleReferenceType = (OracleReferenceType)scRefTypes.get(referenceType);
        if (oracleReferenceType == null) {
            oracleReferenceType = new OracleReferenceTypeImpl((ReferenceTypeImpl)referenceType);
            scRefTypes.put(referenceType, oracleReferenceType);
        }
        return oracleReferenceType;
    }
}

