/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.migration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import oracle.adf.share.jndi.AdfJndiContext;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.migration.AbstractDBMigrator;

public abstract class AbstractConnMigrator
extends AbstractDBMigrator
implements IdeListener {
    private Map<String, Referenceable> m_migConns;
    protected File m_srcFile;

    protected void migrateAfterAddinsLoaded(File srcFile) {
        this.m_srcFile = srcFile;
        this.getLogger().fine("Add listener to start migration when all extensions loaded ");
        if (Ide.isRunning()) {
            Ide.addIdeListener((IdeListener)this);
        }
    }

    protected void addConnection(String name, Referenceable ref) {
        if (this.m_migConns == null) {
            this.m_migConns = new HashMap<String, Referenceable>();
        }
        this.getLogger().fine("Cached migrated connection " + name);
        this.m_migConns.put(name, ref);
    }

    protected void migrateConnections() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addinsLoaded(IdeEvent e) {
        block14: {
            try {
                this.migrateConnections();
                if (this.m_migConns == null || this.m_migConns.size() == 0) {
                    this.getLogger().fine("Nothing to do!");
                    break block14;
                }
                Context context = DatabaseContextManager.getDatabaseContext();
                if (context == null) break block14;
                StringBuilder done = new StringBuilder();
                for (Map.Entry<String, Referenceable> entry : this.m_migConns.entrySet()) {
                    String name = entry.getKey();
                    try {
                        context.bind(name, (Object)entry.getValue());
                        if (done.length() > 0) {
                            done.append(", ");
                        }
                        done.append(name);
                    }
                    catch (NamingException ne) {
                        this.getLogger().warning(DBConnArb.format(23, name, ne.getMessage()));
                    }
                }
                if (done.length() <= 0) break block14;
                if (context instanceof AdfJndiContext) {
                    try {
                        ((AdfJndiContext)context).save();
                    }
                    catch (NamingException ne) {
                        this.getLogger().warning(DBConnArb.format(22, ne.getMessage()));
                    }
                }
                this.getLogger().info(DBConnArb.format(21, done.toString()));
            }
            catch (Exception ex) {
                this.getLogger().log(Level.WARNING, DBConnArb.getString(24), ex);
            }
            finally {
                if (Ide.isRunning()) {
                    Ide.removeIdeListener((IdeListener)this);
                }
            }
        }
    }

    public final void mainWindowOpened(IdeEvent e) {
    }

    public final void mainWindowClosing(IdeEvent e) {
    }
}

