/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.db.explorer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnArb;

public class DBConnectionExplorer
extends Explorer {
    private static String[] s_propsToShow;
    private static String[] s_propsLabels;
    private static DefaultTreeCellRenderer s_rend;
    private JTree m_tree;

    public DBConnectionExplorer() {
        if (s_propsToShow == null) {
            s_propsToShow = new String[]{"user", "role", "hostname", "port", "serviceName", "sid", "customUrl", "driver", "dataSourceName", "parameters"};
            s_propsLabels = new String[]{StringUtils.stripMnemonic((String)DBConnArb.getString(76)), StringUtils.stripMnemonic((String)DBConnArb.getString(80)), StringUtils.stripMnemonic((String)DBConnArb.getString(87)), StringUtils.stripMnemonic((String)DBConnArb.getString(88)), StringUtils.stripMnemonic((String)DBConnArb.getString(90)), StringUtils.stripMnemonic((String)DBConnArb.getString(89)), StringUtils.stripMnemonic((String)DBConnArb.getString(6)), StringUtils.stripMnemonic((String)DBConnArb.getString(4)), StringUtils.stripMnemonic((String)DBConnArb.getString(101)), StringUtils.stripMnemonic((String)DBConnArb.getString(102))};
            s_rend = new DefaultTreeCellRenderer();
            s_rend.setOpenIcon(OracleIcons.getIcon((String)"database.png"));
            s_rend.setClosedIcon(OracleIcons.getIcon((String)"database.png"));
            s_rend.setLeafIcon(OracleIcons.getIcon((String)"properties.png"));
        }
    }

    public void setContext(Context context) {
        super.setContext(context);
        MyTreeNode root = null;
        ConnectionInfo info = DatabaseConnectionStores.getInstance().getCurrentConnectionInfo(context);
        if (info != null) {
            Properties connectionProps;
            String conn = info.getConnectionName();
            root = new MyTreeNode(null, conn);
            DatabaseProvider dp = info.getReferenceable();
            if (dp != null && (connectionProps = dp.getProperties()) != null) {
                for (int i = 0; i < s_propsToShow.length; ++i) {
                    String prop = s_propsToShow[i];
                    String label = s_propsLabels[i];
                    String propVal = connectionProps.getProperty(prop);
                    if (!ModelUtil.hasLength((String)propVal)) continue;
                    StringBuffer sb = new StringBuffer(label).append(" ").append(propVal);
                    root.addChild(new MyTreeNode(root, sb.toString()));
                }
            }
        }
        if (root == null) {
            root = new MyTreeNode(null, null);
        }
        this.m_tree = new JTree(new DefaultTreeModel(root));
        this.m_tree.setCellRenderer(s_rend);
    }

    public Component getGUI() {
        return this.m_tree;
    }

    private static class MyTreeNode
    implements TreeNode {
        MyTreeNode m_parent;
        String m_label;
        ArrayList<MyTreeNode> m_children = new ArrayList();

        MyTreeNode(MyTreeNode parent, String label) {
            this.m_parent = parent;
            this.m_label = label;
        }

        public void addChild(MyTreeNode child) {
            this.m_children.add(child);
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return this.m_children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            return this.m_children.size();
        }

        @Override
        public TreeNode getParent() {
            return this.m_parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            return this.m_children.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }

        public Enumeration children() {
            return null;
        }

        public String toString() {
            return this.m_label;
        }
    }
}

