/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.MissingDBConnValueException;
import oracle.jdevimpl.db.DBConnArb;

public class ODBCPanel
extends DefaultTraversablePanel {
    private final JTextField fldDsn = new JTextField();
    private final JTextField fldExtra = new JTextField();
    private final JLabel lblDSN = new JLabel();

    public ODBCPanel() {
        ResourceUtils.resLabel((JLabel)this.lblDSN, (Component)this.fldDsn, (String)DBConnArb.getString(101));
        JLabel lblExtra = new JLabel();
        ResourceUtils.resLabel((JLabel)lblExtra, (Component)this.fldExtra, (String)DBConnArb.getString(102));
        this.setLayout(new GridBagLayout());
        this.add(this.lblDSN, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.fldDsn, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(lblExtra, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.fldExtra, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 12, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(1, 100, 2, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.setHelpID("f1_dbconnection_html");
    }

    public void onEntry(TraversableContext tc) {
        Properties connectionProps = (Properties)tc.get("NewObject");
        String dsn = connectionProps.getProperty("dataSourceName");
        this.fldDsn.setText(dsn);
        String xtra = connectionProps.getProperty("parameters");
        this.fldExtra.setText(xtra);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        String xtra;
        Properties connectionProps = (Properties)tc.get("NewObject");
        String dsn = this.fldDsn.getText();
        MissingDBConnValueException.check(dsn, this.lblDSN);
        if (dsn != null) {
            connectionProps.put("dataSourceName", dsn);
        }
        if ((xtra = this.fldExtra.getText()) != null) {
            connectionProps.put("parameters", xtra);
        }
        connectionProps.remove("customUrl");
        connectionProps.put("oracle.lite.poljdbc.POLJDBCDriver", "sun.jdbc.odbc.JdbcOdbcDriver");
    }
}

