/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import oracle.ide.Context;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.DialogCallbacks;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.panels.GlobalConnectionPanelUI;

public class GlobalDatabaseConnPanel
extends DefaultTraversablePanel {
    public static final String CHOSEN_CONNECTION_NAME = "CHOSEN_DB_CONN_NAME";
    public static final String CHOSEN_STORE_NAME = "CHOSEN_DB_STORE_NAME";
    private GlobalConnectionPanelUI m_connUI;
    private TraversableContext m_traversableContext;
    private boolean m_enforceValidChoice = true;
    private boolean m_canFinish = true;
    private boolean m_showDetails = true;

    public GlobalDatabaseConnPanel() {
        this.layoutComponents();
    }

    public GlobalDatabaseConnPanel(boolean showDetails) {
        this.m_showDetails = showDetails;
        this.layoutComponents();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.m_connUI = this.createConnectionUI();
        this.add(this.m_connUI);
    }

    public final void setEnforceSelection(boolean boo) {
        this.m_enforceValidChoice = boo;
    }

    public final void setCanFinish(boolean canFinish) {
        this.m_canFinish = canFinish;
    }

    protected GlobalConnectionPanelUI createConnectionUI() {
        return new GlobalConnectionPanelUI2(this.m_showDetails);
    }

    public final void onEntry(TraversableContext dataContext) {
        this.m_traversableContext = dataContext;
        this.initPanel(dataContext);
    }

    protected GlobalConnectionPanelUI getConnUI() {
        return this.m_connUI;
    }

    protected void initPanel(TraversableContext dataContext) {
        this.m_connUI.setContext((Context)dataContext.find(Context.class));
        this.m_connUI.setConnectionInfo(this.getConnectionInfo(dataContext));
    }

    protected ConnectionInfo getConnectionInfo(TraversableContext dataContext) {
        return ConnectionInfo.getConnectionInfo(dataContext.getPropertyStorage());
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
    }

    protected void enableExit(boolean enable) {
        if (this.m_traversableContext != null && this.m_enforceValidChoice) {
            DialogCallbacks diagcb;
            WizardCallbacks wizcb = this.m_traversableContext.getWizardCallbacks();
            if (wizcb != null) {
                wizcb.wizardEnableButtons(null, Boolean.valueOf(enable), this.m_canFinish ? null : Boolean.valueOf(false));
            }
            if ((diagcb = this.m_traversableContext.getDialogCallbacks()) != null) {
                diagcb.enableOKButton(enable);
            }
        }
    }

    protected class GlobalConnectionPanelUI2
    extends GlobalConnectionPanelUI {
        public GlobalConnectionPanelUI2(boolean showDetails) {
            super((String[])null, showDetails);
        }

        @Override
        protected void enableButtons(boolean validConn) {
            super.enableButtons(validConn);
            GlobalDatabaseConnPanel.this.enableExit(validConn);
        }
    }
}

