/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ideimpl.db.DatabaseIdePreferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.panels.AbstractConnectionPanelUI;

public class ConnectionPanelUI
extends AbstractConnectionPanelUI {
    private static final String LAST_CONNECTION_KEY = "ConnectionPanelUI.LAST_CONNECTION_KEY";
    private String m_noConnectionString;
    private DefaultComboBoxModel m_connectionsModel;
    private JComboBox m_connections;
    private Collection<ItemListener> m_listeners;
    private boolean m_listening;
    private ItemListener m_listener;

    public ConnectionPanelUI(boolean showDetails) {
        this(false, showDetails);
    }

    public ConnectionPanelUI(boolean oracleOnly, boolean showDetails) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        this(stringArray, showDetails);
    }

    public ConnectionPanelUI(String[] subTypes, boolean showDetails) {
        super(subTypes, showDetails);
        this.m_listening = true;
        this.resetConnections();
    }

    @Override
    protected String getComponentNamePrefix() {
        return "ConnectionPanelUI";
    }

    @Override
    protected Component getPicker() {
        return this.getPicker(false);
    }

    private Component getPicker(boolean forceCreate) {
        if (forceCreate || this.m_connections == null) {
            this.m_connectionsModel = new NonNullableComboBoxModel();
            this.m_connections = new JComboBox(this.m_connectionsModel);
            if (this.m_listener == null) {
                this.m_listener = new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        ConnectionPanelUI.this.fireStateChanged();
                    }
                };
            }
            this.m_connections.addItemListener(this.m_listener);
        }
        return this.m_connections;
    }

    public String getConnectionName() {
        String retval = (String)this.m_connectionsModel.getSelectedItem();
        if (ModelUtil.areEqual((Object)retval, (Object)this.m_noConnectionString)) {
            retval = null;
        }
        return retval;
    }

    public boolean setConnectionName(String name) {
        if (this.m_connectionsModel.getIndexOf(name) != -1) {
            this.m_connectionsModel.setSelectedItem(name);
            return true;
        }
        return false;
    }

    @Deprecated
    protected boolean getCanAddNull() {
        return false;
    }

    @Deprecated
    public void setCanAddNull(boolean boo) {
    }

    public final void setNoConnectionString(String noConn) {
        if (ModelUtil.areDifferent((Object)this.m_noConnectionString, (Object)noConn)) {
            this.m_noConnectionString = noConn;
            this.resetConnections();
        }
    }

    protected DatabaseConnections getConnections() {
        return DatabaseConnections.getInstance();
    }

    protected Collection<String> listConnections() {
        DatabaseConnections conns = this.getConnections();
        return conns == null ? Collections.emptyList() : conns.listConnections(this.getSubTypes());
    }

    public int resetConnections() {
        String cname = (String)this.m_connectionsModel.getSelectedItem();
        Collection<String> listed = this.listConnections();
        ArrayList<String> connections = new ArrayList<String>(listed);
        Collections.sort(connections);
        if (this.m_noConnectionString != null) {
            connections.add(0, this.m_noConnectionString);
        }
        if (this.areDifferent(connections, this.m_connectionsModel)) {
            this.m_listening = false;
            this.m_connectionsModel.removeAllElements();
            for (String connName : connections) {
                this.m_connectionsModel.addElement(connName);
            }
            if (!this.setConnectionName(cname)) {
                this.loadSettings();
            }
            this.m_listening = true;
            this.fireStateChanged();
        }
        return this.m_connectionsModel.getSize();
    }

    private boolean areDifferent(Collection<String> newConns, DefaultComboBoxModel model) {
        TreeSet<String> oldConns = new TreeSet<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            oldConns.add((String)model.getElementAt(i));
        }
        return !((Object)oldConns).equals(newConns);
    }

    @Override
    protected final ConnectionInfo getConnectionInfo() {
        String currConn = this.getConnectionName();
        DatabaseConnections conns = this.getConnections();
        if (conns != null && ModelUtil.hasLength((String)currConn)) {
            return new ConnectionInfo(conns.getStoreName(), currConn);
        }
        return null;
    }

    protected String getSettingsKey() {
        return LAST_CONNECTION_KEY;
    }

    protected PropertyStorage getPropertyStorage() {
        return DatabaseIdePreferences.getPreferences();
    }

    public void loadSettings() {
        String key = this.getSettingsKey();
        if (key != null) {
            String lastConn = this.getPropertyStorage().getProperties().getString(key);
            this.setConnectionName(lastConn);
        }
    }

    public void saveSettings() {
        String conn;
        String key = this.getSettingsKey();
        if (key != null && ModelUtil.hasLength((String)(conn = this.getConnectionName()))) {
            this.getPropertyStorage().getProperties().putString(key, conn);
        }
    }

    protected String runConnectionDialog(String conn) {
        return DatabaseConnectionEditor.editConnection("IdeConnections", conn);
    }

    @Override
    public void enableActiveComponents(boolean boo) {
        super.enableActiveComponents(boo);
        this.m_connections.setEnabled(boo);
    }

    private void fireStateChanged() {
        this.checkConnection();
        if (this.m_listeners != null) {
            ItemEvent ie = new ItemEvent(this.m_connections, 701, this.m_connections.getSelectedItem(), 1);
            for (ItemListener il : this.m_listeners) {
                il.itemStateChanged(ie);
            }
        }
    }

    @Override
    protected void launchConnectionDialog(boolean edit) {
        if (edit) {
            String newConn = this.runConnectionDialog(this.getConnectionName());
            if (this.resetConnections() <= 0 || ModelUtil.hasLength((String)newConn)) {
                // empty if block
            }
            if (this.m_connections != null && ModelUtil.areEqual((Object)this.m_connections.getSelectedItem(), (Object)newConn)) {
                this.fireStateChanged();
            } else {
                this.setConnectionName(newConn);
            }
        } else {
            String newConn = this.runConnectionDialog(null);
            if (this.resetConnections() <= 0 || ModelUtil.hasLength((String)newConn)) {
                // empty if block
            }
            this.setConnectionName(newConn);
        }
    }

    @Deprecated
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public Component getDefaultFocusComponent() {
        if (this.m_connectionsModel.getSize() < 1) {
            return super.getDefaultFocusComponent();
        }
        return this.m_connections;
    }

    @Deprecated
    public JComboBox getConnCombo() {
        return this.m_connections;
    }

    @Override
    public void addComboListener(ItemListener itemListener) {
        if (itemListener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new ArrayList<ItemListener>();
            }
            if (!this.m_listeners.contains(itemListener)) {
                this.m_listeners.add(itemListener);
            }
        }
    }

    @Override
    public void removeComboListener(ItemListener itemListener) {
        if (this.m_listeners != null && itemListener != null) {
            this.m_listeners.remove(itemListener);
        }
    }

    public static String getConnection(String title, String prompt, String connName, boolean oracleOnly) {
        ConnectionPanelUI panel = new ConnectionPanelUI(oracleOnly, true);
        panel.setConnectionPrompt(prompt);
        return ConnectionPanelUI.getConnection(panel, title, connName);
    }

    public static String getConnection(final ConnectionPanelUI panel, String title, String connName) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_odbselectconnection_html");
        final JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, (Component)panel.getDefaultFocusComponent(), (String)title);
        if (connName != null) {
            panel.setConnectionName(connName);
        }
        if (panel.m_noConnectionString == null) {
            panel.addComboListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean sel = panel.getConnectionName() != null;
                    dlg.setOKButtonEnabled(sel);
                }
            });
            dlg.setOKButtonEnabled(panel.getConnectionName() != null);
        }
        dlg.setMinimumSize(new Dimension(400, 200));
        dlg.setName(panel.getComponentNamePrefix() + "Dialog");
        return WizardLauncher.runDialog((JDialog)dlg) ? panel.getConnectionName() : null;
    }
}

