/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.controls;

import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.DBConnArb;

public class ConnectionPickerButton
extends MenuToolButton
implements ActionListener {
    private static final String DEFAULT_TEXT = " ";
    private Collection<ItemListener> m_listeners;
    private boolean m_useNameAsText = true;
    private String m_defaultStoreName;
    private Context m_ideContext;
    private ConnectionInfo m_connInfo;

    public ConnectionPickerButton(ConnectionInfo info) {
        this(info, null);
    }

    public ConnectionPickerButton(ConnectionInfo info, ToggleAction action) {
        super((ToggleAction)(action == null ? new DummyAction() : action));
        this.m_useNameAsText = action == null;
        this.m_connInfo = info == null ? new ConnectionInfo(null, null) : info;
        this.setFocusable(true);
        this.setFocusPainted(true);
        this.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                MenuToolButton.MenuToolButtonModel model = (MenuToolButton.MenuToolButtonModel)ConnectionPickerButton.this.getModel();
                model.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                MenuToolButton.MenuToolButtonModel model = (MenuToolButton.MenuToolButtonModel)ConnectionPickerButton.this.getModel();
                model.setSelected(false);
            }
        });
        this.makeDefaultSelection();
    }

    private void makeDefaultSelection() {
        DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
        ConnectionInfo defaultInfo = stores.getCurrentConnectionInfo(this.m_ideContext);
        if (defaultInfo == null || !defaultInfo.isValid() || !this.setSelectedConnection(defaultInfo)) {
            StoreMenu storeMenu;
            boolean done = false;
            DatabaseConnections conns = stores.getCurrentStore(this.m_ideContext);
            if (conns != null && (storeMenu = this.findStore(conns.getStoreName())) != null && this.selectFirstConnection(storeMenu.getPopupMenu())) {
                done = true;
            }
            if (!done) {
                this.selectFirstConnection(this.getPopupMenu());
            }
            if (!done) {
                this.selectConnection(null);
            }
        }
    }

    private boolean selectFirstConnection(JPopupMenu menu) {
        for (MenuElement me : menu.getSubElements()) {
            if (me instanceof ConnectionMenuItem) {
                this.selectConnection((ConnectionMenuItem)me);
                return true;
            }
            if (!(me instanceof StoreMenu) || !this.selectFirstConnection(((StoreMenu)me).getPopupMenu())) continue;
            return true;
        }
        return false;
    }

    public final void addConnectionListener(ItemListener il) {
        if (this.m_listeners == null) {
            this.m_listeners = new HashSet<ItemListener>();
        }
        this.m_listeners.add(il);
    }

    public final void removeConnectionListener(ItemListener il) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(il);
        }
    }

    private Context getContext() {
        return this.m_ideContext == null ? Context.newIdeContext() : this.m_ideContext;
    }

    public final void setContext(Context ideContext) {
        this.m_ideContext = ideContext;
        this.resetConnections();
    }

    protected final void resetConnections() {
        this.removeAllPopupItems();
        if (this.m_useNameAsText) {
            this.setText(DEFAULT_TEXT);
        }
        this.populateMenu(this.getPopupMenu());
        this.makeDefaultSelection();
    }

    protected Collection<String> listStores() {
        return DatabaseConnectionStores.getInstance().listStores(this.m_ideContext);
    }

    protected Collection<String> listConnections(DatabaseConnections dc) {
        return dc.listConnections();
    }

    protected DatabaseConnections getDefaultStore() {
        Collection<String> stores = this.listStores();
        if (stores.size() == 1) {
            return DatabaseConnectionStores.getInstance().getStore(stores.iterator().next());
        }
        return null;
    }

    protected final JPopupMenu createPopupMenu() {
        this._popup = new JPopupMenu();
        this.populateMenu(this._popup);
        return this._popup;
    }

    public final void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.m_useNameAsText) {
            JPopupMenu pop = this.getPopupMenu();
            pop.setMinimumSize(new Dimension(width, pop.getMinimumSize().height));
            pop.setPreferredSize(new Dimension(width, pop.getPreferredSize().height));
        }
    }

    private void populateMenu(JPopupMenu menu) {
        DatabaseConnections dc = this.getDefaultStore();
        this.m_defaultStoreName = null;
        boolean needBar = false;
        if (dc != null) {
            this.m_defaultStoreName = dc.getStoreName();
            for (String name : this.listConnections(dc)) {
                ConnectionMenuItem connMI = this.createConnectionMenuItem(this.m_defaultStoreName, name);
                connMI.addActionListener(this);
                menu.add(connMI);
                needBar = true;
            }
        }
        DatabaseConnectionStores stores = DatabaseConnectionStores.getInstance();
        Collection<String> storeNames = this.listStores();
        for (String storeName : storeNames) {
            if (!ModelUtil.areDifferent((Object)this.m_defaultStoreName, (Object)storeName)) continue;
            StoreMenu storeMI = this.createStoreMenu(storeName);
            DatabaseConnections store = stores.getStore(storeName);
            this.populateMenu(store, storeMI);
            if (needBar) {
                menu.add(new JSeparator());
                needBar = false;
            }
            menu.add(storeMI);
        }
    }

    private boolean populateMenu(DatabaseConnections dc, JMenu menu) {
        boolean added = false;
        TreeSet<String> conns = new TreeSet<String>(this.listConnections(dc));
        for (String name : conns) {
            ConnectionMenuItem connMI = this.createConnectionMenuItem(dc.getStoreName(), name);
            connMI.addActionListener(this);
            menu.add(connMI);
            added = true;
        }
        return added;
    }

    private StoreMenu createStoreMenu(String storeName) {
        return new StoreMenu(storeName);
    }

    private ConnectionMenuItem createConnectionMenuItem(String storeName, String connName) {
        return new ConnectionMenuItem(storeName, connName);
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof ConnectionMenuItem) {
            this.selectConnection((ConnectionMenuItem)source);
            MenuToolButton.MenuToolButtonModel model = (MenuToolButton.MenuToolButtonModel)this.getModel();
            model.setSelected(false);
        }
    }

    private String getSelectedText(ConnectionMenuItem connMI) {
        if (connMI == null) {
            return DEFAULT_TEXT;
        }
        StringBuilder buff = new StringBuilder(connMI.getConnectionName());
        String storeName = connMI.getStoreName();
        if (ModelUtil.areDifferent((Object)this.m_defaultStoreName, (Object)storeName)) {
            buff.append(" (");
            buff.append(DatabaseConnectionStores.getInstance().getShortLabel(storeName));
            buff.append(")");
        }
        return buff.toString();
    }

    public final ConnectionInfo getConnectionInfo() {
        return this.m_connInfo;
    }

    public final void setConnectionInfo(ConnectionInfo info) {
        if (info != null) {
            this.setSelectedConnection(info);
            this.m_connInfo = info;
        }
    }

    private boolean setSelectedConnection(ConnectionInfo info) {
        return this.setSelectedConnection(info.getStoreName(), info.getConnectionName());
    }

    private boolean setSelectedConnection(String storeName, String connName) {
        if (ModelUtil.hasLength((String)storeName) && ModelUtil.hasLength((String)connName)) {
            ConnectionMenuItem found;
            ConnectionMenuItem found2;
            JPopupMenu menu = this.getPopupMenu();
            if ((storeName == null || ModelUtil.areEqual((Object)this.m_defaultStoreName, (Object)storeName)) && (found2 = this.findConnection(menu.getSubElements(), connName)) != null) {
                this.selectConnection(found2);
                return true;
            }
            StoreMenu storeMenu = this.findStore(storeName);
            if (storeMenu != null && (found = this.findConnection(storeMenu.getPopupMenu().getSubElements(), connName)) != null) {
                this.selectConnection(found);
                return true;
            }
        }
        return false;
    }

    private void selectConnection(ConnectionMenuItem cmi) {
        String storeName = cmi == null ? null : cmi.getStoreName();
        String connName = cmi == null ? null : cmi.getConnectionName();
        String connInfoStoreName = this.m_connInfo.getStoreName();
        String connInfoConnectionName = this.m_connInfo.getConnectionName();
        if (ModelUtil.areDifferent((Object)connInfoStoreName, (Object)storeName) || ModelUtil.areDifferent((Object)connInfoConnectionName, (Object)connName)) {
            this.m_connInfo.setStoreName(storeName);
            this.m_connInfo.setConnectionName(connName);
            if (this.m_useNameAsText) {
                this.setText(this.getSelectedText(cmi));
            }
            if (this.m_listeners != null) {
                for (ItemListener l : this.m_listeners) {
                    l.itemStateChanged(new ItemEvent((ItemSelectable)((Object)this), 1, (Object)this.m_connInfo, 1));
                }
            }
            this.connectionSelected(this.m_connInfo);
        }
    }

    protected void connectionSelected(ConnectionInfo info) {
    }

    private ConnectionMenuItem findConnection(MenuElement[] elems, String connName) {
        for (MenuElement me : elems) {
            String elemName;
            if (!(me instanceof ConnectionMenuItem) || !connName.equals(elemName = ((ConnectionMenuItem)me).getConnectionName())) continue;
            return (ConnectionMenuItem)me;
        }
        return null;
    }

    private StoreMenu findStore(String storeName) {
        for (MenuElement me : this.getPopupMenu().getSubElements()) {
            String elemName;
            if (!(me instanceof StoreMenu) || !storeName.equals(elemName = ((StoreMenu)me).getStoreName())) continue;
            return (StoreMenu)me;
        }
        return null;
    }

    private static class DummyAction
    extends ToggleAction {
        public DummyAction() {
            super("", null);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ConnectionMenuItem
    extends JMenuItem {
        private String m_storeName;
        private String m_connName;

        public ConnectionMenuItem(String storeName, String connName) {
            super(connName);
            this.m_connName = connName;
            this.m_storeName = storeName;
        }

        public String getStoreName() {
            return this.m_storeName;
        }

        public String getConnectionName() {
            return this.m_connName;
        }
    }

    private class StoreMenu
    extends JMenu {
        private String m_storeName;

        public StoreMenu(String storeName) {
            super("IdeConnections".equals(storeName) ? DatabaseConnectionStores.getInstance().getShortLabel(storeName) : DBConnArb.format(56, DatabaseConnectionStores.getInstance().getShortLabel(storeName)));
            this.m_storeName = storeName;
        }

        public String getStoreName() {
            return this.m_storeName;
        }
    }
}

