/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Referenceable;
import javax.naming.event.EventContext;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingEvent;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import oracle.ide.Ide;
import oracle.ide.performance.PerformanceLogger;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.Connections;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DisconnectListener;
import oracle.jdeveloper.db.adapter.DatabaseContextManager;
import oracle.jdeveloper.db.adapter.DatabaseProvider;
import oracle.jdevimpl.db.DBConnAddin;
import oracle.jdevimpl.db.DBConnArb;
import oracle.jdevimpl.db.adapter.CADatabaseFactory;
import oracle.jdevimpl.db.adapter.DatabaseProviderHelper;
import oracle.jdevimpl.db.adapter.DefaultContextWrapper;

public class DatabaseConnections
implements Connections {
    private static DatabaseConnections s_instance;
    private static Logger s_logger;
    private final Map<String, Collection<Connection>> m_extraConns = new HashMap<String, Collection<Connection>>();
    private final Collection<ConnectionsListener> m_lists = new HashSet<ConnectionsListener>();
    private final Collection<DisconnectListener> m_distlists = new HashSet<DisconnectListener>();
    private DatabaseContextManager.ContextWrapper m_contextWrapper;
    private DatabaseFactory.ConnectionCreator m_connCreator;
    private String m_storeName;
    private ListenerBridge m_listBridge;
    private boolean m_privateStore;

    protected DatabaseConnections(String storeName, DatabaseContextManager.ContextWrapper contextWrapper, DatabaseFactory.ConnectionCreator connCreator) {
        this.m_storeName = storeName;
        this.m_contextWrapper = contextWrapper;
        this.m_connCreator = connCreator;
    }

    private DatabaseContextManager.ContextWrapper getWrapper() {
        if (this.isCentralStore()) {
            if (Ide.isRunning() && DBConnAddin.isStarting()) {
                throw new IllegalStateException(DBConnArb.getString(40));
            }
            if (this.m_contextWrapper == null) {
                this.m_contextWrapper = DatabaseContextManager.getContextWrapper();
                this.m_connCreator = DatabaseFactory.findConnectionCreator(CADatabaseFactory.class);
            }
        }
        if (this.m_contextWrapper == null) {
            throw new IllegalStateException(DBConnArb.getString(41));
        }
        Context connContext = this.m_contextWrapper.getDatabaseContext();
        if (connContext instanceof EventContext) {
            if (this.m_listBridge == null) {
                this.m_listBridge = new ListenerBridge();
            }
            try {
                this.m_listBridge.listenToContext((EventContext)connContext);
            }
            catch (NamingException nme) {
                DatabaseConnections.getLogger().warning("Couldn't register listener on context: " + nme);
                this.m_listBridge = null;
            }
        }
        return this.m_contextWrapper;
    }

    @Override
    public void addListener(ConnectionsListener l) {
        this.m_lists.add(l);
    }

    @Override
    public boolean removeListener(ConnectionsListener l) {
        return this.m_lists.remove(l);
    }

    protected Collection<ConnectionsListener> getListeners() {
        return Collections.unmodifiableCollection(new HashSet<ConnectionsListener>(this.m_lists));
    }

    @Override
    public void addDisconnectListener(DisconnectListener l) {
        this.m_distlists.add(l);
    }

    @Override
    public boolean removeDisconnectListener(DisconnectListener l) {
        return this.m_distlists.remove(l);
    }

    protected Collection<DisconnectListener> getDisconnectListeners() {
        return Collections.unmodifiableCollection(new HashSet<DisconnectListener>(this.m_distlists));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionAdded(ConnectionsEvent ce) {
        for (ConnectionsListener l : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                l.connectionAdded(ce);
            }
            catch (Exception e) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for add connection", time, l.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for add connection", time, l.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for add connection", time, l.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionRemoved(ConnectionsEvent ce) {
        for (ConnectionsListener l : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                l.connectionRemoved(ce);
            }
            catch (Exception e) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for remove connection", time, l.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for remove connection", time, l.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for remove connection", time, l.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionUpdated(ConnectionsEvent ce) {
        for (ConnectionsListener l : this.getListeners()) {
            long time = System.currentTimeMillis();
            try {
                l.connectionUpdated(ce);
            }
            catch (Exception e) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", e);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for update connection", time, l.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for update connection", time, l.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for update connection", time, l.getClass().getName());
        }
    }

    private String getMessage(Throwable e) {
        Throwable t;
        String msg = e.getLocalizedMessage();
        if ((!ModelUtil.hasLength((String)msg) || msg.equals("null")) && (t = e.getCause()) != null && t != e) {
            msg = this.getMessage(t);
        }
        return msg;
    }

    @Override
    public final Collection<String> listConnections() {
        long startTime = System.currentTimeMillis();
        Collection<String> retval = this.listConnectionsImpl();
        this.logReturningConnections(retval, startTime);
        return retval;
    }

    private void logReturningConnections(Collection<String> conns, long startTime) {
        this.logTiming("Returned {0} connections.", startTime, conns.size());
    }

    private Collection<String> listConnectionsImpl() {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            Context c = this.getWrapper().getDatabaseContext();
            if (c == null) {
                DatabaseConnections.getLogger().log(this.m_privateStore ? Level.FINE : Level.SEVERE, "DatabaseConnections has no JNDI context so cannot list connections.");
            } else {
                long startTime = System.currentTimeMillis();
                NamingEnumeration<NameClassPair> nenum = c.list("");
                while (nenum.hasMoreElements()) {
                    NameClassPair pair = (NameClassPair)nenum.nextElement();
                    if (!pair.getClassName().equals(DatabaseProvider.class.getName())) continue;
                    retval.add(pair.getName());
                }
                this.logTiming("Listing connections from CA", startTime, new Object[0]);
            }
        }
        catch (NamingException nme) {
            DatabaseConnections.getLogger().log(Level.SEVERE, DBConnArb.getString(29), nme);
        }
        return retval;
    }

    public final Collection<String> listConnections(boolean oracleOnly) {
        String[] stringArray;
        if (oracleOnly) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        return this.listConnections(stringArray);
    }

    public Collection<String> listConnections(String[] subTypes) {
        Collection<String> retval;
        long startTime = System.currentTimeMillis();
        if (subTypes != null) {
            Arrays.sort(subTypes);
        }
        if ((retval = this.listConnectionsImpl()).size() > 0 && subTypes != null) {
            for (String name : new ArrayList<String>(retval)) {
                try {
                    Properties props = this.getProperties(name);
                    String subtype = props.getProperty("subtype");
                    if (subtype != null && Arrays.binarySearch(subTypes, subtype) >= 0) continue;
                    retval.remove(name);
                }
                catch (ConnectionException ce) {
                    DatabaseConnections.getLogger().log(Level.WARNING, ce.getMessage(), ce);
                    retval.remove(name);
                }
            }
        }
        this.logReturningConnections(retval, startTime);
        return retval;
    }

    @Override
    public final Collection<String> listConnections(Properties filter) {
        long startTime = System.currentTimeMillis();
        Collection<String> allConns = this.listConnectionsImpl();
        if (filter == null || filter.size() == 0) {
            return allConns;
        }
        ArrayList<String> retval = new ArrayList<String>();
        for (String name : allConns) {
            boolean add = false;
            try {
                Properties connProps = this.getProperties(name);
                add = true;
                for (Object key : filter.keySet()) {
                    String filterVal = filter.getProperty((String)key);
                    String connVal = connProps.getProperty((String)key);
                    if (!ModelUtil.areDifferent((Object)connVal, (Object)filterVal)) continue;
                    add = false;
                    break;
                }
            }
            catch (ConnectionException ce) {
                // empty catch block
            }
            if (!add) continue;
            retval.add(name);
        }
        this.logReturningConnections(retval, startTime);
        return retval;
    }

    public final Connection getConnection(String connName) throws ConnectionException {
        try {
            Database db = this.getDatabase(connName);
            if (db == null) {
                throw new ConnectionException(DBConnArb.format(38, connName));
            }
            return db.getConnection();
        }
        catch (DBException dbe) {
            Throwable t = dbe.getCause() == null ? dbe : dbe.getCause();
            throw new ConnectionException(DBConnArb.format(30, connName, this.getMessage(t)), t);
        }
    }

    public final Connection getUniqueConnection(String connName) throws ConnectionException {
        Referenceable ref = this.getReferenceable(connName);
        if (ref instanceof DatabaseProvider) {
            try {
                Connection conn = ((DatabaseProvider)ref).getConnection();
                Collection<Connection> extraConns = this.m_extraConns.get(connName);
                if (extraConns == null) {
                    extraConns = new ArrayList<Connection>();
                    this.m_extraConns.put(connName, extraConns);
                }
                extraConns.add(conn);
                return conn;
            }
            catch (SQLException sqe) {
                throw new ConnectionException(DBConnArb.format(30, connName, this.getMessage(sqe)), sqe);
            }
        }
        throw new ConnectionException(DBConnArb.format(38, connName));
    }

    public final Connection getConnection(Properties props) throws ConnectionException {
        DatabaseProvider pro = this.newDatabaseProvider(null, props);
        try {
            return pro.getConnection();
        }
        catch (SQLException sqe) {
            throw new ConnectionException(DBConnArb.format(31, this.getMessage(sqe)), sqe);
        }
    }

    public final Database getDatabase(String connName) throws DBException {
        return this.getDatabase(connName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Database getDatabase(String connName, boolean create) throws DBException {
        try {
            if (this.getReferenceable(connName) == null) {
                return null;
            }
        }
        catch (ConnectionException ce) {
            // empty catch block
        }
        Database db = null;
        boolean foundStore = false;
        if (this.m_connCreator != null) {
            foundStore = true;
            if (create) {
                DatabaseFactory.ConnectionCreator connectionCreator = this.m_connCreator;
                synchronized (connectionCreator) {
                    db = this.m_connCreator.findDatabase(connName);
                    if (db == null && create) {
                        db = DatabaseFactory.createDatabase((String)connName, (DatabaseFactory.ConnectionCreator)this.m_connCreator);
                    }
                }
            } else {
                db = this.m_connCreator.findDatabase(connName);
            }
        }
        if (!foundStore && (db = (Database)DBObjectProviderFactory.findProvider((Object)connName)) == null && create) {
            db = (Database)DBObjectProviderFactory.findOrCreateProvider((Object)connName);
        }
        return db;
    }

    @Override
    public Referenceable getReferenceable(String connName) throws ConnectionException {
        if (connName == null) {
            return null;
        }
        try {
            Context c = this.getWrapper().getDatabaseContext();
            long time = System.currentTimeMillis();
            Object obj = c.lookup(connName);
            if (obj instanceof DatabaseProvider) {
                this.logTiming("... lookup of Referenceable from CA", time, new Object[0]);
                return (DatabaseProvider)obj;
            }
        }
        catch (NameNotFoundException nnfe) {
        }
        catch (NamingException nme) {
            throw new ConnectionException(DBConnArb.format(32, connName, this.getMessage(nme)), nme);
        }
        return null;
    }

    @Override
    public final Properties getProperties(String connName) throws ConnectionException {
        DatabaseProvider connPro = (DatabaseProvider)this.getReferenceable(connName);
        if (connPro != null) {
            return connPro.getProperties();
        }
        return null;
    }

    private DatabaseProvider newDatabaseProvider(String connName, Properties props) {
        if (this.m_privateStore) {
            props.setProperty("INTERNAL_STRINGS_TO_FILE", "true");
        }
        return new DatabaseProvider(connName, props);
    }

    @Override
    public void addConnection(String connName, Properties props) throws ConnectionException {
        long time = System.currentTimeMillis();
        DatabaseProvider connPro = this.newDatabaseProvider(connName, props);
        Context ctx = this.getWrapper().getDatabaseContext();
        try {
            PerformanceLogger logger = PerformanceLogger.get();
            String KEY = "DatabaseConnections.addConnection";
            logger.startTiming("DatabaseConnections.addConnection");
            ctx.bind(connName, (Object)connPro);
            logger.stopTiming("DatabaseConnections.addConnection", "bind of new connection to AdfJndiContext", 500);
            if (this.m_listBridge == null) {
                this.fireConnectionAdded(new ConnectionsEvent(connName, (Referenceable)connPro));
            }
        }
        catch (NameAlreadyBoundException nabe) {
            throw new ConnectionException(DBConnArb.format(39, connName));
        }
        catch (NamingException nme) {
            throw new ConnectionException(DBConnArb.format(34, connName, this.getMessage(nme)), nme);
        }
        this.logTiming("Total time for addConnection", time, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeConnection(String connName) throws ConnectionException {
        long time = System.currentTimeMillis();
        Referenceable removing = this.getReferenceable(connName);
        if (removing == null) {
            return false;
        }
        Context ctx = this.getWrapper().getDatabaseContext();
        try {
            if (!this.disconnect(connName, false)) {
                return false;
            }
            try {
                if (this.m_listBridge != null) {
                    this.m_listBridge.m_listening = false;
                }
                long bindtime = System.currentTimeMillis();
                ctx.unbind(connName);
                this.logTiming("... unbind from CA", bindtime, new Object[0]);
                this.closeDatabase(connName, true, (DatabaseProvider)removing, true);
            }
            finally {
                if (this.m_listBridge != null) {
                    this.m_listBridge.m_listening = true;
                }
            }
            this.logTiming("Total time for removeConnection", time, new Object[0]);
            return true;
        }
        catch (NameNotFoundException nnfe) {
            return false;
        }
        catch (NamingException nme) {
            throw new ConnectionException(DBConnArb.format(35, connName, this.getMessage(nme)), nme);
        }
    }

    private void closeDatabase(String connName, boolean uncacheDatabase, DatabaseProvider ref, boolean fireRemoved) {
        Database db;
        if (this.m_connCreator != null && (db = this.m_connCreator.findDatabase(connName)) != null) {
            db.close();
            if (uncacheDatabase) {
                this.m_connCreator.uncacheDatabase(connName);
            }
        }
        ref.disconnect();
        if (fireRemoved) {
            this.fireConnectionRemoved(new ConnectionsEvent(connName, (Referenceable)ref));
        }
    }

    @Override
    public boolean updateConnection(String connName, String newName, Properties newProps) throws ConnectionException {
        boolean rename;
        boolean propsChanged;
        DatabaseProvider connPro;
        long time = System.currentTimeMillis();
        DatabaseProvider oldConnPro = (DatabaseProvider)this.getReferenceable(connName);
        if (oldConnPro == null) {
            throw new ConnectionException(DBConnArb.format(38, connName));
        }
        if (newProps == null) {
            connPro = oldConnPro;
            propsChanged = false;
        } else {
            connPro = this.newDatabaseProvider(newName == null ? connName : newName, newProps);
            propsChanged = !connPro.equals((Object)oldConnPro);
        }
        boolean bl = rename = !connName.equals(newName);
        if (propsChanged || rename) {
            Context ctx = this.getWrapper().getDatabaseContext();
            boolean removed = false;
            try {
                String name;
                if (propsChanged) {
                    if (!this.disconnect(connName, false)) {
                        boolean bl2 = false;
                        return bl2;
                    }
                } else {
                    this.renameDatabase(connName, newName);
                }
                if (newName != null && newName.length() > 0 && rename) {
                    DatabaseProvider existing = (DatabaseProvider)this.getReferenceable(newName);
                    if (existing != null) {
                        throw new ConnectionException(DBConnArb.format(39, newName));
                    }
                    if (this.m_listBridge != null) {
                        this.m_listBridge.m_listening = false;
                    }
                    long bindtime = System.currentTimeMillis();
                    ctx.unbind(connName);
                    removed = true;
                    ctx.bind(newName, (Object)connPro);
                    this.logTiming("... rebind (bind/unbind) to CA", bindtime, new Object[0]);
                    name = newName;
                } else {
                    long bindtime = System.currentTimeMillis();
                    ctx.rebind(connName, (Object)connPro);
                    name = connName;
                    this.logTiming("... rebind to CA", bindtime, new Object[0]);
                }
                this.fireConnectionUpdated(new ConnectionsEvent(connName, name, (Referenceable)connPro));
            }
            catch (NamingException nme) {
                if (removed) {
                    try {
                        ctx.bind(connName, (Object)oldConnPro);
                    }
                    catch (NamingException e) {
                        DatabaseConnections.getLogger().log(Level.WARNING, "couldn't rollback remove of old connection", e);
                    }
                }
                throw new ConnectionException(DBConnArb.format(33, connName, this.getMessage(nme)), nme);
            }
            finally {
                if (this.m_listBridge != null) {
                    this.m_listBridge.m_listening = true;
                }
            }
            if (propsChanged) {
                this.closeDatabase(connName, true, oldConnPro, false);
            }
        }
        this.logTiming("Total time for updateConnection", time, new Object[0]);
        return true;
    }

    private void renameDatabase(String oldName, String newName) {
        if (this.m_connCreator != null) {
            this.m_connCreator.renameDatabase(oldName, newName);
        }
    }

    @Override
    public final void testConnection(Properties props) throws ConnectionException {
        DatabaseProvider connPro = this.newDatabaseProvider(null, props);
        Connection conn = null;
        try {
            conn = connPro.getConnection();
        }
        catch (Throwable e) {
            throw new ConnectionException(DBConnArb.format(36, this.getMessage(e)), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public final void disconnect(String connName) throws ConnectionException {
        this.disconnect(connName, false);
    }

    public final boolean disconnect(String connName, boolean force) throws ConnectionException {
        DatabaseProvider ref = (DatabaseProvider)this.getReferenceable(connName);
        if (ref != null) {
            return this.doDisconnect(connName, ref, force);
        }
        return false;
    }

    private boolean doDisconnect(String connName, DatabaseProvider ref, boolean force) throws ConnectionException {
        ConnectionsEvent ce = new ConnectionsEvent(connName, (Referenceable)ref);
        for (DisconnectListener l : this.getDisconnectListeners()) {
            try {
                if (l.canDisconnect(ce)) continue;
                if (force) {
                    DatabaseConnections.getLogger().log(Level.FINE, DBConnArb.format(44, connName, l.getClass().getName()));
                    continue;
                }
                DatabaseConnections.getLogger().log(Level.FINE, DBConnArb.format(43, connName, l.getClass().getName()));
                return false;
            }
            catch (Exception e) {
                DatabaseConnections.getLogger().log(Level.SEVERE, DBConnArb.format(45, l.getClass().getSimpleName()));
            }
        }
        this.closeDatabase(connName, false, ref, false);
        Collection<Connection> extraConns = this.m_extraConns.get(connName);
        if (extraConns != null) {
            Iterator<Connection> iter = extraConns.iterator();
            while (iter.hasNext()) {
                Connection conn = iter.next();
                try {
                    if (!conn.isClosed()) {
                        DatabaseConnections.getLogger().log(Level.FINE, DBConnArb.format(47, connName));
                        conn.close();
                    }
                    iter.remove();
                }
                catch (SQLException e) {
                    DatabaseConnections.getLogger().log(Level.FINE, DBConnArb.format(46, connName), e);
                }
            }
        }
        for (DisconnectListener l : this.getDisconnectListeners()) {
            try {
                l.connectionDisconnected(ce);
            }
            catch (Exception e) {
                DatabaseConnections.getLogger().log(Level.WARNING, DBConnArb.format(45, l.getClass().getSimpleName()));
            }
        }
        return true;
    }

    @Override
    public void saveConnections() throws ConnectionException {
        try {
            this.getWrapper().saveDatabaseContext();
        }
        catch (NamingException nme) {
            throw new ConnectionException(DBConnArb.format(37, this.getMessage(nme)), nme);
        }
    }

    public String getStoreName() {
        return this.m_storeName;
    }

    public boolean isCentralStore() {
        return "IdeConnections".equals(this.m_storeName);
    }

    private void logTiming(String msg, long start, Object ... params) {
        long millis = System.currentTimeMillis() - start;
        Logger logger = DatabaseConnections.getLogger();
        Level level = DBLog.getTimingLogLevel();
        if (millis > 50L && logger.isLoggable(level)) {
            if (params != null) {
                msg = MessageFormat.format(msg, params);
            }
            logger.log(level, "Timing: " + millis + "ms " + msg);
        }
    }

    private static Logger getLogger() {
        if (s_logger == null) {
            s_logger = DBLog.getLogger(DatabaseConnections.class);
        }
        return s_logger;
    }

    public static DatabaseConnections getInstance() {
        if (s_instance == null) {
            s_instance = new DatabaseConnections("IdeConnections", null, null);
        }
        return s_instance;
    }

    public static DatabaseConnections getPrivateInstance(URL url) {
        DefaultContextWrapper wrapper = new DefaultContextWrapper(url);
        DatabaseConnections dc = new DatabaseConnections(url.toString(), wrapper, new CADatabaseFactory(wrapper));
        dc.m_privateStore = true;
        return dc;
    }

    public static void useStandaloneConnectionStore() {
        if (Product.isJDeveloper()) {
            throw new IllegalStateException("The database connection store cannot be overridden in JDeveloper.");
        }
        if (Ide.isRunning() && !DBConnAddin.isStarting()) {
            DatabaseConnections.getLogger().log(Level.SEVERE, DBConnArb.getString(42));
        } else {
            DatabaseContextManager.setContextWrapper(DefaultContextWrapper.getInstance());
            DatabaseProviderHelper.setUTMode((boolean)true);
        }
    }

    private class ListenerBridge
    implements ObjectChangeListener,
    NamespaceChangeListener {
        private boolean m_listening = true;
        private EventContext m_context;

        private ListenerBridge() {
        }

        void listenToContext(EventContext context) throws NamingException {
            if (context != null && this.m_context != context) {
                if (this.m_context != null) {
                    try {
                        this.m_context.removeNamingListener(this);
                    }
                    catch (NamingException ne) {
                        DatabaseConnections.getLogger().warning("Couldn't remove listener from context: " + ne.getMessage());
                    }
                }
                this.m_context = null;
                context.addNamingListener("", 0, (NamingListener)this);
                this.m_context = context;
            }
        }

        @Override
        public void namingExceptionThrown(NamingExceptionEvent evt) {
        }

        @Override
        public void objectChanged(NamingEvent evt) {
            Binding binding;
            if (this.m_listening && (binding = evt.getNewBinding()).getObject() instanceof DatabaseProvider) {
                DatabaseConnections.this.fireConnectionUpdated(new ConnectionsEvent(evt.getOldBinding(), evt.getNewBinding()));
            }
        }

        @Override
        public void objectAdded(NamingEvent evt) {
            Binding binding;
            if (this.m_listening && (binding = evt.getNewBinding()).getObject() instanceof DatabaseProvider) {
                DatabaseConnections.this.fireConnectionAdded(new ConnectionsEvent(binding));
            }
        }

        @Override
        public void objectRemoved(NamingEvent evt) {
            Binding binding;
            Object ref;
            if (this.m_listening && (ref = (binding = evt.getOldBinding()).getObject()) instanceof DatabaseProvider) {
                String connName = binding.getName();
                try {
                    if (!DatabaseConnections.this.doDisconnect(connName, (DatabaseProvider)ref, false)) {
                        Context c = DatabaseConnections.this.getWrapper().getDatabaseContext();
                        try {
                            c.bind(connName, ref);
                        }
                        catch (NamingException ne) {
                            DatabaseConnections.getLogger().log(Level.WARNING, "Error encountered replacing connection (disconnect has been vetoed)", ne);
                        }
                    } else if (ref != null) {
                        DatabaseConnections.this.closeDatabase(connName, true, (DatabaseProvider)ref, true);
                    }
                }
                catch (ConnectionException ce) {
                    DatabaseConnections.getLogger().log(Level.WARNING, "Error encountered removing connection", ce);
                }
            }
        }

        @Override
        public void objectRenamed(NamingEvent evt) {
            Binding binding = evt.getNewBinding();
            if (binding.getObject() instanceof DatabaseProvider) {
                DatabaseConnections.this.fireConnectionUpdated(new ConnectionsEvent(evt.getOldBinding(), evt.getNewBinding()));
            }
        }
    }
}

