/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.awt.Window;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdevimpl.db.DBConnArb;

public class DatabaseActions
implements Controller {
    public static final int NEW_CONNECTION_ID = Ide.findOrCreateCmdID((String)"NewDatabaseConnectionCommand");
    public static final int DISONNECT_ID = Ide.findOrCreateCmdID((String)"DisconnectDatabaseCommand");
    public static final int IMPORT_ID = Ide.findOrCreateCmdID((String)"ImportDatabasesCommand");
    public static final int EXPORT_ID = Ide.findOrCreateCmdID((String)"ExportDatabasesCommand");
    public static final String EDIT_CONNECTION = "ConnectionName";
    public static final String CONNECTION_STORE = "ConnectionStore";
    private final DatabaseConnectionStores m_stores = DatabaseConnectionStores.getInstance();

    protected DatabaseActions() {
    }

    public static IdeAction getConnectionEditorAction() {
        IdeAction a = IdeAction.find((int)NEW_CONNECTION_ID);
        if (a == null) {
            String cmd = DBConnArb.getString(25);
            a = IdeAction.get((int)NEW_CONNECTION_ID, null, (String)StringUtils.stripMnemonic((String)cmd), null, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)cmd)), null, null, (boolean)true);
            a.addController((Controller)new DatabaseActions());
        }
        return a;
    }

    public static IdeAction getDisconnectAction() {
        IdeAction a = IdeAction.find((int)DISONNECT_ID);
        if (a == null) {
            String cmd = DBConnArb.getString(18);
            a = IdeAction.get((int)DISONNECT_ID, (String)StringUtils.stripMnemonic((String)cmd), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)cmd)));
            a.addController((Controller)new DatabaseActions());
        }
        return a;
    }

    public static IdeAction getImportAction() {
        IdeAction a = IdeAction.find((int)IMPORT_ID);
        if (a == null) {
            String cmd = DBConnArb.getString(19);
            a = IdeAction.get((int)IMPORT_ID, (String)StringUtils.stripMnemonic((String)cmd), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)cmd)));
        }
        return a;
    }

    public static IdeAction getExportAction() {
        IdeAction a = IdeAction.find((int)EXPORT_ID);
        if (a == null) {
            String cmd = DBConnArb.getString(20);
            a = IdeAction.get((int)EXPORT_ID, (String)StringUtils.stripMnemonic((String)cmd), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)cmd)));
        }
        return a;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id == NEW_CONNECTION_ID) {
            String connName = (String)action.getValue(EDIT_CONNECTION);
            String storeName = (String)action.getValue(CONNECTION_STORE);
            this.handleConnectionEditor(storeName, connName, context);
            return true;
        }
        if (id == DISONNECT_ID) {
            this.handleDisconnect(context);
            return true;
        }
        return false;
    }

    protected boolean handleDisconnect(Context context) {
        String conn;
        boolean disconnectOK = false;
        DatabaseConnections conns = this.m_stores.getCurrentStore(context);
        if (conns != null && (conn = this.m_stores.getCurrentConnection(context)) != null) {
            try {
                conns.disconnect(conn);
                disconnectOK = true;
            }
            catch (ConnectionException ce) {
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ce);
            }
        }
        return disconnectOK;
    }

    protected void handleConnectionEditor(String storeName, String name, Context c) {
        DatabaseConnections conns;
        if (!ModelUtil.hasLength((String)storeName) && (conns = this.m_stores.getCurrentStore(c)) != null) {
            storeName = conns.getStoreName();
        }
        DatabaseConnectionEditor.editConnection(storeName, name);
    }

    public boolean update(IdeAction action, Context context) {
        int id = action.getCommandId();
        if (id == NEW_CONNECTION_ID) {
            action.setEnabled(true);
            return true;
        }
        if (id == DISONNECT_ID) {
            boolean enabled;
            Element elem = context.getElement();
            boolean bl = enabled = this.m_stores.getCurrentConnection(context) != null;
            if (enabled && elem instanceof Node) {
                enabled = ((Node)elem).isOpen();
            }
            action.setEnabled(enabled);
            return true;
        }
        if (id == IMPORT_ID || id == EXPORT_ID) {
            action.setEnabled(false);
            return true;
        }
        return false;
    }
}

