/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import oracle.ide.panels.Traversable;

public class ConnectionTypeUIRegistry {
    public static final String CONNECTIONS_INSTANCE_KEY = "ConnectionsInstanceKey";
    public static final String CONNECTION_NAME_KEY = "ConnectionNameKey";
    public static final String CONNECTION_ORIG_NAME_KEY = "ConnectionOrigNameKey";
    public static final String[] EDITABLE_SYSDBA_SYSOPER = new String[]{null, "SYSDBA", "SYSOPER"};
    public static final String[] FIXED_NONE_SYSDBA_SYSOPER = new String[]{"", "SYSDBA", "SYSOPER"};
    private static ArrayList<String> m_orderedList = new ArrayList();
    private static HashMap<String, RegistryEntry> m_registryEntries = new HashMap();

    public static void registerConnectionTypeUI(String connectionType, String displayName, String usernameKey, String roleKey, String[] preSetRoleList, String passwordKey, String savePasswordKey, String deployPasswordKey, AlwaysNeverAsk savePassword, AlwaysNeverAsk deployPassword, Class panelClass, ConnectionTooltipProvider tooltipProvider) {
        ConnectionTypeUIRegistry.registerConnectionTypeUI(connectionType, displayName, usernameKey, roleKey, preSetRoleList, passwordKey, savePasswordKey, deployPasswordKey, savePassword, deployPassword, true, panelClass, tooltipProvider);
    }

    public static void registerConnectionTypeUI(String connectionType, String displayName, String usernameKey, String roleKey, String[] preSetRoleList, String passwordKey, String savePasswordKey, String deployPasswordKey, AlwaysNeverAsk savePassword, AlwaysNeverAsk deployPassword, boolean showConnectionTest, Class panelClass, ConnectionTooltipProvider tooltipProvider) {
        ConnectionTypeUIRegistry.unregisterConnectionType(connectionType);
        m_registryEntries.put(connectionType, new RegistryEntry(displayName, usernameKey, roleKey, preSetRoleList, passwordKey, savePasswordKey, deployPasswordKey, savePassword, deployPassword, showConnectionTest, panelClass, tooltipProvider));
        m_orderedList.add(connectionType);
    }

    public static void unregisterConnectionType(String connectionType) {
        if (m_registryEntries.containsKey(connectionType)) {
            m_registryEntries.remove(connectionType);
            m_orderedList.remove(connectionType);
        }
    }

    public static Collection<String> getConnectionTypes() {
        return m_orderedList;
    }

    public static String getDisplayName(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_displayName;
    }

    public static String getUsernameKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_usernameKey;
    }

    public static String getRoleKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_roleKey;
    }

    public static String[] getPreSetRoleList(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_preSetRoleList;
    }

    public static String getPasswordKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_passwordKey;
    }

    public static String getSavePasswordKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_savePasswordKey;
    }

    public static String getDeployPasswordKey(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_deployPasswordKey;
    }

    public static AlwaysNeverAsk getSavePassword(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_savePassword;
    }

    public static AlwaysNeverAsk getDeployPassword(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_deployPassword;
    }

    public static Class getPanelClass(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_panelClass;
    }

    public static ConnectionTooltipProvider getTooltipProvider(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? null : re.m_tooltipProvider;
    }

    public static boolean getShowConnectionTest(String connectionType) {
        RegistryEntry re = m_registryEntries.get(connectionType);
        return re == null ? true : re.m_showConnectionTest;
    }

    public static String getSubTypeFromDisplayName(String displayName) {
        String connectionType = null;
        if (displayName != null) {
            for (String key : m_registryEntries.keySet()) {
                RegistryEntry re = m_registryEntries.get(key);
                if (!displayName.equals(re.m_displayName)) continue;
                connectionType = key;
                break;
            }
        }
        return connectionType;
    }

    private static class RegistryEntry {
        private String m_displayName;
        private String m_usernameKey;
        private String m_roleKey;
        private String[] m_preSetRoleList;
        private String m_passwordKey;
        private String m_savePasswordKey;
        private String m_deployPasswordKey;
        private AlwaysNeverAsk m_savePassword;
        private AlwaysNeverAsk m_deployPassword;
        private boolean m_showConnectionTest;
        private Class m_panelClass;
        private ConnectionTooltipProvider m_tooltipProvider;

        public RegistryEntry(String displayName, String usernameKey, String roleKey, String[] preSetRoleList, String passwordKey, String savePasswordKey, String deployPasswordKey, AlwaysNeverAsk savePassword, AlwaysNeverAsk deployPassword, boolean showConnectionTest, Class panelClass, ConnectionTooltipProvider tooltipProvider) {
            this.m_displayName = displayName;
            this.m_usernameKey = usernameKey;
            this.m_roleKey = roleKey;
            this.m_preSetRoleList = preSetRoleList;
            this.m_passwordKey = passwordKey;
            this.m_savePasswordKey = savePasswordKey;
            this.m_deployPasswordKey = deployPasswordKey;
            this.m_savePassword = savePassword;
            this.m_deployPassword = deployPassword;
            this.m_showConnectionTest = showConnectionTest;
            if (!Traversable.class.isAssignableFrom(panelClass)) {
                throw new ClassCastException(panelClass.toString() + " is not Traversable");
            }
            this.m_panelClass = panelClass;
            this.m_tooltipProvider = tooltipProvider;
        }
    }

    public static interface ConnectionTooltipProvider {
        public String getTooltip(Properties var1);
    }

    public static enum AlwaysNeverAsk {
        ALWAYS,
        NEVER,
        ASK;

    }
}

