/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.utils;

import java.awt.Component;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import javax.swing.SwingUtilities;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.utils.ListenerReportsUtils;
import oracle.dbtools.listener.utils.ListenerZipFileHandler;
import oracle.dbtools.listener.utils.ListenerZipFileWriter;
import oracle.dbtools.listener.xml.ListenerImportAdmin;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.auth.CloudProtocolException;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.JSONNodeHandler;
import oracle.dbtools.raptor.cloud.connection.listener.ListenerConnectionType;
import oracle.dbtools.raptor.cloud.controls.CloudConnectionSelector;
import oracle.dbtools.rt.json.JSONNode;
import oracle.dbtools.rt.json.JSONObject;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.EntityUtils;

public class ListenerConnection {
    private static ListenerConnection _instance;
    private CConnections _connectionManager = null;
    private CConnection _connection = null;
    private String _connectionName;
    private String _errMsg;

    public static synchronized ListenerConnection getInstance() {
        if (_instance == null) {
            _instance = new ListenerConnection();
        }
        return _instance;
    }

    public boolean connectToListener() {
        this.setErrorMessage(null);
        if (this._connectionManager == null) {
            this._connectionManager = CConnections.getInstance((CConnectionType)ListenerConnectionType.getInstance());
        }
        this._connectionName = CloudConnectionSelector.getConnection((String)ListenerArb.getString("LISTENER_CONNECTION_TITLE"), (String)ListenerArb.getString("SELECT_CONNECTION"), (String)this._connectionName, (CConnectionType)ListenerConnectionType.getInstance());
        if (this._connectionName != null && !this._connectionName.isEmpty()) {
            try {
                this._connection = this._connectionManager.getConnection(this._connectionName, true);
                if (this._connection != null && this._connection.isOpen()) {
                    return true;
                }
            }
            catch (Exception exception) {
                this.displayExceptionMessage(ListenerArb.getString("CONNECT_ERROR_TITLE"), ListenerArb.format("CONNECT_FAILED", this.getConnectionName()), exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return false;
    }

    public void disconnectFromListener() {
        if (this.isConnectionOpen()) {
            if (this._connectionName != null) {
                this._connectionManager.closeConnection(this._connectionName);
            } else {
                System.out.println("Connection name is null");
            }
        }
    }

    public boolean retrieveSettings() {
        this.setErrorMessage(null);
        if (this.isConnectionOpen()) {
            try {
                final ListenerImportAdmin listenerImportAdmin = ListenerImportAdmin.getInstance();
                Boolean bl = (Boolean)this._connection.executeQuery("/_/conf", (ResponseHandler)new ListenerZipFileHandler<Boolean>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Boolean load(InputStream inputStream) throws IOException {
                        Boolean bl = new Boolean(false);
                        ZipInputStream zipInputStream = null;
                        ListenerZipFileWriter listenerZipFileWriter = null;
                        URL uRL = null;
                        try {
                            zipInputStream = new ZipInputStream(inputStream);
                            if (zipInputStream.available() <= 0) {
                                throw new IOException("Error zip file does not contain any content.");
                            }
                            URL uRL2 = ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.sqldeveloper.listener");
                            uRL = URLFileSystem.createTempFile((String)"retrieve", (String)".zip", (URL)uRL2);
                            listenerZipFileWriter = new ListenerZipFileWriter();
                            listenerZipFileWriter.writeFile(uRL.getPath(), zipInputStream);
                            listenerZipFileWriter.closeFile();
                            bl = listenerImportAdmin.importAdministration(uRL.getPath(), ListenerConnection.this.isAdminRole());
                        }
                        catch (IOException iOException) {
                            ListenerConnection.this.displayExceptionMessage(ListenerArb.getString("ADMIN_SETTINGS_TITLE"), ListenerArb.getString("ERROR_RETRIEVE_SETTINGS"), iOException);
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                            Boolean bl2 = new Boolean(false);
                            return bl2;
                        }
                        finally {
                            if (zipInputStream != null) {
                                zipInputStream.close();
                            }
                            if (listenerZipFileWriter != null) {
                                listenerZipFileWriter.closeFile();
                            }
                            if (URLFileSystem.exists((URL)uRL)) {
                                // empty if block
                            }
                        }
                        return new Boolean(bl);
                    }
                });
                if (bl.booleanValue()) {
                    return true;
                }
            }
            catch (Exception exception) {
                this.displayExceptionMessage(ListenerArb.getString("ADMIN_SETTINGS_TITLE"), ListenerArb.getString("ERROR_RETRIEVE_SETTINGS"), exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return false;
        }
        return false;
    }

    public boolean retrieveReports() {
        this.setErrorMessage(null);
        if (this.isConnectionOpen()) {
            try {
                Boolean bl = (Boolean)this._connection.executeQuery("/_/statistics/", (ResponseHandler)new JSONNodeHandler<Boolean>(){

                    protected Boolean build(JSONNode jSONNode) throws IOException {
                        Boolean bl = new Boolean(false);
                        try {
                            JSONObject jSONObject = (JSONObject)jSONNode;
                            ListenerReportsUtils listenerReportsUtils = new ListenerReportsUtils();
                            ListenerImportAdmin.getInstance().setReportData(listenerReportsUtils.getReportData(jSONObject));
                            ListenerConnection.this.retrieveErrorReport();
                            ListenerConnection.this.retrieveLogReport();
                            bl = true;
                        }
                        catch (Exception exception) {
                            ListenerConnection.this.displayExceptionMessage(ListenerArb.getString("ADMIN_SETTINGS_TITLE"), ListenerArb.getString("ERROR_RETRIEVE_SETTINGS"), exception);
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            return new Boolean(false);
                        }
                        return new Boolean(bl);
                    }
                });
                if (bl.booleanValue()) {
                    return true;
                }
            }
            catch (Exception exception) {
                this.displayExceptionMessage(ListenerArb.getString("ADMIN_SETTINGS_TITLE"), ListenerArb.getString("ERROR_RETRIEVE_SETTINGS"), exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return false;
        }
        return false;
    }

    public boolean retrieveErrorReport() {
        if (this.isConnectionOpen()) {
            try {
                Boolean bl = (Boolean)this._connection.executeQuery("/_/statistics/errors", (ResponseHandler)new JSONNodeHandler<Boolean>(){

                    protected Boolean build(JSONNode jSONNode) throws IOException {
                        Boolean bl = new Boolean(false);
                        try {
                            ListenerReportsUtils listenerReportsUtils = new ListenerReportsUtils();
                            JSONObject jSONObject = (JSONObject)jSONNode;
                            ListenerImportAdmin.getInstance().setErrorReport(listenerReportsUtils.getErrorReport(jSONObject));
                            bl = true;
                        }
                        catch (Exception exception) {
                            ListenerConnection.this.displayExceptionMessage(ListenerArb.getString("ADMIN_SETTINGS_TITLE"), ListenerArb.getString("ERROR_RETRIEVE_SETTINGS"), exception);
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            return new Boolean(false);
                        }
                        return new Boolean(bl);
                    }
                });
                if (bl.booleanValue()) {
                    return true;
                }
            }
            catch (Exception exception) {
                this.displayExceptionMessage(ListenerArb.getString("ADMIN_SETTINGS_TITLE"), ListenerArb.getString("ERROR_RETRIEVE_SETTINGS"), exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return false;
        }
        return false;
    }

    public boolean retrieveLogReport() {
        if (this.isConnectionOpen()) {
            try {
                Boolean bl = (Boolean)this._connection.executeQuery("/_/statistics/log", (ResponseHandler)new JSONNodeHandler<Boolean>(){

                    protected Boolean build(JSONNode jSONNode) throws IOException {
                        Boolean bl = new Boolean(false);
                        try {
                            ListenerReportsUtils listenerReportsUtils = new ListenerReportsUtils();
                            JSONObject jSONObject = (JSONObject)jSONNode;
                            ListenerImportAdmin.getInstance().setLogReport(listenerReportsUtils.getLogReport(jSONObject));
                            bl = true;
                        }
                        catch (Exception exception) {
                            ListenerConnection.this.displayExceptionMessage(ListenerArb.getString("ADMIN_SETTINGS_TITLE"), ListenerArb.getString("ERROR_RETRIEVE_SETTINGS"), exception);
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                            return new Boolean(false);
                        }
                        return new Boolean(bl);
                    }
                });
                if (bl.booleanValue()) {
                    return true;
                }
            }
            catch (Exception exception) {
                this.displayExceptionMessage(ListenerArb.getString("ADMIN_SETTINGS_TITLE"), ListenerArb.getString("ERROR_RETRIEVE_SETTINGS"), exception);
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean uploadSettings(URL uRL) {
        Boolean bl;
        block20: {
            this.setErrorMessage(null);
            bl = new Boolean(false);
            if (uRL != null && URLFileSystem.exists((URL)uRL)) {
                InputStreamEntity inputStreamEntity = null;
                FileInputStream fileInputStream = null;
                HttpPut httpPut = this._connection.createPut("/_/conf");
                fileInputStream = new FileInputStream(uRL.getPath());
                inputStreamEntity = new InputStreamEntity((InputStream)fileInputStream, -1L);
                inputStreamEntity.setContentType("application/zip");
                httpPut.setEntity((HttpEntity)inputStreamEntity);
                bl = (Boolean)this._connection.executeRequest((HttpUriRequest)httpPut, (ResponseHandler)new ResponseHandler<Boolean>(){

                    public Boolean handleResponse(HttpResponse httpResponse) {
                        StatusLine statusLine = httpResponse.getStatusLine();
                        int n = statusLine.getStatusCode();
                        if (n == 204 || n == 200) {
                            return new Boolean(true);
                        }
                        String string = ListenerArb.format("RESPONSE_STATUS", Integer.toString(n), statusLine.getReasonPhrase());
                        ListenerConnection.this.setErrorMessage(string);
                        return new Boolean(false);
                    }
                });
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (inputStreamEntity != null) {
                    try {
                        EntityUtils.consume((HttpEntity)inputStreamEntity);
                    }
                    catch (Exception exception) {
                        inputStreamEntity = null;
                    }
                }
                break block20;
                catch (Exception exception) {
                    try {
                        this.displayExceptionMessage(ListenerArb.getString("ADMIN_UPLOAD_TITLE"), ListenerArb.getString("UPLOAD_FAILED"), exception);
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                    catch (Throwable throwable) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (inputStreamEntity != null) {
                            try {
                                EntityUtils.consume(inputStreamEntity);
                            }
                            catch (Exception exception2) {
                                inputStreamEntity = null;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (inputStreamEntity != null) {
                        try {
                            EntityUtils.consume((HttpEntity)inputStreamEntity);
                        }
                        catch (Exception exception3) {
                            inputStreamEntity = null;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public boolean isConnectionOpen() {
        return this._connection != null && this._connection.isOpen();
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    private void setErrorMessage(String string) {
        this._errMsg = string;
    }

    public String getErrorMessage() {
        if (this._errMsg != null) {
            return this._errMsg;
        }
        return "";
    }

    public URI getURI() {
        if (this._connection != null) {
            return this._connection.getRoot();
        }
        return null;
    }

    public boolean isAdminRole() {
        return true;
    }

    public void displayExceptionMessage(String string, String string2, Throwable throwable) {
        ExceptionDialogRunnable exceptionDialogRunnable = new ExceptionDialogRunnable(string, string2, throwable);
        if (SwingUtilities.isEventDispatchThread()) {
            exceptionDialogRunnable.run();
        } else {
            try {
                SwingUtilities.invokeLater(exceptionDialogRunnable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ExceptionDialogRunnable
    implements Runnable {
        Throwable m_ex;
        String m_msg;
        String m_title;

        public ExceptionDialogRunnable(String string, String string2, Throwable throwable) {
            this.m_title = string;
            this.m_msg = string2;
            this.m_ex = throwable instanceof CConnectionException && throwable.getCause() != null ? throwable.getCause() : throwable;
        }

        @Override
        public void run() {
            String string;
            Frame frame = IdeUtil.getMainWindow();
            if (this.m_ex instanceof AuthenticationFailedException) {
                CloudProtocolException cloudProtocolException = (CloudProtocolException)this.m_ex;
                Throwable throwable = cloudProtocolException.getCause();
                String string2 = throwable != null ? throwable.getLocalizedMessage() : cloudProtocolException.getLocalizedMessage();
                string = this.m_msg != null ? this.m_msg.concat(System.getProperty("line.separator")).concat(string2) : string2;
                this.m_title = CloudBrowserResources.getString((String)"AUTHORIZATION_FAILURE_TITLE");
            } else {
                string = this.m_msg != null ? this.m_msg.concat(System.getProperty("line.separator")).concat(this.m_ex.getLocalizedMessage()) : this.m_ex.getLocalizedMessage();
            }
            MessageDialog.error((Component)frame, (Object)string, (String)this.m_title, null);
        }
    }
}

