/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.ui.ListenerNamePanel;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class ListenerNewAdminDialog
implements ActionListener {
    private JEWTDialog _adminDialog;
    private ListenerNamePanel _panel;
    private String _name;
    private String _descrip;
    private String _title;
    private String _errMsg;

    public ListenerNewAdminDialog(String string) {
        this._title = string;
        this.init();
    }

    private void init() {
        this._panel = new ListenerNamePanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._panel, "f1_listenernewadmin_html");
        this._adminDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)this._panel, null, (String)this._title, (int)14);
        this._adminDialog.addActionListener((ActionListener)this);
        this._adminDialog.setMinimumSize(this._panel.getPreferredSize());
        Dimension dimension = this._adminDialog.getPreferredSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth() + 100;
        this._adminDialog.setSize(n2, n);
        this._adminDialog.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._adminDialog);
    }

    private boolean validInfo() {
        if (this._panel.getName() == null || this._panel.getName().isEmpty() || this._panel.getName().trim().length() == 0) {
            this._errMsg = ListenerArb.getString("ADMIN_ERR_NAME_REQUIRED");
            return false;
        }
        return true;
    }

    private void assignValues() {
        this._name = this._panel.getName().trim();
        this._descrip = this._panel.getDescription().trim();
    }

    public void assignValues(ListenerModel listenerModel) {
        listenerModel.setName(this._name);
        listenerModel.setDescription(this._descrip);
    }

    public boolean runDialog() {
        return this._adminDialog.runDialog();
    }

    private void showError() {
        MessageDialog.error((Component)this._adminDialog, (Object)this._errMsg, (String)ListenerArb.getString("ADMIN_ERROR_TITLE"), null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.validInfo()) {
            this.assignValues();
            this._adminDialog.dispose();
        } else {
            this.showError();
        }
    }
}

