/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerLogOptionsPanel
extends ListenerSettings {
    private JCheckBox _logging;
    private JCheckBox _keepLogMessages;
    private NumericSpinBox _maxLogEntries;
    private JTextField _totalLogEntries;
    private JButton _clearLogEntriesBtn;

    public ListenerLogOptionsPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._logging = new JCheckBox();
        this._keepLogMessages = new JCheckBox();
        this._totalLogEntries = new JTextField();
        this._clearLogEntriesBtn = new JButton();
        this._maxLogEntries = new NumericSpinBox(1, 100000);
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resButton((AbstractButton)this._logging, (String)ListenerArb.getString("LOGGING"));
        ResourceUtils.resButton((AbstractButton)this._keepLogMessages, (String)ListenerArb.getString("KEEP_RECENT_LOG_MSGS"));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._maxLogEntries, (String)ListenerArb.getString("MAX_LOG_ENTRIES"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._totalLogEntries, (String)ListenerArb.getString("TOTAL_LOG_ENTRIES"));
        ResourceUtils.resButton((AbstractButton)this._clearLogEntriesBtn, (String)ListenerArb.getString("CLEAR_ENTRIES_BUTTON"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 22, 0, new Insets(6, 8, 0, 6), 0, 0));
        jPanel.add((Component)this._maxLogEntries, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 22, 0, new Insets(6, 8, 8, 6), 0, 0));
        jPanel.add((Component)this._totalLogEntries, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 23, 2, new Insets(6, 0, 8, 5), 0, 0));
        jPanel.add((Component)this._clearLogEntriesBtn, new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 23, 0, new Insets(6, 0, 8, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)this._logging, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 8, 0, 8), 0, 0));
        jPanel2.add((Component)this._keepLogMessages, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 8, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, n, 1, 1, 0.5, 0.0, 21, 0, new Insets(2, 8, 0, 8), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, ++n, 1, 1, 0.5, 0.0, 21, 0, new Insets(2, 8, 0, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel3, (String)ListenerArb.getString("LOGGING"));
        n = 0;
        this.add((Component)jPanel3, new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 2, new Insets(6, 8, 0, 8), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setLastRow(n);
        this._clearLogEntriesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListenerLogOptionsPanel.this._totalLogEntries.setText(Integer.toString(0));
                ListenerLogOptionsPanel.this._clearLogEntriesBtn.setEnabled(false);
            }
        });
    }

    private void enableDisableLogEntries() {
        this._maxLogEntries.setEnabled(this._keepLogMessages.isSelected());
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Logging");
        this.assignSettings(this._model);
        if (this._model != null && this._model.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            this._totalLogEntries.setText(Integer.toString(listenerReportSettings.getTotalLogEntries()));
            this._totalLogEntries.setEnabled(false);
            this._clearLogEntriesBtn.setEnabled(listenerReportSettings.getTotalLogEntries() > 0);
        }
        this._keepLogMessages.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    ListenerLogOptionsPanel.this.enableDisableLogEntries();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.enableDisableLogEntries();
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            this._keepLogMessages.setSelected(listenerReportSettings.isKeepLogMessages());
            this._maxLogEntries.setIntValue(listenerReportSettings.getMaxLogEntries());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            listenerReportSettings.setLogging(this._logging.isSelected());
            listenerReportSettings.setKeepLogMessages(this._keepLogMessages.isSelected());
            listenerReportSettings.setMaxLogEntries(this._maxLogEntries.getIntValue());
            listenerReportSettings.setTotalLogEntries(Integer.parseInt(this._totalLogEntries.getText()));
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
        this.updateNumericSpinBoxHandler(this._maxLogEntries, listenerReportSettings.getMaxLogEntries());
        this.updateCheckBoxHandler(this._logging, listenerReportSettings.isLogging());
        this.updateCheckBoxHandler(this._keepLogMessages, listenerReportSettings.isKeepLogMessages());
    }
}

