/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.listener.model.ListenerModel;
import oracle.dbtools.listener.model.ListenerReportSettings;
import oracle.dbtools.listener.ui.ListenerSettings;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.util.ResourceUtils;

public class ListenerErrorOptionsPanel
extends ListenerSettings {
    private JCheckBox _debugging;
    private JCheckBox _displayErrMessages;

    public ListenerErrorOptionsPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this._debugging = new JCheckBox();
        this._displayErrMessages = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this._debugging, (String)ListenerArb.getString("DEBUG_MSG_CONSOLE"));
        ResourceUtils.resButton((AbstractButton)this._displayErrMessages, (String)ListenerArb.getString("ERROR_MSG_BROWSER"));
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._debugging, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel.add((Component)this._displayErrMessages, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel2.add(Box.createGlue(), new GridBagConstraints(1, n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)ListenerArb.getString("ERROR_REPORTING"));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 21, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel3.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addSettingsPanel(jPanel3);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel, ListenerModel listenerModel2) {
        this.initSettings(listenerModel, listenerModel2, "Environment");
        this.assignSettings(this._model);
    }

    @Override
    public void assignSettings(ListenerModel listenerModel) {
        if (listenerModel != null && listenerModel.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
            this._debugging.setSelected(listenerReportSettings.isDebugging());
            this._displayErrMessages.setSelected(listenerReportSettings.isDisplayErrorMessages());
            if (this._parentModel != null) {
                this.highlightGlobalValues(this._parentModel);
            }
        }
    }

    @Override
    public ListenerModel getSettings() {
        if (this._model != null && this._model.getReportSettings() != null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            listenerReportSettings.setDebugging(this._debugging.isSelected());
            listenerReportSettings.setDisplayErrorMessages(this._displayErrMessages.isSelected());
        }
        return this._model;
    }

    @Override
    public void highlightGlobalValues(ListenerModel listenerModel) {
        ListenerReportSettings listenerReportSettings = listenerModel.getReportSettings();
        this.updateCheckBoxHandler(this._debugging, listenerReportSettings.isDebugging());
        this.updateCheckBoxHandler(this._displayErrMessages, listenerReportSettings.isDisplayErrorMessages());
    }

    @Override
    public boolean isGlobalSettingsChange() {
        if (this._parentModel == null) {
            ListenerReportSettings listenerReportSettings = this._model.getReportSettings();
            if (this._debugging.isSelected() != listenerReportSettings.isDebugging() || this._displayErrMessages.isSelected() != listenerReportSettings.isDisplayErrorMessages()) {
                return true;
            }
        }
        return false;
    }
}

