/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.listener.conn;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.listener.ListenerArb;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.listener.ListenerConnectionPanel;
import oracle.dbtools.raptor.cloud.connection.listener.ListenerConnectionType;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.Ide;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;

public class ManageConnectionsPanel
implements Traversable {
    private static final String ADD_CMD = "add";
    private static final String REMOVE_CMD = "remove";
    private static final Dimension BUTTON_DIMENSION = new Dimension(20, 20);
    private static final String INFO_KEY = "CConnectionInfo.list";
    private JPanel m_panel;
    private JList m_lstConns = new JList();
    private ListenerConnectionPanel m_pnlDetails = new ListenerConnectionPanel();
    private JButton m_btnAdd = new JButton();
    private JButton m_btnRemove = new JButton();
    private DefaultListModel m_mdlConns = new DefaultListModel();

    public static void manageConnections() {
        String string2;
        CConnections cConnections = CConnections.getInstance((CConnectionType)ListenerConnectionType.getInstance());
        Namespace namespace = cConnections.listConnections();
        CConnectionInfo[] cConnectionInfoArray = new CConnectionInfo[((String[])namespace).length];
        int n = 0;
        for (String string2 : namespace) {
            cConnectionInfoArray[n++] = cConnections.getConnectionInfo(string2);
        }
        Namespace namespace2 = new Namespace();
        namespace2.put(INFO_KEY, (Object)cConnectionInfoArray);
        ManageConnectionsPanel manageConnectionsPanel = new ManageConnectionsPanel();
        String string3 = StringUtils.stripMnemonic((String)ListenerArb.get("MENU_MANAGE_CONNECTION"));
        string2 = new TDialogLauncher((Component)Ide.getMainWindow(), string3, (Traversable)manageConnectionsPanel, namespace2);
        string2.setPackDialog(true);
        string2.initDialog().setInitialFocus(manageConnectionsPanel.getInitialFocusComponent());
        string2.initDialog().getAccessibleContext().setAccessibleName(string3);
        string2.showDialog();
    }

    public void onEntry(TraversableContext traversableContext) {
        CConnectionInfo[] cConnectionInfoArray;
        for (CConnectionInfo cConnectionInfo : cConnectionInfoArray = (CConnectionInfo[])traversableContext.get(INFO_KEY)) {
            this.m_mdlConns.addElement(cConnectionInfo);
        }
    }

    public Component getComponent() {
        if (this.m_panel == null) {
            JPanel jPanel = LayoutControl.GBC.createPanel();
            jPanel.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_lstConns, (String)ListenerArb.getString("LISTENER_CONNECTIONS"));
            jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            this.m_lstConns.setSelectionMode(0);
            this.m_lstConns.setModel(this.m_mdlConns);
            this.m_lstConns.addListSelectionListener(new SelectionTracker());
            this.m_lstConns.setCellRenderer(new Display());
            JScrollPane jScrollPane = new JScrollPane(this.m_lstConns);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            jScrollPane.setPreferredSize(new Dimension(150, 100));
            jPanel.add((Component)jScrollPane, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
            JPanel jPanel2 = LayoutControl.GBC.createPanel();
            jPanel2.setLayout(new GridBagLayout());
            ButtonHandler buttonHandler = new ButtonHandler();
            this.m_btnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
            this.m_btnAdd.setActionCommand(ADD_CMD);
            this.m_btnAdd.setMinimumSize(BUTTON_DIMENSION);
            this.m_btnAdd.setPreferredSize(BUTTON_DIMENSION);
            this.m_btnAdd.addActionListener(buttonHandler);
            jPanel2.add((Component)this.m_btnAdd, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            this.m_btnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
            this.m_btnRemove.setActionCommand(REMOVE_CMD);
            this.m_btnRemove.setMinimumSize(BUTTON_DIMENSION);
            this.m_btnRemove.setPreferredSize(BUTTON_DIMENSION);
            this.m_btnRemove.addActionListener(buttonHandler);
            jPanel2.add((Component)this.m_btnRemove, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel.add((Component)jPanel2, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.NONE, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.PAGE_START));
            JPanel jPanel3 = LayoutControl.GBC.createPanel();
            jPanel3.setLayout(new GridBagLayout());
            jPanel3.add((Component)LayoutControl.GBC.createSubPanel((Component)jPanel), LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)2, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
            jPanel3.add((Component)LayoutControl.GBC.createSubPanel((Component)this.m_pnlDetails.getComponent()), LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X, (LayoutControl.GBC.Anchor)LayoutControl.GBC.Anchor.PAGE_START));
            jPanel3.add(Box.createVerticalGlue(), LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.NONE, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.Y));
            this.m_panel = LayoutControl.GBC.createDialogMainPanel((Component)jPanel3);
        }
        return this.m_panel;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
    }

    public String getHelpID() {
        return null;
    }

    public Object getExitTransition() {
        return null;
    }

    public Component getInitialFocusComponent() {
        return this.m_lstConns;
    }

    private class Display
    extends DefaultListCellRenderer {
        private Display() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof CConnectionInfo) {
                object = ((CConnectionInfo)object).getName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private class SelectionTracker
    implements ListSelectionListener {
        private CConnectionInfo m_info;

        private SelectionTracker() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CConnectionInfo cConnectionInfo = (CConnectionInfo)ManageConnectionsPanel.this.m_lstConns.getSelectedValue();
            if (cConnectionInfo != this.m_info) {
                if (this.m_info != null) {
                    // empty if block
                }
                this.m_info = cConnectionInfo;
                if (this.m_info != null) {
                    ManageConnectionsPanel.this.m_btnRemove.setEnabled(true);
                } else {
                    ManageConnectionsPanel.this.m_btnRemove.setEnabled(false);
                }
            }
        }
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (ManageConnectionsPanel.ADD_CMD.equals(string) || ManageConnectionsPanel.REMOVE_CMD.equals(string)) {
                // empty if block
            }
        }
    }
}

