/*
 * Decompiled with CFR 0.152.
 */
package oracle.classloader.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.ThrowableAnnotation;

public class SerializableAnnotation
implements ThrowableAnnotation,
Serializable {
    private String description;
    private String stackTrace;

    public SerializableAnnotation(Throwable error, ThrowableAnnotation annotation) {
        this.description = annotation.getDescription();
        this.stackTrace = annotation.getStackTrace(error);
    }

    public String getDescription() {
        return this.description;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(Throwable error, PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            stream.println(error);
            stream.println(this.stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(Throwable error, PrintWriter stream) {
        PrintWriter printWriter = stream;
        synchronized (printWriter) {
            stream.println(error);
            stream.println(this.stackTrace);
        }
    }

    public String getStackTrace(Throwable error) {
        return error + ClassLoadLogger.EOL + this.stackTrace;
    }
}

